/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class RefineDefaultAggregationProperties
extends Transformation {
    public RefineDefaultAggregationProperties() {
        this.mName = "Refine dataItem aggregation default settings";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem v5DataItem = (V5DataItem)node;
        String valueRollupAggregate = v5DataItem.getRollupAggregateProperty();
        String valueAggregate = v5DataItem.getAggregateProperty();
        if (valueRollupAggregate == null) {
            v5DataItem.setRollupAggregateProperty("automatic");
        }
        if (valueAggregate == null) {
            v5DataItem.setAggregateProperty("automatic");
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        String valueRollupAggregate = v5DataItem.getRollupAggregateProperty();
        String valueAggregate = v5DataItem.getAggregateProperty();
        if (valueRollupAggregate != null && valueAggregate != null) {
            this.traceNodeCondition(false, "The 'rollupAggregate' and 'aggregate' property values have been set already.", trace);
            return false;
        }
        return true;
    }
}

