/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class SubstituteLikeForOLAP
extends Transformation {
    public SubstituteLikeForOLAP() {
        this.mName = "Substitute LIKE for OLAP query.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{201004};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5LiteralValue literal = (V5LiteralValue)node.getFirstChildByType(201026);
        String str = literal.getValue().toString();
        IXQEQueryNode newExpression = null;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        switch (this.getWildcardPattern(node)) {
            case CONTAINS: {
                str = str.substring(1, str.length() - 1);
                newExpression = nodeFactory.createNode(201005);
                break;
            }
            case ENDS_WITH: {
                str = str.substring(1);
                newExpression = nodeFactory.createNode(201007);
                break;
            }
            case STARTS_WITH: {
                str = str.substring(0, str.length() - 1);
                newExpression = nodeFactory.createNode(201006);
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
        }
        literal.setValue(str);
        node.exchange(newExpression, true);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        String msg = "LIKE statement in OLAP query is replaced by ";
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query.isTabular()) {
            status = false;
            msg = "Query is not OLAP.";
        }
        if (status) {
            switch (this.getWildcardPattern(node)) {
                case CONTAINS: {
                    msg = msg + "CONTAINS statement";
                    break;
                }
                case ENDS_WITH: {
                    msg = msg + "ENDS WITH statement";
                    break;
                }
                case STARTS_WITH: {
                    msg = msg + "STARTS WITH statement";
                    break;
                }
                default: {
                    msg = "Unknown pattern";
                    status = false;
                }
            }
        }
        this.traceQueryCondition(status, msg, trace);
        return status;
    }

    WildCardPattern getWildcardPattern(IXQEQueryNode node) {
        String str;
        String pattern = "%";
        String patternSingleChar = "_";
        V5LiteralValue literal = (V5LiteralValue)node.getFirstChildByType(201026);
        if (literal != null && !(str = literal.getValue().toString()).startsWith("_") && !str.endsWith("_")) {
            if (str.startsWith("%")) {
                if (str.endsWith("%")) {
                    if ("%".equals(str)) {
                        return WildCardPattern.UNKNOWN;
                    }
                    return WildCardPattern.CONTAINS;
                }
                return WildCardPattern.ENDS_WITH;
            }
            if (str.endsWith("%")) {
                return WildCardPattern.STARTS_WITH;
            }
        }
        return WildCardPattern.UNKNOWN;
    }

    static enum WildCardPattern {
        CONTAINS,
        ENDS_WITH,
        STARTS_WITH,
        UNKNOWN;

    }
}

