/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.InitializeDMRQuery;
import com.cognos.xqe.transformation.v5.tabstream.dmrtorel.DMRToRelUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class UnwindDMRToRelational
extends Transformation {
    public UnwindDMRToRelational() {
        this.mName = "Unwind DMR Objects.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{101055};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        String qName = qrd.getRefQueryProperty();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(qName);
        if (DMRToRelUtil.needUnwindDMRToRelational(qrd, query)) {
            this.traceNodeCondition(true, "need to unwind some DMR objects items in the query.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Can't unwind DMR objects.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        String qName = qrd.getRefQueryProperty();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(qName);
        DMRToRelUtil.unwindDMRToRelational(environment, qrd, query);
        InitializeDMRQuery transformation = new InitializeDMRQuery(this.mPassNumbers);
        ((Transformation)transformation).apply((IXQEQueryNode)query, environment);
    }
}

