/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.decomposition.DecomposeScalarFunction;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;

public class ValidateV5Expression
extends Transformation {
    protected static final String PROP_VALIDATED = "Validated";
    private static final int THREE = 3;

    public ValidateV5Expression() {
        this.mPassNumbers = new int[]{2};
        this.mName = "V5 Expression Coercion.";
        this.mTypes = new int[]{101004, 101013};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode parent;
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query.isDMR() && 101013 == node.getType() && (parent = node.getParent()).getType() == 101008 && DecomposeScalarFunction.isPushedDetailFilterForDMR((V5DetailFilter)parent, true)) {
            node.setPropertyValue(PROP_VALIDATED, Boolean.TRUE);
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        if (node.getChild(0).getType() != 101003) {
            if (!node.getChild(0).isOfCategory(201120)) {
                node.getChild(0).throwInternalError("!V5ExpNodeTypeEnum.V5_SIMPLE_NODE");
            }
            switch (this.validateExpression((V5SimpleNode)node.getChild(0), params)) {
                case InvalidFunctionParameter: {
                    Object[] pars = params.toArray();
                    XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_InvalidFunctionParameter, (String)pars[0], (String)pars[1], (String)pars[2], query.getRootQueryName(), (String)pars[3], node);
                    throw new XQEOlapUnsupportedQueryException(message);
                }
                case InvalidCoercion: {
                    Object[] pars = params.toArray();
                    query = (V5Query)node.getAncestorOfType(101006);
                    throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidCoercion, pars[0], pars[1], pars[2], pars[3], pars[4]);
                }
                case OK: {
                    break;
                }
                default: {
                    node.getChild(0).throwInternalError("validateExpression() !InvalidCoercion && !OK");
                }
            }
        }
        node.setPropertyValue(PROP_VALIDATED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() == 0) {
            this.traceNodeCondition(false, "Empty expression.", trace);
            return false;
        }
        if (node.getPropertyValue(PROP_VALIDATED) != null) {
            this.traceNodeCondition(false, "Node has been validated.", trace);
            return false;
        }
        return true;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query.isTabular()) {
            XQETrace trace = environment.getTrace();
            this.traceNodeCondition(false, "Expression in the tabular query.", trace);
            return false;
        }
        return true;
    }

    protected ErrorCode validateExpression(V5SimpleNode node, ArrayList<String> params) {
        IXQEQueryNode[] children;
        for (IXQEQueryNode current : children = node.getChildren()) {
            V5SimpleNode exp;
            ErrorCode errCode;
            if (!current.isOfCategory(201120) || (errCode = this.validateExpression(exp = (V5SimpleNode)current, params)) == ErrorCode.OK) continue;
            return errCode;
        }
        return node.validateExpression(params);
    }

    public static enum ErrorCode {
        OK,
        InvalidCoercion,
        InvalidFunctionParameter;

    }
}

