/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5InExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import java.util.Map;
import java.util.Set;

public final class AddTopNSimpleListLargeLevel
extends Transformation {
    private static final String PROVIDER_KEY = "DMR";

    public AddTopNSimpleListLargeLevel() {
        this.mName = "Add TopN to DMR simple List.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        mdxQuery.setDMRCubeReuseEnabled(false);
        CubeWrapper cubeWrapper = (CubeWrapper)mdxQuery.getMDXFrom().getCube();
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(PROVIDER_KEY);
        int cwaTopN = providerCapabilities.getIntegerValue("CWADialogBoxTopN", 0);
        cubeWrapper.setTopN(Integer.toString(cwaTopN));
        IXQEQueryNode[] vs = mdxQuery.getDescendantsOfType(101057, false);
        V5ValueSet v5VS = (V5ValueSet)vs[0];
        IXQEQueryNode[] groupBody = v5VS.getChildrenOfType(101051);
        IXQEQueryNode[] diRef = groupBody[0].getChildrenOfType(101015);
        boolean[] bIsSimpleExpression = new boolean[]{true};
        ILevel level = this.getLevelFromRxpression(diRef[0], bIsSimpleExpression);
        IXQEQueryNode[] filter = mdxQuery.getChildrenOfType(1010);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (bIsSimpleExpression[0]) {
            IXQEQueryNode expr = this.skipSetFunction(this.skipDataItem(diRef[0].getChild(0)));
            if (expr.getType() != 201064) {
                return;
            }
            IXQEQueryNode levelExpr = this.skipSetFunction(this.skipDataItem(expr.getChild(0)));
            this.convertExceptToDetailFilter(levelExpr, level, mdxQuery, nodeFactory, filter, expr);
        } else {
            IXQEQueryNode[] levels = diRef[0].getDescendantsOfType(201116, false);
            this.cleanDetailFilter(levels[0], filter, nodeFactory);
        }
    }

    private void convertExceptToDetailFilter(IXQEQueryNode levelExpr, ILevel level, MDXQuery mdxQuery, IXQENodeFactory nodeFactory, IXQEQueryNode[] filter, IXQEQueryNode expr) {
        IXQEQueryNode setExpr = expr.getChild(1);
        setExpr.detach();
        expr.extract();
        for (IXQEQueryNode c : setExpr.getChildren()) {
            V5BoundMemberUniqueName mun = (V5BoundMemberUniqueName)this.skipDataItem(c);
            if (level.equals(mun.getLevel())) continue;
            setExpr.detachChild(c);
        }
        if (setExpr.getChildren().length > 0) {
            V5LogicalExpression notExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
            notExpr.setSubType(2);
            V5InExpression inExpr = (V5InExpression)nodeFactory.createNode(201011);
            notExpr.addChild(inExpr);
            inExpr.addChild(nodeFactory.deepCopyNode(levelExpr));
            for (IXQEQueryNode m : setExpr.getChildren()) {
                inExpr.addChild(m.detach());
            }
            CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)nodeFactory.createNode(1010);
            detailFilter.setPostAutoAggregation(false);
            detailFilter.addChild(notExpr);
            detailFilter.setSupportedBy(CogMDXDetailFilter.TypeOfQuery.RELATIONALQUERY);
            Set<IHierarchy> hierarchies = detailFilter.getReferencedDMRHierarchies();
            hierarchies.add(level.getHierarchy());
            detailFilter.setReferencedDMRHierarchies(hierarchies);
            mdxQuery.addChild(detailFilter);
        }
        this.cleanDetailFilter(levelExpr, filter, nodeFactory);
    }

    private void cleanDetailFilter(IXQEQueryNode levelExpr, IXQEQueryNode[] filter, IXQENodeFactory nodeFactory) {
        if (filter.length != 1) {
            return;
        }
        IXQEQueryNode diNode = filter[0].getFirstDescendantOfTypeOrdered(101003, false);
        if (diNode != null) {
            IXQEQueryNode except = diNode.getChild(0);
            IXQEQueryNode newNode = nodeFactory.deepCopyNode(levelExpr);
            diNode.exchangeChildNode(except, newNode);
        }
        CogMDXDetailFilter cogFilter = (CogMDXDetailFilter)filter[0];
        cogFilter.setSupportedBy(CogMDXDetailFilter.TypeOfQuery.RELATIONALQUERY);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5SortItem sortItem;
        String sortRefDI;
        MDXQuery mdxQuery = (MDXQuery)node;
        if (!mdxQuery.isDMR()) {
            return false;
        }
        if (!mdxQuery.isListReport()) {
            return false;
        }
        CubeWrapper cubeWrapper = (CubeWrapper)mdxQuery.getMDXFrom().getCube();
        String topN = cubeWrapper.getTopN();
        if (topN != null) {
            return false;
        }
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(PROVIDER_KEY);
        int cwaTopN = providerCapabilities.getIntegerValue("CWADialogBoxTopN", 0);
        if (cwaTopN <= 0) {
            return false;
        }
        double oomLimit = providerCapabilities.getDoubleValue("ThrowNoFactDrivenLoadingForLevelOOMLargerThan", 0.0);
        if (oomLimit <= 0.0) {
            return false;
        }
        IXQEQueryNode[] vs = mdxQuery.getDescendantsOfType(101057, false);
        if (vs.length != 1) {
            return false;
        }
        V5ValueSet v5VS = (V5ValueSet)vs[0];
        String refDI = v5VS.getRefDataItemProperty();
        if (refDI != null) {
            return false;
        }
        IXQEQueryNode[] groupBody = v5VS.getChildrenOfType(101051);
        if (groupBody.length != 1) {
            return false;
        }
        IXQEQueryNode[] diRef = groupBody[0].getChildrenOfType(101015);
        if (diRef.length != 1) {
            return false;
        }
        refDI = ((V5DataItemRef)diRef[0]).getDataItemRefProperty();
        IXQEQueryNode[] sort = v5VS.getChildrenOfType(101056);
        if (sort.length > 1) {
            return false;
        }
        if (sort.length == 1 && !refDI.equals(sortRefDI = (sortItem = (V5SortItem)sort[0]).getRefDataItem())) {
            return false;
        }
        IXQEQueryNode[] filter = mdxQuery.getChildrenOfType(1010);
        if (filter.length > 1) {
            return false;
        }
        if (filter.length == 1 && !this.checkFilter(filter[0], ((V5DataItemRef)diRef[0]).getDataItemRefProperty())) {
            return false;
        }
        boolean[] bIsSimpleExpression = new boolean[]{true};
        ILevel level = this.getLevelFromRxpression(diRef[0], bIsSimpleExpression);
        if (level == null) {
            return false;
        }
        return level.getOrderOfMagnitude() >= oomLimit;
    }

    private ILevel getLevelFromRxpression(IXQEQueryNode diRef, boolean[] bIsSimpleExpression) {
        IXQEQueryNode theDI = diRef.getChild(0);
        if (theDI.getType() != 101003) {
            return null;
        }
        Map mp = (Map)theDI.getPropertyValue("xmlAttributes");
        if (mp == null) {
            return null;
        }
        String v = (String)mp.get("RS_selectValuesDataItem");
        if (v == null || !v.equalsIgnoreCase("true")) {
            return null;
        }
        IXQEQueryNode node = this.skipSetFunction(this.skipDataItem(theDI));
        if (node == null) {
            return null;
        }
        ILevel level = this.getLevel(node);
        if (level != null) {
            return level;
        }
        if (node.getType() == 201064) {
            level = this.getLevel(this.skipSetFunction(this.skipDataItem(node.getChild(0))));
            if (level != null) {
                IXQEQueryNode setNode = this.skipDataItem(node.getChild(1));
                if (setNode.getType() != 201101) {
                    level = null;
                }
                if (level != null) {
                    for (IXQEQueryNode c : setNode.getChildren()) {
                        IXQEQueryNode n = this.skipDataItem(c);
                        if (n.getType() == 201117) continue;
                        level = null;
                        break;
                    }
                }
            }
            if (level != null) {
                return level;
            }
        }
        bIsSimpleExpression[0] = false;
        IXQEQueryNode[] levels = diRef.getDescendantsOfType(201116, false);
        if (levels.length != 1) {
            return null;
        }
        return this.getLevel(levels[0]);
    }

    private IXQEQueryNode skipDataItem(IXQEQueryNode node) {
        IXQEQueryNode n;
        for (n = node; n != null && n.getType() == 101003; n = n.getChild(0)) {
        }
        return n;
    }

    private IXQEQueryNode skipSetFunction(IXQEQueryNode node) {
        IXQEQueryNode n;
        for (n = node; n != null && (n.getType() == 201091 || n.getType() == 201086); n = n.getChild(0)) {
        }
        return n;
    }

    private ILevel getLevel(IXQEQueryNode node) {
        IMetadata metadataObj;
        if (node.getType() == 201116 && (metadataObj = ((V5BoundModelIdentifier)node).getMetadata()) != null && metadataObj.getObjectType() == MetadataType.LEVEL) {
            return (ILevel)metadataObj;
        }
        return null;
    }

    private boolean checkFilter(IXQEQueryNode filter, String dataItem) {
        V5RoleValueFunction cap;
        CogMDXDetailFilter cogFilter = (CogMDXDetailFilter)filter;
        if (cogFilter.getPostAutoAggregation()) {
            return false;
        }
        IXQEQueryNode expr = filter.getChild(0);
        if (!expr.isOfCategory(201126)) {
            return false;
        }
        IXQEQueryNode first = expr.getChild(0);
        if (first.getType() == 101003) {
            return dataItem.equals(((V5DataItem)first).getNameProperty());
        }
        String diName = null;
        if (first.getType() == 201050) {
            first = first.getChild(0);
        } else if (first.getType() == 201098 && (cap = (V5RoleValueFunction)first).getRoleType() == RoleTypeEnum.MEMBER_CAPTION) {
            first = cap.getChild(1);
        }
        if (first.getType() == 101003) {
            diName = ((V5DataItem)first).getNameProperty();
        }
        return dataItem.equals(diName);
    }
}

