/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.types.NumericType;
import com.cognos.xqe.data.types.SmallintType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimeWithTZType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.types.TimestampWithTZType;
import com.cognos.xqe.data.types.TinyintType;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.shell.ShellHierarchy;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;

public class ReplaceDMRBoundIdentifierWithExpression
extends Transformation {
    private static final String STRING_EXPRESSION = "expression";

    public ReplaceDMRBoundIdentifierWithExpression() {
        this.mName = "Replaces a DMR level within an expression with a query item";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5BoundToMetadata v5BoundId = (V5BoundToMetadata)node;
        String roleType = ReplaceDMRBoundIdentifierWithExpression.resolveRoleType(v5BoundId);
        String expr = ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpression(environment, v5BoundId, roleType);
        if (expr != null) {
            IXQEQueryNode tree = RQPUtilities.createV5ValueExpressionMetadata(expr, environment, null, DMRUtilities.getWrapped(v5BoundId.getMetadata()));
            MetadataContext.flagMetadataObjectIfRequired(v5BoundId.getMetadata(), tree);
            node.exchange(tree);
        } else {
            DMRUtilities.convertAllLevelToRootCaptionOrRootMUNKey(v5BoundId, environment, roleType);
        }
    }

    public static String resolveRoleType(V5BoundToMetadata v5BoundId) {
        String roleType = ReplaceDMRBoundIdentifierWithExpression.getRoleTypeFromContextAndExtractParents(v5BoundId);
        if (roleType == null) {
            roleType = v5BoundId.getAncestorOfType(101008) != null ? RoleTypeEnum.BUSINESS_KEY.toV5Keyword() : RoleTypeEnum.MEMBER_CAPTION.toV5Keyword();
        }
        return roleType;
    }

    public static String getModelIdentifierExpression(PlanningEnvironment environment, V5BoundToMetadata v5BoundId, String roleType) {
        return ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpression(environment, v5BoundId, roleType, false);
    }

    public static String getModelIdentifierExpression(PlanningEnvironment environment, V5BoundToMetadata v5BoundId, String roleType, boolean bDataTypeMatch) {
        IMetadata metadata = v5BoundId.getMetadata();
        return ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpressionFromMetadata(environment, metadata, roleType, bDataTypeMatch);
    }

    public static String getModelIdentifierExpressionFromMetadata(PlanningEnvironment environment, IMetadata metadata, String roleType) {
        return ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpressionFromMetadata(environment, metadata, roleType, false);
    }

    public static String getModelIdentifierExpressionFromMetadata(PlanningEnvironment environment, IMetadata metadata, String roleType, boolean bDataTypeMatch) {
        IQueryItem queryItem = null;
        String expr = null;
        if (metadata instanceof IQueryItem) {
            expr = ((IQueryItem)metadata).getExpressionOrExternalName();
        } else if (metadata instanceof IMeasure || metadata instanceof IProperty) {
            expr = (String)metadata.getProperty(STRING_EXPRESSION);
            if (expr == null && metadata instanceof MeasureWrapper) {
                expr = ((MeasureWrapper)metadata).getUniqueID();
            }
        } else {
            queryItem = DMRLevel.getQueryItemWithRole(metadata, roleType, true);
            if (queryItem != null) {
                IDataType dt;
                expr = queryItem.getExpressionOrExternalName();
                if (bDataTypeMatch && RoleTypeEnum.MEMBER_CAPTION.toV5Keyword().equalsIgnoreCase(roleType) && (dt = queryItem.getDataType()) != null && !dt.isTextType()) {
                    expr = "cast(" + expr + " as varchar(" + ReplaceDMRBoundIdentifierWithExpression.getTextSize(dt) + "))";
                }
            }
        }
        if (expr != null) {
            expr = MetadataUtil.extractExpressionFromModelString(expr, environment);
        }
        return expr;
    }

    public static String getTextSize(IDataType dt) {
        int maxPrecision = -1;
        if (dt instanceof IntegerType) {
            maxPrecision = 13;
        } else if (dt instanceof LongType) {
            maxPrecision = 22;
        } else if (dt instanceof SmallintType) {
            maxPrecision = 8;
        } else if (dt instanceof TinyintType) {
            maxPrecision = 6;
        } else if (dt instanceof BooleanType) {
            maxPrecision = 6;
        } else if (dt instanceof DateType) {
            maxPrecision = 12;
        } else if (dt instanceof TimeType) {
            maxPrecision = 21;
        } else if (dt instanceof TimeWithTZType) {
            maxPrecision = 27;
        } else if (dt instanceof TimestampType) {
            maxPrecision = 32;
        } else if (dt instanceof TimestampWithTZType) {
            maxPrecision = 38;
        } else if (dt instanceof IntervalDayTimeType) {
            maxPrecision = 31;
        } else if (dt instanceof IntervalYearMonthType) {
            maxPrecision = 15;
        } else if (dt instanceof DecimalType) {
            DecimalType decimalTp = (DecimalType)dt;
            maxPrecision = decimalTp.getPrecision() + 4;
        } else if (dt instanceof DoubleType || dt instanceof NumericType) {
            maxPrecision = 18;
        } else if (dt instanceof FloatType) {
            maxPrecision = 10;
        }
        return String.valueOf(maxPrecision);
    }

    public static String getRoleTypeFromContextAndExtractParents(V5BoundToMetadata v5BoundId) {
        String roleType = null;
        IXQEQueryNode parentNode = v5BoundId.getParent();
        if (parentNode.getType() == 101003) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201086) {
            parentNode.extract();
        }
        if ((parentNode = v5BoundId.getParent()).getType() == 101003) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201050) {
            roleType = RoleTypeEnum.MEMBER_CAPTION.toV5Keyword();
            parentNode.extract();
        }
        if (parentNode.getType() == 201098) {
            V5LiteralValue literalString = (V5LiteralValue)parentNode.getChild(0);
            roleType = literalString.getValue().getString();
            parentNode.getChild(0).extract();
            parentNode.extract();
        }
        return roleType;
    }

    public static boolean isConvertibleToRelational(IMetadata metadata) {
        if (metadata instanceof IMeasure || metadata instanceof IProperty) {
            return true;
        }
        if (metadata instanceof ShellHierarchy) {
            return false;
        }
        IQueryItem queryItem = DMRLevel.getQueryItemWithRole(metadata, RoleTypeEnum.MEMBER_CAPTION.toV5Keyword(), true);
        if (queryItem != null) {
            return queryItem.getExpressionOrExternalName() != null;
        }
        return DMRUtilities.isAllLevel(metadata);
    }

    public static boolean isConvertibleToRelational(PlanningEnvironment environment, IMetadata metadata, String roleType) {
        if (ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpressionFromMetadata(environment, metadata, roleType) != null) {
            return true;
        }
        return DMRUtilities.isAllLevel(metadata);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode v5node = node.getAncestorOfTypes(new int[]{101004, 101008});
        if (v5node == null) {
            return false;
        }
        V5Query query = (V5Query)v5node.getAncestorOfType(101006);
        if (!query.isDMRtoRQP()) {
            this.traceNodeCondition(false, "Expression belongs to a  DMR query not manageable by RQP.", trace);
            return false;
        }
        IMetadata metadata = ((V5BoundToMetadata)node).getMetadata();
        if (metadata == null || !metadata.isDMR() || !query.isDMRInQueryContext(metadata)) {
            this.traceNodeCondition(false, "Identifier is not a DMR expression.", trace);
            return false;
        }
        if (!ReplaceDMRBoundIdentifierWithExpression.isConvertibleToRelational(environment, metadata, RoleTypeEnum.MEMBER_CAPTION.toV5Keyword())) {
            this.traceNodeCondition(false, "Could not determine query item or query item expression for the node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Level will be replaced with a query item.", trace);
        return true;
    }
}

