/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5InExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.dmr.ReplaceDMRBoundIdentifierWithExpression;
import com.cognos.xqe.transformation.dmr.ReplaceDMRMemberWithRelationalLiteral;
import com.cognos.xqe.util.Pair;

public class RewriteCaptionFunctionInFilterExpression
extends Transformation {
    public RewriteCaptionFunctionInFilterExpression() {
        this.mName = "Rewrite caption function in filter expression";
        this.mPassNumbers = new int[1];
        this.mPassNumbers[0] = 6;
        this.mTypes = new int[]{201013, 201011};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RewriteCaptionFunctionInFilterExpression.rewriteCaptionComparisonExpr(node, environment);
    }

    public static void rewriteCaptionComparisonExpr(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean captionAndKeyAreTheSameQI;
        IXQEQueryNode roleValueArg;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundMemberUniqueName rhsMember = null;
        IXQEQueryNode rhsNode = node.getChild(1);
        rhsMember = rhsNode.getType() == 201050 ? (V5BoundMemberUniqueName)rhsNode.getChild(0) : ((roleValueArg = rhsNode.getChild(1)).getType() == 101003 ? (V5BoundMemberUniqueName)roleValueArg.getChild(0) : (V5BoundMemberUniqueName)roleValueArg);
        ILevel rhsLevel = rhsMember.getLevel();
        IQueryItem rhsLevelKey = DMRLevel.getQueryItemWithRole(rhsLevel, RoleTypeEnum.BUSINESS_KEY.toV5Keyword(), true);
        IQueryItem rhsLevelCaption = DMRLevel.getQueryItemWithRole(rhsLevel, RoleTypeEnum.MEMBER_CAPTION.toV5Keyword(), true);
        boolean bl = captionAndKeyAreTheSameQI = rhsLevelKey == rhsLevelCaption;
        if (captionAndKeyAreTheSameQI) {
            IXQEQueryNode function = node.getChild(0);
            if (function.getType() == 201050) {
                function.extract();
            } else {
                function.detachChild(0);
                function.extract();
            }
            function = node.getChild(1);
            if (function.getType() == 201050) {
                function.extract();
            } else {
                function.detachChild(0);
                function.extract();
            }
        } else {
            V5InExpression inOperator = null;
            if (node.getType() == 201013) {
                inOperator = (V5InExpression)nodeFactory.createNode(201011);
                node.exchange(inOperator, true);
            } else {
                inOperator = (V5InExpression)node;
            }
            V5BoundModelIdentifier rhsLevelBoundId = RewriteCaptionFunctionInFilterExpression.getLevelFromMember(nodeFactory, rhsMember);
            V5LiteralValue businessKeyValue = ReplaceDMRMemberWithRelationalLiteral.getBusinessKeyValueOfMember(rhsMember, environment);
            rhsMember.exchange(rhsLevelBoundId, false);
            String businessKeyQIExpr = ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpression(environment, rhsLevelBoundId, RoleTypeEnum.BUSINESS_KEY.toV5Keyword());
            StringBuilder sb = new StringBuilder(businessKeyQIExpr);
            if (businessKeyValue.getValue().isNull()) {
                sb.append(" is null ");
            } else {
                sb.append(" = ");
                sb.append(businessKeyValue.getNativeName());
            }
            inOperator.setPropertyValue("memberFilter", new Pair(sb.toString(), DMRUtilities.getWrapped(rhsLevelBoundId.getMetadata())));
        }
    }

    public static V5BoundModelIdentifier getLevelFromMember(IXQENodeFactory nodeFactory, V5BoundMemberUniqueName member) {
        ILevel levelOfMember = member.getLevel();
        V5BoundModelIdentifier levelBoundId = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        levelBoundId.setMetadata(levelOfMember);
        levelBoundId.setIdentifier(levelOfMember.getV5UniqueName());
        levelBoundId.setPropertyValue("isMetadataWrapped", true);
        return levelBoundId;
    }

    public static boolean isCaptionOfLevel(IXQEQueryNode node) {
        if (node.getType() == 101003) {
            node = node.getChild(0);
        }
        if (node.getType() == 201050) {
            IXQEQueryNode child = node.getChild(0);
            return RewriteCaptionFunctionInFilterExpression.isALevel(child);
        }
        if (node.getType() == 201098) {
            V5LiteralValue role = (V5LiteralValue)node.getChild(0);
            String roleName = role.getValue().getString();
            if (!roleName.equals(RoleTypeEnum.MEMBER_CAPTION.toV5Keyword())) {
                return false;
            }
            IXQEQueryNode secondArgOfRoleValue = node.getChild(1);
            if (secondArgOfRoleValue.getType() == 101003) {
                secondArgOfRoleValue = secondArgOfRoleValue.getChild(0);
            }
            if (secondArgOfRoleValue.getType() != 201086) {
                return false;
            }
            IXQEQueryNode argOfMembers = secondArgOfRoleValue.getChild(0);
            return RewriteCaptionFunctionInFilterExpression.isALevel(argOfMembers);
        }
        return false;
    }

    public static boolean isALevel(IXQEQueryNode node) {
        if (node == null) {
            return false;
        }
        if (node.getType() != 201116) {
            return false;
        }
        return ((V5BoundModelIdentifier)node).getMetadata().getObjectType() == MetadataType.LEVEL;
    }

    public static boolean isCaptionOfMember(IXQEQueryNode node) {
        if (node.getType() == 101003) {
            node = node.getChild(0);
        }
        if (node.getType() == 201050) {
            IXQEQueryNode child = node.getChild(0);
            return child != null && child.getType() == 201117;
        }
        if (node.getType() == 201098) {
            V5LiteralValue role = (V5LiteralValue)node.getChild(0);
            String roleName = role.getValue().getString();
            if (!roleName.equals(RoleTypeEnum.MEMBER_CAPTION.toV5Keyword())) {
                return false;
            }
            IXQEQueryNode secondArgOfRoleValue = node.getChild(1);
            if (secondArgOfRoleValue.getType() == 101003) {
                secondArgOfRoleValue = secondArgOfRoleValue.getChild(0);
            }
            if (secondArgOfRoleValue.getType() == 201117) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query v5query = (V5Query)node.getAncestorOfType(101006);
        if (v5query == null || !v5query.isDMRtoRQP()) {
            this.traceNodeCondition(false, "The query can not be pushed completely to relational", trace);
            return false;
        }
        return RewriteCaptionFunctionInFilterExpression.isCaptionOfLevelEqualOrInCaptionOfMember(node);
    }

    public static boolean isCaptionOfLevelEqualOrInCaptionOfMember(IXQEQueryNode node) {
        int subtype;
        if (node.getType() == 201013 && (subtype = ((V5ComparisonExpression)node).getSubType()) != 2) {
            return false;
        }
        IXQEQueryNode lhsNode = node.getChild(0);
        IXQEQueryNode rhsNode = node.getChild(1);
        return RewriteCaptionFunctionInFilterExpression.isCaptionOfLevel(lhsNode) && RewriteCaptionFunctionInFilterExpression.isCaptionOfMember(rhsNode);
    }
}

