/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import java.util.List;

public class SubstituteCountWithForClauseWithMeasureWrapper
extends Transformation {
    public SubstituteCountWithForClauseWithMeasureWrapper() {
        this.mName = "Substitute Count With For Clause with Measure Wrapper.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{201031};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode expression = node.getChild(0);
        V5BoundModelIdentifier measure = (V5BoundModelIdentifier)this.getFirstMeasure(expression);
        MeasureWrapper refMeasure = (MeasureWrapper)measure.getMetadata();
        refMeasure.setV5AggregateAttribute("total");
        IXQEQueryNode parent = node.getParent();
        node.detach();
        parent.addChild(measure);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query v5QueryNode = DMRUtilities.findQuery(node);
        if (!v5QueryNode.isDMR()) {
            this.traceNodeCondition(false, "Query is not DMR.", trace);
            return false;
        }
        if (node.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "The target V5ValueSummaryFunction node does not have two child nodes.", trace);
            return false;
        }
        if (node.getChild(1).getType() != 201037) {
            this.traceNodeCondition(false, "The second child of the target V5ValueSummaryFunction node is not a FOR-clause node.", trace);
            return false;
        }
        if (((V5ValueSummaryFunction)node).getSubType() != 2) {
            this.traceNodeCondition(false, "The type of the V5ValueSummaryFunction is not COUNT.", trace);
            return false;
        }
        IXQEQueryNode expression = node.getChild(0);
        V5BoundModelIdentifier measure = (V5BoundModelIdentifier)this.getFirstMeasure(expression);
        if (measure == null) {
            this.traceNodeCondition(false, "The first parametr of COUNT needs to contain a measure.", trace);
            return false;
        }
        IXQEQueryNode filter = node.getAncestorOfType(101008);
        if (filter != null && ((V5DetailFilter)filter).getPostAutoAggregation()) {
            this.traceNodeCondition(false, "The expression should not be pushed in PAA filter.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The count with FOR can be replaced with its wrapped measure.", trace);
        return true;
    }

    private IXQEQueryNode getFirstMeasure(IXQEQueryNode expression) {
        List<IXQEQueryNode> modelIds = expression.getDescendantsOfTypeOrdered(201116, true);
        for (IXQEQueryNode modelId : modelIds) {
            V5BoundModelIdentifier id = (V5BoundModelIdentifier)modelId;
            if (!id.isMeasure()) continue;
            return id;
        }
        return null;
    }
}

