/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;

public class SuppressNullsWithPreAutoAggregationMeasureDetailFilter
extends Transformation {
    private static final String TRANSFORMATION_APPLIED = "SuppressNullsWithPreAutoAggregationMeasureDetailFilterApplied";

    public SuppressNullsWithPreAutoAggregationMeasureDetailFilter() {
        this.mName = "Convert Analysis Studio Suppress Nulls to pre aggregate measure detail filter.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node;
        ArrayList<BaseMember> measures = new ArrayList<BaseMember>();
        List<BaseMember> members = mdxQuery.collectBaseMeasures();
        for (BaseMember baseMember : members) {
            boolean bl = false;
            for (IXQEQueryNode iXQEQueryNode : measures) {
                if (!baseMember.isSameExpression(iXQEQueryNode, false)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            measures.add(baseMember);
        }
        V5LogicalExpression filterExpr = null;
        for (BaseMember baseMember : measures) {
            String expr = (String)baseMember.getMember().getProperty("expression");
            if (expr == null) {
                expr = baseMember.getMember().getUniqueID();
            }
            expr = MetadataUtil.extractExpressionFromModelString(expr, environment);
            V5MultiPartIdentifier v5MultiPartIdentifier = (V5MultiPartIdentifier)nodeFactory.createNode(201030);
            v5MultiPartIdentifier.setIdentifier(expr);
            V5LogicalExpression notExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
            notExpr.setSubType(2);
            IXQEQueryNode isNull = nodeFactory.createNode(201010);
            isNull.addChild(v5MultiPartIdentifier);
            notExpr.addChild(isNull);
            if (filterExpr == null) {
                filterExpr = notExpr;
                continue;
            }
            V5LogicalExpression or = (V5LogicalExpression)nodeFactory.createNode(201003);
            or.setSubType(1);
            or.addChild(filterExpr);
            or.addChild(notExpr);
            filterExpr = or;
        }
        if (filterExpr != null) {
            CogMDXDetailFilter cogMDXDetailFilter = (CogMDXDetailFilter)nodeFactory.createNode(1010);
            cogMDXDetailFilter.setPostAutoAggregation(false);
            cogMDXDetailFilter.addChild(filterExpr);
            CubeWrapper cubeWrapper = (CubeWrapper)mdxQuery.getMDXFrom().getCube();
            cubeWrapper.addDetailFilter(cogMDXDetailFilter);
        }
        mdxQuery.setPropertyValue(TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.getPropertyValue(TRANSFORMATION_APPLIED) != null) {
            this.traceQueryCondition(false, "Suppress nulls with Pre Auto Aggregation measure detail filter has been applied to the query.", trace);
            return false;
        }
        if (mdxQuery.isSuppressNullsWithPreAutoAggregationMeasureDetailFiler()) {
            this.traceQueryCondition(true, "The query requires null suppression with automatically generated pre auto aggregation measure detail filter.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The query does not require pre auto aggregation measure detail filter for null suppression.", trace);
        return false;
    }
}

