/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;

public class WrapCube
extends Transformation {
    private static final String DMR_QUERY_WRAPPED = "dmrQueryWrapped";

    public WrapCube() {
        this.mName = "Wrap the MFWCube object of the MDXFromCube";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1007};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ICube cube = ((MDXFromCube)node).getCube();
        if (cube == null || !(cube instanceof CubeWrapper)) {
            cube = DMRUtilities.findCubeWrapper(node, environment, true);
            ((MDXFromCube)node).setPropertyValue("referencedCube", cube);
        }
        node.setPropertyValue(DMR_QUERY_WRAPPED, "true");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = DMRUtilities.findQuery((MDXFromCube)node);
        if (query == null) {
            this.traceNodeCondition(false, "No query.", trace);
            return false;
        }
        if (!query.isDMR()) {
            this.traceNodeCondition(false, "Query is not DMR.", trace);
            return false;
        }
        if (node.getPropertyValue(DMR_QUERY_WRAPPED) != null) {
            this.traceNodeCondition(false, "Metadata object has already been wrapped.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Metadata object has not been wrapped.", trace);
        return true;
    }
}

