/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemOfLevelWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemOfQuerySubjectToMeasureWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;

public class WrapMetadataObject
extends Transformation {
    public WrapMetadataObject() {
        this.mName = "Replaces a metadata object in a V5Parameter, V5BoundMemberUniqueName or V5BoundMultipartIdentifier with a wrapped metadata object.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{201024, 201127, 201117, 201116};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        String[] reason = new String[]{""};
        boolean b = WrapMetadataObject.checkNodeCondition(node, reason);
        this.traceNodeCondition(b, reason[0], trace);
        return b;
    }

    public static boolean checkNodeCondition(IXQEQueryNode node, String[] reason) {
        V5Query v5QueryNode = DMRUtilities.findQuery(node);
        if (v5QueryNode == null || !v5QueryNode.isDMR() && !v5QueryNode.isDMRtoRQP()) {
            reason[0] = "Query is not DMR.";
            return false;
        }
        V5BoundToMetadata v5Bound = (V5BoundToMetadata)node;
        IMetadata metadata = v5Bound.getMetadata();
        if (metadata == null) {
            reason[0] = "No metadata object set on the node.";
            return false;
        }
        Boolean isMetadataWrapped = (Boolean)v5Bound.getPropertyValue("isMetadataWrapped");
        if (isMetadataWrapped != null && isMetadataWrapped.booleanValue()) {
            reason[0] = "Metadata object has already been wrapped.";
            return false;
        }
        if (v5QueryNode.isDMRtoRQP()) {
            reason[0] = "Not DMR metadata object in a not DMR query";
            return false;
        }
        if (metadata instanceof LevelWrapper || metadata instanceof AbstractDimensionWrapper || metadata instanceof HierarchyWrapper || metadata instanceof MeasureWrapper || metadata instanceof QueryItemOfLevelWrapper || metadata instanceof QueryItemOfQuerySubjectToMeasureWrapper || metadata instanceof V5DataItemToMeasureWrapper || metadata instanceof V5DataItemToLevelWrapper || metadata instanceof V5DataItemToLevelAttributeWrapper) {
            reason[0] = "Metadata object has already been wrapped in some way...";
            return false;
        }
        if (metadata.getObjectType() == MetadataType.QUERY_ITEM && ((IQueryItem)metadata).getLevel() == null) {
            reason[0] = "Metadata is a queryItem of a level.";
            return false;
        }
        if (metadata.getObjectType() == MetadataType.HIERARCHY && ((IHierarchy)metadata).getDimension().isMeasuresDimension()) {
            reason[0] = "Metadata object is the measures dimension.";
            return false;
        }
        reason[0] = "Metadata object has not been wrapped.";
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        WrapMetadataObject.wrapMetadataObject(node, environment);
    }

    public static void wrapMetadataObject(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode v5qset;
        AggregateTypeEnum aggr;
        IMetadata meta;
        CubeWrapper cube = DMRUtilities.findCubeWrapper(node, environment, true);
        V5BoundToMetadata boundToMetadata = (V5BoundToMetadata)node;
        WrapMetadataObject.wrapDMRObject(environment, cube, boundToMetadata);
        Object reqEnv = environment.getRequestEnvironment();
        if (reqEnv.isValidateRequest()) {
            meta = boundToMetadata.getMetadata();
            if (meta instanceof MeasureWrapper) {
                WrapMetadataObject.refineMeasure(environment, (MeasureWrapper)meta);
            }
        } else if (!reqEnv.isGetParametersRequest() && (meta = boundToMetadata.getMetadata()) instanceof MeasureWrapper && ((aggr = ((MeasureWrapper)meta).getRegularAggregate()) == null || aggr == AggregateTypeEnum.UNSUPPORTED || aggr == AggregateTypeEnum.UNKNOWN)) {
            WrapMetadataObject.refineMeasure(environment, (MeasureWrapper)meta);
        }
        meta = boundToMetadata.getMetadata();
        if (MetadataContext.isMetadataContextWrapper(meta) && (v5qset = node.getAncestorOfType(101002)) != null) {
            ((V5QuerySet)v5qset).setNonReusable(true);
        }
    }

    public static void wrapDMRObject(PlanningEnvironment environment, CubeWrapper cube, V5BoundToMetadata boundToMetadata) {
        IMetadata metadata = boundToMetadata.getMetadata();
        IMetadata metadataWrapper = null;
        metadataWrapper = cube.getWrapped(metadata) != null ? metadata : cube.getWrapper(metadata);
        if (metadataWrapper == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Failed to create metadata wrapper.");
        }
        if (boundToMetadata.getType() == 201117) {
            boundToMetadata.removeProperty("level");
        }
        boundToMetadata.setMetadata(metadataWrapper);
        if (boundToMetadata.getType() == 201127) {
            V5BoundParameter boundParameter = (V5BoundParameter)boundToMetadata;
            Parameters parameters = ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters();
            Parameter parameter = parameters.getParameter(boundParameter.getParameterName());
            ArrayList<ILevel> newLevels = new ArrayList<ILevel>();
            for (ILevel level : parameter.getLevels()) {
                ILevel newLevel = null;
                newLevel = cube.getWrapped(level) != null ? level : (ILevel)cube.getWrapper(level);
                newLevels.add(newLevel);
            }
            parameter.setLevels(newLevels);
        }
        if (boundToMetadata.getType() == 201117) {
            String dimUN = ((ILevel)metadataWrapper).getDimension().getName();
            String hierarchyUN = ((ILevel)metadataWrapper).getHierarchy().getName();
            String levelName = ((V5BoundMemberUniqueName)boundToMetadata).getExternalMemberUniqueName();
            String dimHierUN = UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(dimUN), UniqueNameGenerator.createUniqueName(hierarchyUN));
            boundToMetadata.setPropertyValue("externalMun", UniqueNameGenerator.join(dimHierUN, levelName));
        }
        boundToMetadata.setPropertyValue("isMetadataWrapped", true);
    }

    protected static void refineMeasure(PlanningEnvironment environment, MeasureWrapper measure) {
        if (measure.getRefined()) {
            return;
        }
        measure.setRefined();
        AggregateTypeEnum aggr = measure.getRegularAggregate();
        if (aggr == null) {
            aggr = AggregateTypeEnum.UNSUPPORTED;
        }
        if (aggr == AggregateTypeEnum.COUNT || aggr == AggregateTypeEnum.COUNT_DISTINCT || aggr == AggregateTypeEnum.COUNT_NON_ZERO) {
            measure.setDataType(LongType.LONGTYPE);
            return;
        }
        IXQEQueryNode tree = RQPUtilities.getV5ValueExpression(measure.getWrapped(), environment);
        if (tree == null) {
            return;
        }
        tree = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, tree);
        IXQEQueryNode[] objects = tree.getDescendantsOfType(201116, true);
        boolean bChanged = true;
        while (bChanged) {
            bChanged = false;
            for (IXQEQueryNode obj : objects) {
                IXQEQueryNode exp = RQPUtilities.getV5ValueExpression(((V5BoundModelIdentifier)obj).getMetadata(), environment);
                if (exp == null) continue;
                bChanged = true;
                exp = RefineAutomaticXtab.bindV5MultiPartIdentifierToModel(environment, exp);
                if (obj == tree) {
                    tree = exp;
                    continue;
                }
                obj.exchange(exp);
            }
            if (!bChanged) continue;
            objects = tree.getDescendantsOfType(201116, true);
        }
        IDataType dt = ((V5SimpleNode)tree).getDataType();
        if (dt == null) {
            return;
        }
        if (aggr == AggregateTypeEnum.UNSUPPORTED || aggr == AggregateTypeEnum.UNKNOWN) {
            AggregateTypeEnum origAggr = aggr;
            aggr = dt.isNumeric() || dt.isInterval() ? AggregateTypeEnum.SUM : (dt.isDate() || dt.isTime() || dt.isTimestamp() ? AggregateTypeEnum.MAX : AggregateTypeEnum.COUNT);
            measure.setResolvedRegularAggregate(aggr);
            measure.setRegularAggregate(aggr);
            ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_OverrideUnsupportedAggregateForMeasure, measure.getV5UniqueName(), origAggr.name(), aggr.name());
            environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
        }
        if (aggr == AggregateTypeEnum.COUNT) {
            measure.setDataType(LongType.LONGTYPE);
            return;
        }
        dt = aggr.getPostAggregationDataType(dt);
        measure.setDataType(dt);
    }
}

