/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemOfLevelWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemOfQuerySubjectToMeasureWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelAttributeWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;

public class WrapRoleValueProperty
extends Transformation {
    public WrapRoleValueProperty() {
        this.mName = "Replaces a property metadata object in a V5RoleValue with a wrapped metadata object.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{201098};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query v5QueryNode = DMRUtilities.findQuery(node);
        if (v5QueryNode == null || !v5QueryNode.isDMR() && !v5QueryNode.isDMRtoRQP()) {
            this.traceNodeCondition(false, "Query is not DMR.", trace);
            return false;
        }
        V5RoleValueFunction roleValue = (V5RoleValueFunction)node;
        IQueryItem metadata = roleValue.getPropertyMetadata();
        if (metadata == null) {
            this.traceNodeCondition(false, "No property metadata object set on the node.", trace);
            return false;
        }
        if (v5QueryNode.isDMRtoRQP()) {
            this.traceNodeCondition(false, "Not DMR metadata object in a not DMR query", trace);
            return false;
        }
        if (metadata instanceof LevelWrapper || metadata instanceof AbstractDimensionWrapper || metadata instanceof HierarchyWrapper || metadata instanceof MeasureWrapper || metadata instanceof QueryItemOfLevelWrapper || metadata instanceof QueryItemOfQuerySubjectToMeasureWrapper || metadata instanceof V5DataItemToMeasureWrapper || metadata instanceof V5DataItemToLevelWrapper || metadata instanceof V5DataItemToLevelAttributeWrapper) {
            this.traceNodeCondition(false, "Metadata object has already been wrapped in some way...", trace);
            return false;
        }
        if (metadata.getObjectType() == MetadataType.QUERY_ITEM && metadata.getLevel() == null) {
            this.traceNodeCondition(false, "Metadata is a queryItem of a level.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Metadata object has not been wrapped.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CubeWrapper cube = DMRUtilities.findCubeWrapper(node, environment, true);
        V5RoleValueFunction roleValue = (V5RoleValueFunction)node;
        IQueryItem propertyMetadata = roleValue.getPropertyMetadata();
        IMetadata metadataWrapper = null;
        metadataWrapper = cube.getWrapper(propertyMetadata);
        if (metadataWrapper == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Failed to create property metadata wrapper.");
        }
        roleValue.setPropertyMetadata((IQueryItem)metadataWrapper);
    }
}

