/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.ma.member.response.XMAExplicitMemberResponse;
import com.cognos.xqe.runtree.ma.member.response.XMAMemberMetadata;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;

public class AddRuntreeForMissingModelDimensionExplicitMemberQuery
extends Transformation {
    public AddRuntreeForMissingModelDimensionExplicitMemberQuery() {
        this.mName = "Add empty run tree to the executable MA metadata query node.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101015};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] generateMemberResponse = node.getDescendantsOfType(501145, false);
        if (generateMemberResponse != null && generateMemberResponse.length != 0) {
            this.traceNodeCondition(false, "XMAGenerateMemberResponse is already generated.", trace);
            return false;
        }
        MAMetadataItem metaItem = ((MAMetadataQuery)node).getReferencedMetaItem();
        if (metaItem != null && metaItem.getDatasource() == null && metaItem.getMemberUniqueName() != null) {
            this.traceNodeCondition(true, "The start_at ref could not be bound in model. The member unique name is extracted from start_at ref directly.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Skip for all the rest cases.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MetadataRestriction maRestriction = new MetadataRestriction();
        MAMetadataQuery maMetadataQuery = (MAMetadataQuery)node;
        MAMetadataItem metaItem = maMetadataQuery.getReferencedMetaItem();
        maRestriction.add(RestrictionType.MEMBER_UNIQUE_NAME, metaItem.getMemberUniqueName());
        XQENodeFactory xFactory = environment.getNodeFactory();
        XMAExplicitMemberResponse xmaExplicitMemberResponse = (XMAExplicitMemberResponse)xFactory.createNode(501145);
        xmaExplicitMemberResponse.setPropertyValue("explicitMember", Boolean.FALSE);
        XMAMemberMetadata xMemberMANode = (XMAMemberMetadata)xFactory.createXNode(501107);
        xMemberMANode.setRestrictions(maRestriction);
        xmaExplicitMemberResponse.addChild(xMemberMANode);
        MACollection memberCollection = maMetadataQuery.getMemberCollection();
        memberCollection.addChild(xmaExplicitMemberResponse);
    }
}

