/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAActionsQuery;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.ma.MAQueryNode;
import com.cognos.xqe.ast.maExp.MAConstraint;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;

public final class BindMAMetadataItem
extends Transformation {
    protected static final String DATA_SOURCE = "dataSource";
    protected static final String DATA_SOURCE_PROCESSED = "dataSourceProcessed";
    protected static final String MAMETADATAITEM = "metadataItem";

    public BindMAMetadataItem() {
        this.mName = "Bind MAQuery source to metadata connection.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{1101015, 1101019, 1101021};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        MAQueryNode maQuery = (MAQueryNode)node;
        MAMetadataQuery metadataQuery = maQuery.getMAMetadataQuery();
        MetadataConnection metadataConnection = maQuery.getMetadataConnection();
        String refItem = this.getReferencedDataItem(maQuery);
        MAMetadataItem metadataItem = new MAMetadataItem();
        try {
            if (null != metadataQuery && metadataQuery.isSAPVariableMAQuery()) {
                metadataItem.bindSAPVariableInModel(environment, refItem);
                if (metadataItem.getVariable() != null) {
                    metadataQuery.setSAPHierarchyVariableMAQuery(metadataItem.getVariable().getDataType() == DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE);
                }
            } else if (refItem.contains("]->:[") || refItem.contains("]->[")) {
                metadataItem.bindMUNInModel(environment, refItem);
            } else {
                metadataItem.bindInModel(environment, refItem);
            }
        }
        catch (MetadataBindingException ex) {
            String providerCode = null;
            ICube[] cubes = metadataConnection.getCubes();
            if (cubes.length > 0 && cubes[0] != null) {
                providerCode = cubes[0].getModelDataSource().getInterface();
            }
            if (metadataQuery.isSAPVariableMemberOperator()) {
                String varName = metadataQuery.getVariableConstraint().getOperand(MAConstraint.Operand.RIGHT_OPERAND);
                metadataItem.bindMUNWhenDimMissingInModel(environment, refItem, varName);
            }
            if (metadataQuery.isExplicitMemberQuery() && providerCode != null && DataSourceTypeEnum.isSAPBW(providerCode)) {
                metadataItem.bindMUNWhenDimMissingInModel(environment, refItem, null);
                metadataQuery.setReferencedMetaItem(metadataItem);
            }
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.ERROR);
            logger.log(ex);
        }
        IModelDataSource datasource = metadataItem.getDatasource();
        node.setPropertyValue(DATA_SOURCE_PROCESSED, Boolean.TRUE);
        if (null == datasource) {
            environment.setTreeHasBeenModified();
            return;
        }
        IModelDataSource cubeDatasource = metadataItem.getDatasource();
        execEnv.getOrAddDataSource(cubeDatasource);
        environment.setMADataSource(cubeDatasource);
        if (null != metadataQuery) {
            metadataQuery.setReferencedMetaItem(metadataItem);
        }
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MAConstraint maConstraint;
        XQETrace trace = environment.getTrace();
        MAQueryNode maQuery = (MAQueryNode)node;
        if (null != environment.getMADataSource()) {
            this.traceNodeCondition(false, "Data souce is bound.", trace);
            return false;
        }
        if (node.getAncestorOfCategory(1101030) != null) {
            this.traceNodeCondition(false, "Skip the MA MUN validation query.", trace);
            return false;
        }
        boolean isActionsQuery = node.getParent().isOfCategory(1101018);
        if (!maQuery.isMemberQuery() && !isActionsQuery) {
            this.traceNodeCondition(false, "The MA is not a member query or an actions query.", trace);
            return false;
        }
        MAMetadataQuery metadataQuery = maQuery.getMAMetadataQuery();
        if (!(maQuery.getType() != 1101021 || (maConstraint = (MAConstraint)node).getConstraint().equals("@coordinate") || maConstraint.isVariableConstraint() || metadataQuery != null && !metadataQuery.getPPDSConstraints().isEmpty())) {
            this.traceNodeCondition(false, "Don't need to bind data source for the constraint.", trace);
            return false;
        }
        String refItem = this.getReferencedDataItem(maQuery);
        if (refItem == null || !refItem.contains("[")) {
            this.traceNodeCondition(false, "Not a valid OLAP identifier.", trace);
            return false;
        }
        if (node.getPropertyValue(DATA_SOURCE_PROCESSED) != null) {
            this.traceNodeCondition(false, "Data source is already set if could.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The data source has not been bound.", trace);
        return true;
    }

    private String getReferencedDataItem(MAQueryNode maNode) {
        MAMetadataQuery metadataQuery = maNode.getMAMetadataQuery();
        String refItem = null;
        if (metadataQuery == null) {
            MAActionsQuery maActions = (MAActionsQuery)maNode.getParent();
            refItem = maActions.getCoordinate();
        } else {
            refItem = metadataQuery.getStartAtRefValue();
            if (refItem == null) {
                MAConstraint maConstraint = null;
                if (metadataQuery.isSAPVariableMAQuery()) {
                    maConstraint = metadataQuery.getVariableConstraint();
                } else if (metadataQuery.isSAPVariableMemberOperator()) {
                    maConstraint = metadataQuery.getMemberOperatorConstraint();
                }
                if (null != maConstraint) {
                    refItem = maConstraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND);
                }
            }
        }
        return refItem;
    }
}

