/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAFunctionsQuery;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.ma.MAQueryNode;
import com.cognos.xqe.ast.ma.MARequest;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemoser.MoserModuleUtil;
import org.dom4j.Element;

public class BindMASource
extends Transformation {
    public BindMASource() {
        this.mName = "Bind MA datasource to metadata connection.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1101013};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MARequest maRequest = (MARequest)node;
        if (null != maRequest.getMetadataConnection()) {
            this.traceNodeCondition(false, "The MA source has been bound.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MA source has not been bound.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] maNodes;
        MAFunctionsQuery funcQuery;
        MARequest maRequest = (MARequest)node;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        Element connectionElem = execEnv.getConnectionElement();
        Element dataSourceElem = connectionElem.element("dataSource");
        if (null == dataSourceElem) {
            node.throwInternalError("Element not found: dataSource");
        }
        String modelPath = dataSourceElem.attributeValue("value");
        String modelType = dataSourceElem.attributeValue("type");
        maRequest.setModelPath(modelPath);
        String authoringLocale = null;
        MAMetadataQuery maQuery = (MAMetadataQuery)maRequest.getFirstChildByType(1101015);
        if (maQuery != null) {
            authoringLocale = (String)maQuery.getPropertyValue("authoringLocale");
        }
        if (null == authoringLocale && null != (funcQuery = (MAFunctionsQuery)maRequest.getFirstChildByType(1101016))) {
            authoringLocale = (String)funcQuery.getPropertyValue("authoringLocale");
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if (authoringLocale != null && !authoringLocale.equals("en")) {
            requestEnv.setExpressionLocale(authoringLocale);
        }
        boolean forceMetadataRefresh = this.getIsRefreshRequest(maRequest);
        boolean reuseCachedConnection = true;
        boolean forceCMTrusted = false;
        boolean metadataRequest = requestEnv.isMetadataTreeRequest();
        boolean[] connectionOptions = MetadataService.getConnectionOptions(forceCMTrusted, forceMetadataRefresh, metadataRequest);
        MetadataConnection metadataConnection = MetadataService.getInstance().getConnection(MetadataService.getProviderTypeFromModelPath(modelType, modelPath), modelPath, execEnv, reuseCachedConnection, connectionOptions);
        if (MoserModuleUtil.isLWOLAP(metadataConnection)) {
            metadataConnection = MoserModuleUtil.getLWOLAPModulePackageConnection(metadataConnection);
            maRequest.setModelPath(metadataConnection.getModelPath());
            requestEnv.setModuleSearchPath(requestEnv.getModelPath());
            requestEnv.setModelPath(metadataConnection.getModelPath());
        }
        int[] types = new int[]{1101015, 1101030, 1101019, 1101021};
        for (IXQEQueryNode maNode : maNodes = maRequest.getDescendantsOfTypes(types, false)) {
            MAQueryNode maQueryNode = (MAQueryNode)maNode;
            maQueryNode.setMetadataConnection(metadataConnection);
        }
        maRequest.setMetadataConnection(metadataConnection);
        environment.setMetdataConnection(metadataConnection);
        environment.setTreeHasBeenModified();
    }

    private boolean getIsRefreshRequest(MARequest maRequest) {
        MAMetadataQuery metadataQuery = (MAMetadataQuery)maRequest.getFirstChildByType(1101015);
        if (metadataQuery == null) {
            return false;
        }
        String startAtPathValue = (String)metadataQuery.getPropertyValue("start_atPath");
        return startAtPathValue != null && startAtPathValue.isEmpty();
    }
}

