/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.IVirtualDimension;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import org.apache.commons.lang.StringUtils;

public class MAMetadataItem {
    private IMetadata metadata = null;
    private IHierarchy hierarchy = null;
    private ILevel level = null;
    private IDimension dimension = null;
    private ICube cube = null;
    private String memberUniqueName = null;
    private ICube variableCube = null;
    private IVariable variable = null;
    private String keyDate = null;
    private DateValue validFrom = null;
    private DateValue validTo = null;
    static final String OPEN_BRACKET = "[";
    static final String MUN_SEPARATOR = "].[";
    static final String CLOSE_BRACKET = "]";
    static final int THREE = 3;

    public void bindInModel(PlanningEnvironment planningEnvironment, String identifier) {
        MetadataConnection mdConnection = planningEnvironment.getMetadataConnection();
        MetricsService.startCollectingMetric((RequestEnvironment)planningEnvironment.getRequestEnvironment(), "mfwRequest");
        try {
            this.metadata = mdConnection.bindMetadataReference(identifier);
        }
        catch (MetadataBindingException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderIdentifier, t, identifier);
        }
        MetricsService.endCollectingMetric((RequestEnvironment)planningEnvironment.getRequestEnvironment(), "mfwRequest");
        if (null == this.metadata) {
            throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderIdentifier, identifier);
        }
        if (this.metadata instanceof IDimension) {
            this.dimension = (IDimension)this.metadata;
        } else {
            this.level = MetadataUtil.getLevel(this.metadata);
            this.hierarchy = MetadataUtil.getHierarchy(this.metadata);
            if (this.hierarchy != null) {
                this.dimension = this.hierarchy.getDimension();
            }
        }
        this.cube = MetadataUtil.getCube(this.metadata);
    }

    public void bindMUNInModel(PlanningEnvironment environment, String cognosMUN) {
        String leftPart = UniqueNameGenerator.extractLeftPartFromCognosMUN(cognosMUN);
        String rightPart = null;
        this.bindInModel(environment, leftPart);
        rightPart = this.metadata.isDMR() ? UniqueNameGenerator.extractLogicalPartFromCognosMUN(cognosMUN) : UniqueNameGenerator.extractPhysicalPartFromCognosMUN(cognosMUN);
        this.memberUniqueName = UniqueNameGenerator.createProviderMemberUniqueName(this.hierarchy, rightPart);
    }

    public void bindSAPVariableInModel(PlanningEnvironment planningEnvironment, String identifier) {
        String[] parts;
        String variableName = null;
        String cubeName = null;
        String datasourceName = null;
        IVariable variableWithoutDimension = null;
        ICube variableWithoutDimensionCube = null;
        try {
            parts = UniqueNameParser.parse(identifier);
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderIdentifier, (Throwable)e, identifier);
        }
        if (parts.length < 1 || parts.length > 3) {
            throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderIdentifier, identifier);
        }
        variableName = OPEN_BRACKET + parts[parts.length - 1] + CLOSE_BRACKET;
        if (parts.length >= 2) {
            cubeName = OPEN_BRACKET + parts[parts.length - 2] + CLOSE_BRACKET;
        }
        if (parts.length == 3) {
            datasourceName = parts[0];
        }
        block2: for (ICube aCube : planningEnvironment.getMetadataConnection().getCubes()) {
            for (IVariable aVariable : aCube.getVariables()) {
                if (variableName == null || !aVariable.getUniqueName().equals(variableName) || cubeName != null && !aCube.getName().equals(cubeName) || datasourceName != null && !aCube.getModelDataSource().getName().equals(datasourceName)) continue;
                if (aVariable.getDimension() != null) {
                    this.variable = aVariable;
                    this.variableCube = aCube;
                    continue block2;
                }
                if (variableWithoutDimension != null) continue;
                variableWithoutDimension = aVariable;
                variableWithoutDimensionCube = aCube;
            }
        }
        if (this.variable == null) {
            this.variable = variableWithoutDimension;
            this.variableCube = variableWithoutDimensionCube;
        }
        if (this.variable != null) {
            String dimensionUName = this.variable.getDimensionUniqueName();
            this.dimension = this.variableCube.getDimension(dimensionUName);
            if (this.dimension == null) {
                this.dimension = this.variableCube.queryDimension(dimensionUName);
                String hierMUN = this.variable.getHierarchyUniqueName();
                if (hierMUN != null) {
                    this.hierarchy = ((IVirtualDimension)this.dimension).queryHierarchy(hierMUN);
                }
            } else {
                this.hierarchy = this.variable.getHierarchy();
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderIdentifier, identifier);
        }
    }

    public void bindMUNWhenDimMissingInModel(PlanningEnvironment planningEnvironment, String cognosMUN, String varName) {
        try {
            String rightPart = UniqueNameGenerator.extractRightPartFromCognosMUN(cognosMUN);
            if (varName == null) {
                int index = rightPart.indexOf(MUN_SEPARATOR);
                if (index != -1) {
                    this.memberUniqueName = rightPart.substring(index + MUN_SEPARATOR.length() - 1, rightPart.length());
                }
            } else {
                this.bindSAPVariableInModel(planningEnvironment, varName);
                if (rightPart != null) {
                    this.memberUniqueName = UniqueNameGenerator.createProviderMemberUniqueName(this.hierarchy, rightPart);
                } else if (cognosMUN != null && cognosMUN.startsWith(OPEN_BRACKET) && cognosMUN.endsWith(CLOSE_BRACKET) && 1 == StringUtils.countMatches((String)cognosMUN, (String)MUN_SEPARATOR)) {
                    this.memberUniqueName = cognosMUN;
                }
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.PVD_InvalidProviderIdentifier, (Throwable)e, cognosMUN);
        }
    }

    public IMetadata getMetadata() {
        return this.metadata;
    }

    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public ILevel getLevel() {
        return this.level;
    }

    public IDimension getDimension() {
        return this.dimension;
    }

    public boolean isMeasuresDimension() {
        if (this.dimension != null) {
            return this.dimension.isMeasuresDimension();
        }
        return false;
    }

    public ICube getCube() {
        if (this.variableCube != null) {
            return this.variableCube;
        }
        return this.cube;
    }

    public IVariable getVariable() {
        return this.variable;
    }

    public IModelDataSource getDatasource() {
        if (this.getCube() != null) {
            return this.getCube().getModelDataSource();
        }
        return null;
    }

    public String getMemberUniqueName() {
        return this.memberUniqueName;
    }

    public String getKeyDate() {
        return this.keyDate;
    }

    public DateValue getValidFromDate() {
        return this.validFrom;
    }

    public DateValue getValidTo() {
        return this.validTo;
    }

    public void setKeyDate(PlanningEnvironment environment) {
        if (null == this.hierarchy) {
            return;
        }
        DateValue fromDate = DataValueFactory.createDateValue();
        fromDate.set(this.hierarchy.getProperty("Valid_From"));
        DateValue toDate = DataValueFactory.createDateValue();
        toDate.set(this.hierarchy.getProperty("Valid_To"));
        IModelDataSource modelDS = environment.getMADataSource();
        IDataSource dataSource = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getDataSourceByModelName(modelDS.getName());
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        this.keyDate = MetadataUtil.getKeydateWithConfig(fromDate, toDate, capabilities.isSupported("use.valid.from"));
        this.validFrom = fromDate;
        this.validTo = toDate;
    }

    public boolean searchWithDescendants(MAMetadataQuery maMetadataQuery) {
        boolean withDescendents;
        block3: {
            IXQEQueryNode[] maQueryHint;
            block2: {
                withDescendents = true;
                String depthValue = (String)maMetadataQuery.getPropertyValue("Depth");
                if (null == depthValue) break block2;
                if (!depthValue.equals("2")) break block3;
                withDescendents = false;
                break block3;
            }
            for (IXQEQueryNode child : maQueryHint = maMetadataQuery.getChildrenOfType(1101023)) {
                String hint = (String)child.getPropertyValue("value");
                if (null == hint || !hint.equals("RootMembers")) continue;
                withDescendents = false;
                break;
            }
        }
        if (this.getMemberUniqueName() != null) {
            return withDescendents;
        }
        return withDescendents || null != this.getLevel();
    }
}

