/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.convertMAQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.ma.member.response.XMAGenerateMemberResponse;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.querytemplates.AncestorQuery;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQueryFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.convertMAQuery.MAMunQueryToV5Query;
import com.cognos.xqe.transformation.ma.util.MetadataHelper;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.HashSet;

public class MAMunQueryToGetLogicalPart
extends MAMunQueryToV5Query {
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MAMetadataQuery maMetadataQuery = this.getMAMetadataQuery(node);
        IModelDataSource modelDS = environment.getMADataSource();
        ICube cube = modelDS.getCube();
        XMAGenerateMemberResponse xMemberResponse = MetadataHelper.generateMemberResponse(factory, maMetadataQuery);
        MAMetadataItem mdi = maMetadataQuery.getReferencedMetaItem();
        AncestorQuery ancestorQuery = (AncestorQuery)CustomQueryFactory.createCustomQuery("AncestorQuery", cube);
        IHierarchy hierarchy = mdi.getHierarchy();
        String mun = UniqueNameGenerator.createMemberExternalName(hierarchy, mdi.getMemberUniqueName());
        HashSet<String> getAncestors = new HashSet<String>();
        getAncestors.add(mun);
        ancestorQuery.setMemberNameList(getAncestors);
        String providerInterface = modelDS.getInterface();
        String hierarchyName = hierarchy.getUniqueName();
        if ("PC".equals(providerInterface)) {
            hierarchyName = StringSubstitutionEngine.unicodeEscapeString(hierarchyName);
        }
        ancestorQuery.setHierarchyName(hierarchyName);
        ancestorQuery.setDimensionProperties(this.getDimensionProperties(providerInterface));
        IDataSource ds = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getDataSourceByModelName(modelDS.getName());
        XMdx xMdxNode = (XMdx)factory.createXNode(501017);
        xMdxNode.setDataSource(ds);
        if (modelDS.getCatalog() != null) {
            xMdxNode.setCatalog(modelDS.getCatalog().getUniqueName());
        }
        xMdxNode.setCube(cube.getName());
        xMdxNode.setMDXQuery(ancestorQuery);
        xMemberResponse.addChild(xMdxNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        IModelDataSource queryDataSource = environment.getMADataSource();
        if (queryDataSource != null && (DataSourceTypeEnum.isSAPBW(queryDataSource.getInterface()) || DataSourceTypeEnum.isEssbase(queryDataSource.getInterface()) || DataSourceTypeEnum.isTMR(queryDataSource.getInterface()) || queryDataSource.isROLAP())) {
            this.traceNodeCondition(false, "The data provider uses a metadata query rather than MDX to get members.", trace);
            return false;
        }
        if (!this.getMAMetadataQuery(node).getMunQuery().equals("physical")) {
            this.traceNodeCondition(false, "The MUN query does not need to get the logical part of the MUN.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MUN query needs to get the logical part of the MUN.", trace);
        return true;
    }

    private MDXDimensionProperties getDimensionProperties(String provider) {
        MDXDimensionProperties properties = new MDXDimensionProperties();
        if ("PC".equals(provider)) {
            properties.addMemberProperty("PPDS_KEY");
        } else if ("TM".equals(provider) || "TMR".equals(provider) || DataSourceTypeEnum.isMicrosoft(provider)) {
            properties.addMemberProperty("MEMBER_KEY");
        } else {
            properties.addMemberProperty("MEMBER_UNIQUE_NAME");
        }
        return properties;
    }
}

