/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.convertMAQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.ma.member.response.XMAGenerateMemberResponse;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.convertMAQuery.MAMunQueryToV5Query;
import com.cognos.xqe.transformation.ma.util.MetadataHelper;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;

public class MAMunQueryToGetPhysicalPart
extends MAMunQueryToV5Query {
    private static final int HIERARCHY_PART = 3;
    private static final String END_ROLEVALUE = ") = '";
    private static final String END_FILTER = "')";

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (!this.getMAMetadataQuery(node).getMunQuery().equals("logical")) {
            this.traceNodeCondition(false, "The MUN query does not need to get the physical part of the MUN.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MUN query needs to get the physical part of the MUN.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MAMetadataQuery maMetadataQuery = this.getMAMetadataQuery(node);
        XMAGenerateMemberResponse xMemberResponse = MetadataHelper.generateMemberResponse(factory, maMetadataQuery);
        String expression = this.createExpression(maMetadataQuery.getStartAtRefValue(), environment);
        V5QuerySet subQuery = V5SubQueryBuilder.createSingleExpressionQuery(expression, environment);
        xMemberResponse.addChild(subQuery);
    }

    private String createExpression(String cognosMUN, PlanningEnvironment environment) {
        StringBuilder expression = new StringBuilder();
        try {
            String[] hierarchyParts = UniqueNameParser.parse(UniqueNameGenerator.extractLeftPartFromCognosMUN(cognosMUN), 3);
            String[] logicalParts = UniqueNameParser.parse(UniqueNameGenerator.extractLogicalPartFromCognosMUN(cognosMUN));
            String hierarchyName = UniqueNameGenerator.createUniqueName(hierarchyParts);
            for (String businessKey : logicalParts) {
                IModelDataSource queryDataSource = environment.getMADataSource();
                String key = businessKey;
                if (queryDataSource != null && DataSourceTypeEnum.isSAPBW(queryDataSource.getInterface())) {
                    MAMetadataItem metadataItem = new MAMetadataItem();
                    metadataItem.bindInModel(environment, hierarchyName);
                    IHierarchy hierarchy = metadataItem.getHierarchy();
                    String member = UniqueNameGenerator.createUniqueName(businessKey);
                    key = UniqueNameGenerator.join(hierarchy.getUniqueName(), member);
                }
                if (expression.length() == 0) {
                    expression.append("filter(members(");
                    expression.append(hierarchyName);
                    expression.append("),RoleValue('_businessKey',");
                    expression.append(hierarchyName);
                    expression.append(END_ROLEVALUE);
                    expression.append(key);
                    expression.append(END_FILTER);
                    continue;
                }
                expression.insert(0, "filter(generate(");
                expression.append(",descendants(currentmember(");
                expression.append(hierarchyName);
                expression.append("),1)),RoleValue('_businessKey',");
                expression.append(hierarchyName);
                expression.append(END_ROLEVALUE);
                expression.append(key);
                expression.append(END_FILTER);
            }
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_ParsingException, (Throwable)e, cognosMUN);
        }
        return expression.toString();
    }
}

