/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.convertMAQuery;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MAStartAt;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.AbstractV5Set;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.ma.member.response.XMAExplicitMemberResponse;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.convertMAQuery.MAQuerytoV5Query;
import java.util.ArrayList;

public class MAQueryToV5QueryForMultipleStartAts
extends MAQuerytoV5Query {
    public MAQueryToV5QueryForMultipleStartAts() {
        this.mName = "Convert MAMetadataQuery to V5QuerySet for multiple startAtRef's.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101019};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (this.getMAMetadataQuery(node).getDescendantsOfType(1101028, false).length == 0) {
            this.traceNodeCondition(false, "Metadata query does contain multiple startAtRef's", trace);
            return false;
        }
        this.traceNodeCondition(true, "Metadata query contains multiple startAtRef's", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XMAExplicitMemberResponse xMemberResponse;
        super.apply(node, environment);
        MACollection collection = this.getMemberCollection(node);
        collection.setUseMetadataCallOnly();
        MAStartAt startAtNode = (MAStartAt)this.getMAMetadataQuery(node).getFirstChildByType(1101028);
        if (startAtNode != null && (xMemberResponse = (XMAExplicitMemberResponse)collection.getFirstChildByType(501145)) != null) {
            xMemberResponse.setPropertyValue("requestedMuns", startAtNode.getPaths());
        }
    }

    @Override
    protected AbstractV5Set buildFilterOrOtherSetExpr(IXQEQueryNode node, String refItem, IXQENodeFactory factory, MAMetadataQuery maMetadataQuery) {
        return null;
    }

    @Override
    protected void addDataItems(IXQEQueryNode node, V5Selection selection, IXQENodeFactory factory, MAMetadataQuery maMetadataQuery, MACollection memberCollection) {
        MAStartAt startAtNode = (MAStartAt)maMetadataQuery.getFirstChildByType(1101028);
        ArrayList<String> startAt = startAtNode.getPaths();
        for (String expression : startAt) {
            V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
            dataItem.setAggregateProperty("none");
            dataItem.setNameProperty(expression);
            dataItem.setRollupAggregateProperty("none");
            V5Expression v5Expression = (V5Expression)factory.createNode(101004);
            v5Expression.setExpression(expression);
            V5SetFunction v5Set = (V5SetFunction)factory.createNode(201101);
            v5Set.addChild(v5Expression);
            dataItem.addChild(v5Expression);
            selection.addChild(dataItem);
        }
    }

    @Override
    protected V5QueryResultDefinition buildQRD(IXQENodeFactory factory, MACollection memberCollection) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)factory.createNode(101055);
        V5Edge edge1 = (V5Edge)factory.createNode(101049);
        V5Edge edge2 = (V5Edge)factory.createNode(101049);
        qrd.addChild(edge1);
        qrd.addChild(edge2);
        this.buildEdgeGroups(edge2, factory, memberCollection);
        edge1.setPropertyValue("name", "edge1");
        edge1.setEdgeID(1);
        edge2.setPropertyValue("name", "2");
        edge2.setEdgeID(2);
        qrd.setPropertyValue("name", "rs1");
        qrd.setRefQueryProperty("query1");
        return qrd;
    }

    protected void buildEdgeGroups(IXQEQueryNode edge, IXQENodeFactory factory, MACollection memberCollection) {
        MAStartAt startAtNode = (MAStartAt)this.getMAMetadataQuery(memberCollection).getFirstChildByType(1101028);
        ArrayList<String> startAt = startAtNode.getPaths();
        for (String refDataItem : startAt) {
            V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
            V5ValueSet valueSet = (V5ValueSet)factory.createNode(101057);
            edgeGroup.addChild(valueSet);
            valueSet.setNameProperty(refDataItem);
            valueSet.setRefDataItemProperty(refDataItem);
            MAQueryToV5QueryForMultipleStartAts.setV5QRDValueSetProperties(valueSet, memberCollection, factory);
            edge.addChild(edgeGroup);
        }
    }
}

