/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.convertMAQuery;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.AbstractV5Set;
import com.cognos.xqe.ast.v5Exp.V5ChildrenFunction;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.convertMAQuery.WithSingleStartAt;

public class MAQuerytoV5QueryforExplicitMember
extends WithSingleStartAt {
    public MAQuerytoV5QueryforExplicitMember() {
        this.mName = "Convert Explicit Member MAMetadataQuery to V5QuerySet.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101019};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        MAMetadataQuery maMetadataQuery = this.getMAMetadataQuery(node);
        if (maMetadataQuery.isMemberSearchMAQuery()) {
            this.traceNodeCondition(false, "The MAMetadataQuery is a member search query. Other transformation should apply.", trace);
            return false;
        }
        if (maMetadataQuery.isExplicitMemberQuery()) {
            this.traceNodeCondition(true, "The MA Query is explicit member query.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The MAMetadataQuery is NOT a explicit member query. Other transformation will apply.", trace);
        return false;
    }

    @Override
    public AbstractV5Set buildFilterOrOtherSetExpr(IXQEQueryNode node, String startAtRef, IXQENodeFactory factory, MAMetadataQuery maMetadataQuery) {
        AbstractV5Set v5Set = null;
        String stringDepth = (String)maMetadataQuery.getPropertyValue("Depth");
        if (stringDepth != null && !stringDepth.equals("") && Integer.valueOf(stringDepth) <= 1) {
            v5Set = (V5SetFunction)factory.createNode(201101);
            V5Expression munExpr = (V5Expression)factory.createNode(101004);
            munExpr.setExpression(startAtRef);
            v5Set.addChild(munExpr);
        } else {
            v5Set = (V5ChildrenFunction)factory.createNode(201053);
            V5Expression munExpr = (V5Expression)factory.createNode(101004);
            munExpr.setExpression(startAtRef);
            v5Set.addChild(munExpr);
        }
        return v5Set;
    }

    @Override
    protected void buildV5Query(IXQEQueryNode node, V5Query v5Query, PlanningEnvironment environment, MAMetadataQuery maMetadataQuery, MACollection memberCollection) {
        super.buildV5Query(node, v5Query, environment, maMetadataQuery, memberCollection);
        this.addRootMemberToV5Query(v5Query, environment.getNodeFactory(), maMetadataQuery);
    }
}

