/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.convertMAQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.convertMAQuery.MAQuerytoV5Query;

public abstract class WithSingleStartAt
extends MAQuerytoV5Query {
    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] startAt = node.getAncestorsOfType(1101028);
        if (startAt != null && startAt.length > 0) {
            this.traceNodeCondition(false, "Multiple startAt nodes exist", trace);
            return false;
        }
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MAMetadataQuery maMetadataQuery = this.getMAMetadataQuery(node);
        MAMetadataItem metaItem = maMetadataQuery.getReferencedMetaItem();
        if (null == metaItem || metaItem.isMeasuresDimension()) {
            this.traceNodeCondition(false, "Not a member query.", trace);
            return false;
        }
        IModelDataSource queryDataSource = environment.getMADataSource();
        if (queryDataSource != null) {
            String queryDataSourceType = queryDataSource.getInterface();
            if (DataSourceTypeEnum.isSAPBW(queryDataSourceType) || DataSourceTypeEnum.isEssbase(queryDataSourceType) || DataSourceTypeEnum.isTMR(queryDataSourceType)) {
                this.traceNodeCondition(false, "The data provider uses a metadata query rather than MDX to get members.", trace);
                return false;
            }
            if (DataSourceTypeEnum.isTM1(queryDataSourceType)) {
                IDataSourceCapabilities capabilities = environment.getCapabilities(queryDataSourceType);
                if (!capabilities.isSupported("v5.useLocalOLAP")) {
                    this.traceNodeCondition(false, "LOLAP is not supported send Member Metadata queries to NGTM1.", trace);
                    return false;
                }
                if (maMetadataQuery.isMemberSearchMAQuery()) {
                    this.traceNodeCondition(false, "TM1 member search uses a metadata query rather than MDX to get members.", trace);
                    return false;
                }
            }
        }
        this.traceNodeCondition(true, "The MAMetadataQuery needs to be converted to a V5QuerySet.", trace);
        return true;
    }
}

