/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.provider.BindMAIdentifier;

public class BindMAMemberUniqueName
extends BindMAIdentifier {
    public BindMAMemberUniqueName() {
        this.mName = "Bind Member Unique Name for SAP or Essbase.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101021, 1101019};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        if (!maMetadataQuery.isExplicitMemberQuery() && !maMetadataQuery.isSAPVariableMemberOperator()) {
            this.traceNodeCondition(false, "The MAMetadataQuery is NOT an explicit member query or an explicit member operation against an SAP variable.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This Cognos MUN need to be resolved.", trace);
        return true;
    }

    @Override
    void setLevelAndMember(MAMetadataQuery maQuery, PlanningEnvironment environment) {
        MACollection memberCollection = maQuery.getMemberCollection();
        MAMetadataItem metaDataItem = maQuery.getReferencedMetaItem();
        String mun = metaDataItem.getMemberUniqueName();
        memberCollection.setPropertyValue("memberUniqueName", mun);
        String queryDataSourceType = this.getMADatasourceType(environment);
        if (!DataSourceTypeEnum.isEssbase(queryDataSourceType)) {
            return;
        }
        ILevel level = metaDataItem.getLevel();
        String lun = null;
        if (level != null) {
            lun = level.getUniqueName();
        }
        memberCollection.setPropertyValue("levelUniqueName", lun);
    }
}

