/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.ProviderCategoryEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.provider.ProviderTransformation;

public abstract class MemberTransformation
extends ProviderTransformation {
    public MemberTransformation() {
        super(new String[]{"BW", "DO", "EB", "TM", "TMR"});
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        if (maMetadataQuery == null) {
            this.traceNodeCondition(false, "MAMetadataQuery is null so not a member query.", trace);
            return false;
        }
        if (!(maMetadataQuery.getGenerateV5() || maMetadataQuery.isSAPVariableMAQuery() || maMetadataQuery.isSAPVariableMemberOperator())) {
            this.traceNodeCondition(false, "GenerateV5 is false.", trace);
            return false;
        }
        String queryDataSourceType = this.getMADatasourceType(environment);
        if (DataSourceTypeEnum.isTM1(queryDataSourceType)) {
            IDataSourceCapabilities capabilities = environment.getCapabilities(queryDataSourceType);
            if (!capabilities.isSupported("v5.useLocalOLAP")) {
                return true;
            }
            if (maMetadataQuery.isMemberSearchMAQuery()) {
                return true;
            }
            this.traceNodeCondition(false, "Use MDX for this TM1 Metadata query.", trace);
            return false;
        }
        ProviderManager.ProviderInfo providerInfo = ProviderManager.getInstance().getProviderInfo(queryDataSourceType);
        if (providerInfo.getProviderCategory() == ProviderCategoryEnum.OLAP) {
            IOLAPDataProvider provider = ProviderManager.getInstance().getOLAPProvider(queryDataSourceType);
            if (provider.getClass().getName().endsWith("MDDSDataProvider")) {
                this.traceNodeCondition(false, "The provider type is MDDS using the C++ OPTSDK this transformation only applies to native Java providers.", trace);
                return false;
            }
            return true;
        }
        this.traceNodeCondition(false, "The provider type is not OLAP type.", trace);
        return false;
    }

    public MACollection getMAMemberCollection(IXQEQueryNode node, MAMetadataQuery maMetadataQuery) {
        MACollection memberCollection = null;
        memberCollection = node.getType() == 1101019 ? (MACollection)node : maMetadataQuery.getMemberCollection();
        return memberCollection;
    }

    public String getMADatasourceType(PlanningEnvironment environment) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        IModelDataSource modelDS = environment.getMADataSource();
        return execEnv.getDataSourceByModelName(modelDS.getName()).getType();
    }
}

