/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public abstract class ProviderTransformation
extends Transformation {
    private final String[] dataSourceTypes;

    public ProviderTransformation(String dsType) {
        this.dataSourceTypes = new String[]{dsType};
    }

    public ProviderTransformation(String[] dsTypes) {
        this.dataSourceTypes = dsTypes;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IModelDataSource queryDataSource = environment.getMADataSource();
        if (queryDataSource == null) {
            this.traceNodeCondition(false, "The data source isn't bound at earlier passes. Not a member query.", trace);
            return false;
        }
        String queryDataSourceType = queryDataSource.getInterface();
        for (int i = 0; i < this.dataSourceTypes.length; ++i) {
            if (!this.dataSourceTypes[i].equals(queryDataSourceType)) continue;
            return true;
        }
        this.traceNodeCondition(false, this.dataSourceMessage(), trace);
        return false;
    }

    private String dataSourceMessage() {
        StringBuilder sb = new StringBuilder("The provider type is not ");
        if (this.dataSourceTypes.length < 0) {
            sb.append("set");
            return sb.toString();
        }
        sb.append(this.dataSourceTypes[0]);
        for (int i = 1; i < this.dataSourceTypes.length; ++i) {
            sb.append(" or ");
            sb.append(DataSourceTypeEnum.getProviderName(this.dataSourceTypes[i]));
        }
        sb.append(".");
        return sb.toString();
    }
}

