/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MAConstraint;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.parameters.RequestParameters;
import com.cognos.xqe.query.parameters.V5ParameterValueItem;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.provider.SetRestrictionsForMAQuery;

public class SetSAPBapiRestrictionsForGetVariable
extends SetRestrictionsForMAQuery {
    private static final String UNIQUENAME_SEPARATOR = "].[";

    public SetSAPBapiRestrictionsForGetVariable() {
        this.mName = "Set Bapi constrains for SAP GetVariables.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101021};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (((MAConstraint)node).isVariableConstraint()) {
            this.traceNodeCondition(true, "The MAConstraint is SAP variable constraint. Need to generate variable restriction.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The Constraint is NOT SAP variable query.", trace);
        return false;
    }

    @Override
    public void buildRestriction(IXQEQueryNode node, PlanningEnvironment environment, MetadataRestriction restriction) {
        super.buildRestriction(node, environment, restriction);
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        MAMetadataItem metadataItem = maMetadataQuery.getReferencedMetaItem();
        IVariable variable = metadataItem.getVariable();
        if (variable == null) {
            node.throwInternalError("SAP variable not found. ");
        }
        String varUniqueName = variable.getUniqueName();
        restriction.add(RestrictionType.VARIABLE, varUniqueName);
        String dum = variable.getDimensionUniqueName();
        String hum = variable.getHierarchyUniqueName();
        restriction.add(RestrictionType.DIMENSION_UNIQUE_NAME, dum);
        if (maMetadataQuery.isSAPHierarchyVariableMAQuery()) {
            String savedHierMUN = this.getSavedHierMun(environment, variable);
            if (savedHierMUN != null) {
                maMetadataQuery.setPropertyValue("hierMUN", savedHierMUN);
            }
        } else {
            restriction.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hum);
        }
    }

    private String getSavedHierMun(PlanningEnvironment environment, IVariable variable) {
        RequestParameters requestedParameters = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext().getRequestParameters();
        Parameters parameters = requestedParameters.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            ParameterValueItem valueItem;
            Parameter parameter = parameters.getParameter(variable.getUniqueName());
            parameter.setVariableInfo(environment, variable);
            ParameterValues variableValues = requestedParameters.getParameterValueItems(parameter);
            if (variableValues != null && !variableValues.isEmpty() && (valueItem = (ParameterValueItem)variableValues.get(0)) instanceof V5ParameterValueItem) {
                String memberMun = ((V5ParameterValueItem)valueItem).getExternalValue();
                int index = memberMun.indexOf(UNIQUENAME_SEPARATOR);
                if (index != -1) {
                    return memberMun.substring(0, index + 1);
                }
                return memberMun;
            }
        }
        return null;
    }
}

