/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.missingMember.MissingMember;
import com.cognos.xqe.query.missingMember.MissingMemberException;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.provider.MemberTransformation;
import java.util.Map;

public final class ValidateMAMunBinding
extends MemberTransformation {
    public ValidateMAMunBinding() {
        this.mName = "Validate whether the mun binding is succesful for ma query.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101019};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        int aSeverity = 0;
        Map<String, MissingMember> missingMembers = reqEnv.getRequestMissingMembers();
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        String mun = maMetadataQuery.getStartAtRefValue();
        MissingMember maMM = new MissingMember();
        String queryName = "maQuery";
        String dataItemName = "start_atRef";
        maMM.setQueryName(queryName);
        maMM.setRefDataItem(dataItemName);
        missingMembers.put(mun, maMM);
        environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_MissingMembers, mun));
        if (mun != null) {
            throw new MissingMemberException(reqEnv, mun);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        MACollection collection = (MACollection)node;
        if (!collection.isMemberQuery()) {
            this.traceNodeCondition(false, "The MACollection is not a member MACollection.", trace);
            return false;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)environment.getRequestEnvironment();
        Map<String, MissingMember> missingMemberList = reqEnv.getRequestMissingMembers();
        if (missingMemberList.size() > 0) {
            this.traceNodeCondition(false, "Muns already validated.", trace);
            return false;
        }
        MAMetadataQuery maQuery = collection.getMAMetadataQuery();
        if (null != maQuery && !maQuery.isExplicitMemberQuery()) {
            this.traceNodeCondition(false, "This transformation is only needed for explicit member query.", trace);
            return false;
        }
        MACollection memberCollection = maQuery.getMemberCollection();
        if (!memberCollection.isMunBindingFailed()) {
            this.traceNodeCondition(false, "This transformation is only needed for mun that failed binding.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The ma query has invalid mun, need to add it to missing member list.", trace);
        return true;
    }
}

