/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.mdx.parser.ASTCharacterStringLiteral;
import com.cognos.xqe.ast.mdx.parser.ASTFactor;
import com.cognos.xqe.ast.mdx.parser.ASTMDXNode;
import com.cognos.xqe.ast.mdx.parser.ASTMemberName;
import com.cognos.xqe.ast.mdx.parser.ASTMemberPropertyDefinition;
import com.cognos.xqe.ast.mdx.parser.ASTMemberSpecification;
import com.cognos.xqe.ast.mdx.parser.ASTStringValueExpression;
import com.cognos.xqe.ast.mdx.parser.ASTUnsignedNumericLiteral;
import com.cognos.xqe.ast.mdx.parser.ASTValueExpressionPrimary;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXParserUtility;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.XMdxMemberPropertyDefinition;
import com.cognos.xqe.runtree.olap.mdx.XMdxSelect;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;

public class GenerateXMdxCalculatedMember
extends Transformation {
    private static final String PROPERTY_LITERAL = "literal";
    private static final String PROPERTY_NAME = "name";
    private static final String SOLVE_ORDER = "SOLVE_ORDER";

    public GenerateXMdxCalculatedMember() {
        this.mName = "Generate The XMdxCalculatedMember node, the runtree node that will perform calculated member execution.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{701042};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String[] identifiers;
        String cmUniqueName;
        String f;
        IXQEQueryNode parentNode;
        XQENodeFactory factory = environment.getNodeFactory();
        XMdxCalculatedMember xNode = (XMdxCalculatedMember)factory.createNode(501101);
        xNode.setParserNode((MDXQueryNode)node);
        ASTMemberSpecification memberSpec = (ASTMemberSpecification)node;
        IXQEQueryNode calculationAST = null;
        HashSet<String> alreadySetProperties = new HashSet<String>();
        ArrayList<XMdxMemberPropertyDefinition> memPropertyNodes = new ArrayList<XMdxMemberPropertyDefinition>();
        for (IXQEQueryNode childNode : memberSpec.getChildren()) {
            if (childNode instanceof ASTMemberName) {
                ASTMemberName mnNode = (ASTMemberName)childNode;
                IXQEQueryNode[] mnChildren = childNode.getChildren();
                String[] identifier = new String[mnChildren.length];
                for (int m = 0; m < mnChildren.length; ++m) {
                    if (!(mnNode.getChild(m) instanceof ASTMDXNode)) continue;
                    identifier[m] = ((ASTMDXNode)mnNode.getChild(m)).getText();
                }
                xNode.setPropertyValue("identifier", identifier);
                continue;
            }
            if (childNode instanceof ASTCharacterStringLiteral) {
                String literal = ((ASTCharacterStringLiteral)childNode).getParameter(PROPERTY_LITERAL);
                if (literal == null || literal.length() <= 0) continue;
                xNode.setPropertyValue(PROPERTY_LITERAL, literal);
                continue;
            }
            if (childNode instanceof ASTMemberPropertyDefinition) {
                ASTMemberPropertyDefinition propertyNode = (ASTMemberPropertyDefinition)childNode;
                if (propertyNode.getNumberChildren() != 2) continue;
                String propName = null;
                String propValue = null;
                if (propertyNode.getChild(0) instanceof ASTMDXNode) {
                    propName = ((ASTMDXNode)propertyNode.getChild(0)).getText();
                }
                if (alreadySetProperties.contains(propName.toUpperCase())) {
                    throw new MDXEngineException("X01492", new String[]{propName});
                }
                if (!(!propName.equalsIgnoreCase(SOLVE_ORDER) || propertyNode.getChild(1) instanceof ASTUnsignedNumericLiteral || propertyNode.getChild(1) instanceof ASTFactor && propertyNode.getChild(1).getNumberChildren() == 1 && propertyNode.getChild(1).getChild(0) instanceof ASTUnsignedNumericLiteral)) {
                    throw new MDXEngineException("X01433", new String[]{SOLVE_ORDER, "CMP_TYPENUMERIC"});
                }
                alreadySetProperties.add(propName.toUpperCase());
                if (propertyNode.getChild(1) instanceof ASTUnsignedNumericLiteral) {
                    propValue = ((ASTUnsignedNumericLiteral)propertyNode.getChild(1)).getParameter(PROPERTY_LITERAL);
                    if (propName.equalsIgnoreCase(SOLVE_ORDER) && Double.valueOf(propValue) > 2.147483647E9) {
                        throw new MDXEngineException("X01491");
                    }
                } else if (propertyNode.getChild(1) instanceof ASTStringValueExpression) {
                    IXQEQueryNode strNode = propertyNode.getChild(1).getChild(0).getChild(0);
                    if (strNode instanceof ASTCharacterStringLiteral) {
                        propValue = ((ASTCharacterStringLiteral)strNode).getParameter(PROPERTY_LITERAL);
                    } else if (strNode instanceof ASTMDXNode) {
                        propValue = ((ASTMDXNode)strNode).getText();
                    }
                    String propString = propValue;
                    propValue = CalculatedMember.unescapeCalculationString(propString);
                } else if (propertyNode.getChild(1) instanceof ASTValueExpressionPrimary) {
                    IXQEQueryNode valueExpression = propertyNode.getChild(1);
                    valueExpression.detach();
                    XMdxMemberPropertyDefinition mpNode = (XMdxMemberPropertyDefinition)factory.createNode(501127);
                    mpNode.setPropertyValue(PROPERTY_NAME, propName);
                    mpNode.addChild(valueExpression);
                    memPropertyNodes.add(mpNode);
                }
                if (propName == null || propValue == null) continue;
                xNode.setPropertyValue(propName, propValue);
                continue;
            }
            calculationAST = childNode;
        }
        if (calculationAST != null) {
            calculationAST.detach();
            xNode.addChild(calculationAST);
        } else {
            if (xNode.getPropertyValue(PROPERTY_LITERAL) == null) {
                throw new MDXEngineException(XQEMessageKeys.MDX_RuntreeGenerationFailed);
            }
            String calculationString = CalculatedMember.unescapeCalculationString((String)xNode.getPropertyValue(PROPERTY_LITERAL));
            MDXQueryNode mdxNode = MDXParserUtility.parseMDX(calculationString, environment, MDXParserUtility.ParseType.VALUE_EXPRESSION);
            xNode.addChild(mdxNode);
        }
        if (memPropertyNodes.size() > 0) {
            for (int i = 0; i < memPropertyNodes.size(); ++i) {
                xNode.addChild((IXQEQueryNode)memPropertyNodes.get(i));
            }
        }
        node.getParent().exchangeChildNode(node, xNode);
        XMdxLocal xmdxLocal = null;
        MDXQuery mdxQuery = null;
        for (parentNode = xNode.getParent(); parentNode != null && !(parentNode instanceof XMdxLocal); parentNode = parentNode.getParent()) {
        }
        if (parentNode != null && parentNode instanceof XMdxLocal) {
            xmdxLocal = (XMdxLocal)parentNode;
            mdxQuery = xmdxLocal.getMDXQuery();
        }
        if (mdxQuery != null) {
            MDXCalculatedMemberDefinition[] calculatedMembers = mdxQuery.getCalcMemberDefinitions();
            String[] identifiers2 = (String[])xNode.getPropertyValue("identifier");
            String cmUniqueName2 = UniqueNameGenerator.createUniqueName(identifiers2);
            for (int i = 0; i < calculatedMembers.length; ++i) {
                MDXCalculatedMemberReference cmRef;
                boolean isTagTupleCalc;
                String cmName = calculatedMembers[i].getUniqueName();
                if (!cmName.equals(cmUniqueName2)) continue;
                boolean bl = isTagTupleCalc = calculatedMembers[i].isTag() || calculatedMembers[i].isFillerTag() || calculatedMembers[i].isANSMore();
                if (!isTagTupleCalc && calculatedMembers[i].getCalcMemberRefs() != null && !calculatedMembers[i].getCalcMemberRefs().isEmpty() && (cmRef = calculatedMembers[i].getCalcMemberRefs().get(0)).getParent().isOfCategory(1069)) {
                    IXQEQueryNode[] siblingCalcRefs;
                    for (IXQEQueryNode siblingCalcRef : siblingCalcRefs = cmRef.getParent().getChildrenOfType(1013)) {
                        if (siblingCalcRef == cmRef || !((MDXCalculatedMemberReference)siblingCalcRef).isTag() && !((MDXCalculatedMemberReference)siblingCalcRef).isFillerTag() && !((MDXCalculatedMemberReference)siblingCalcRef).getDefinition().isANSMore()) continue;
                        isTagTupleCalc = true;
                        break;
                    }
                }
                if (!isTagTupleCalc) continue;
                xNode.setPropertyValue("nullTag", true);
                for (parentNode = xNode.getParent(); parentNode != null && !(parentNode instanceof XMdxSelect); parentNode = parentNode.getParent()) {
                }
                parentNode.setPropertyValue("nullTag", true);
                break;
            }
        }
        if (xmdxLocal != null && (f = xmdxLocal.getCalculatedMemberFormatId(cmUniqueName = UniqueNameGenerator.createUniqueName(identifiers = (String[])xNode.getPropertyValue("identifier")))) != null) {
            xNode.setPropertyValue("FORMAT_STRING", f);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        this.traceQueryCondition(true, "GenerateXMdxCalculatedMember applied.", environment.getTrace());
        return true;
    }
}

