/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.mdx.parser.ASTMDXStatement;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXParameterMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSAPVariables;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.olap.util.MDXParserUtility;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryOptimizationInfo;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.DMRSetFunctionToExplicitSetUtil;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.NodeConditions.IsProjectedDescendant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GenerateXMdxLocalNode
extends Transformation {
    private static XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryProcessing", LogLevel.INFO);
    private static XQELogger mdxLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.INFO);

    public GenerateXMdxLocalNode() {
        this.mName = "Generate The XMdxLocal node, the runtree node that will perform local MDX execution.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        HashMap namedSetMap;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXFromCube fromCube = (MDXFromCube)node.getFirstChildByType(1007);
        boolean hasVariable = false;
        MDXQuery tempNode = null;
        IDataSource dataSource = fromCube.getCMDataSource();
        Map<String, Object> properties = dataSource.getMetadataProperties();
        XMdxLocal xNode = (XMdxLocal)nodeFactory.createNode(501053);
        ICube cube = fromCube.getCube();
        if (cube != null && cube instanceof CubeWrapper && ((CubeWrapper)cube).getTabularResultSetName() != null) {
            xNode.setTabularResultSetName(((CubeWrapper)cube).getTabularResultSetName());
        }
        if (cube != null && cube instanceof CubeWrapper) {
            this.registerFormatIds(xNode, node);
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        boolean isDMR = mdxQuery.isDMR();
        xNode.setIsDMR(isDMR);
        xNode.setIsDMRCubeReuseEnabled(mdxQuery.isDMRCubeReuseEnabled());
        xNode.setIsConstantQuery(mdxQuery.isConstantQuery());
        Object valueDetailFilter = mdxQuery.getPropertyValue("queryValueDetailFilter");
        if (valueDetailFilter != null) {
            StringBuilder bufQueryContext = new StringBuilder();
            ((IXQEQueryNode)valueDetailFilter).writeFormattedText(bufQueryContext);
            xNode.setVDFilter(bufQueryContext.toString());
        }
        Object hasUnresolveDefaultMemberProp = mdxQuery.getPropertyValue("hasUnresolvedDefaultMember");
        if (!xNode.hasUnResolvedDefaultMember() && hasUnresolveDefaultMemberProp != null && hasUnresolveDefaultMemberProp == Boolean.TRUE) {
            xNode.setHasUnResolvedDefaultMember(true);
        }
        if (logger.isOn(LogLevel.INFO) && environment.getRoot().getType() == 101002) {
            mdxQuery.logQueryProcessingType(logger);
        }
        ArrayList<MDXDimensionProperties> aDimensionPropertiesList = new ArrayList<MDXDimensionProperties>();
        for (MDXEdge edge : mdxQuery.getEdges()) {
            aDimensionPropertiesList.add(edge.getDimensionProperties());
        }
        xNode.setDimPropertiesForAncestorQuery(aDimensionPropertiesList);
        xNode.setDataSource(dataSource);
        xNode.setCatalog((String)properties.get("catalog"));
        MDXSAPVariables sapVariables = (MDXSAPVariables)mdxQuery.getPropertyValue("sapVariables");
        if (sapVariables != null && sapVariables.getSAPVariableCount() > 0) {
            tempNode = (MDXQuery)nodeFactory.deepCopyNode(mdxQuery);
            ((MDXQuery)node).removeProperty("sapVariables");
            hasVariable = true;
        }
        xNode.setMDXQuery(mdxQuery);
        xNode.setLevelInfoProperty(mdxQuery.getLowestReferencedLevelInfo(null));
        if (isDMR) {
            this.createOptimizationInfo(mdxQuery);
        }
        List<AbstractMDXNode> calculatedMembers = mdxQuery.getDescendantsOfType(1005, false, false, false, false, false);
        HashMap<String, String> calculatedMembersMap = new HashMap<String, String>(calculatedMembers.size());
        for (AbstractMDXNode calculatedMember : calculatedMembers) {
            String uniqueName = ((MDXCalculatedMemberDefinition)calculatedMember).getUniqueName();
            String originalUniqueName = ((MDXCalculatedMemberDefinition)calculatedMember).getPrefix();
            int beginning = originalUniqueName.indexOf("_", 1);
            if (beginning <= 0) continue;
            calculatedMembersMap.put(uniqueName, originalUniqueName.substring(beginning + 1));
        }
        if (!calculatedMembersMap.isEmpty()) {
            xNode.setCalculatedMemberUniqueNameMap(calculatedMembersMap);
        }
        if ((namedSetMap = (HashMap)mdxQuery.getPropertyValue("queryNamedSetNameToExpandedDefinition")) != null) {
            xNode.setQueryNamedSetNameToExpandedDefinitionMap(namedSetMap);
        }
        if (isDMR && mdxQuery.getDMRAggregateSummaryOptimizationLevel() > 1) {
            this.collectAggregationLevelInfo(mdxQuery);
        }
        mdxQuery.generateMDX();
        String mdxString = xNode.getMDXQuery().getMDX();
        ASTMDXStatement mdxStatement = (ASTMDXStatement)MDXParserUtility.parseMDX(mdxString, environment, MDXParserUtility.ParseType.STATEMENT);
        mdxLogger.log(mdxString);
        IXQEQueryNode[] children = mdxStatement.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode childNode = children[i];
            childNode.setParent(null);
            xNode.addChild(childNode);
        }
        if (hasVariable) {
            xNode.setMDXQuery(tempNode);
        }
        node.getParent().exchangeChildNode(node, xNode, false);
    }

    private void collectAggregationLevelInfo(MDXQuery mdxQuery) {
        ArrayList<IXQEQueryNode> valueExpressions = new ArrayList<IXQEQueryNode>();
        IXQEQueryNode[] summaryFunctions = mdxQuery.getDescendantsOfType(1060, false);
        for (int i = 0; i < summaryFunctions.length; ++i) {
            if (summaryFunctions[i].getNumberChildren() != 1) continue;
            valueExpressions.add(summaryFunctions[i]);
        }
        IXQEQueryNode[] tupleExpressions = mdxQuery.getDescendantsOfType(1069, false);
        valueExpressions.addAll(Arrays.asList(tupleExpressions));
        for (IXQEQueryNode aValueExpression : valueExpressions) {
            if (!((AbstractMDXNode)aValueExpression).isValueExpressionOperand()) continue;
            MDXLevelInfo aggregationLevel = null;
            IXQEQueryNode cmDefinition = aValueExpression.getAncestorOfType(1005);
            if (cmDefinition != null) {
                IXQEQueryNode currentEdge;
                MDXLevelInfo aggregationLevelWithInCM = ((AbstractMDXNode)aValueExpression).getValueContextLevelInfo((AbstractMDXNode)cmDefinition, null);
                MDXEdge[] edges = mdxQuery.getEdges();
                MDXDimensionLine dimLine = mdxQuery.getDimensionLine();
                List<MDXCalculatedMemberReference> refs = ((MDXCalculatedMemberDefinition)cmDefinition).getCalcMemberRefs();
                ArrayList<MDXCalculatedMemberReference> refsOnEdge = new ArrayList<MDXCalculatedMemberReference>();
                for (MDXCalculatedMemberReference aRef : refs) {
                    Set<IHierarchy> refHierarchiesOnEdge;
                    currentEdge = aRef.getAncestorOfType(1006);
                    if (currentEdge == null || (refHierarchiesOnEdge = ((MDXEdge)currentEdge).getReferencedHierarchies()).size() == 1 && refHierarchiesOnEdge.contains(mdxQuery.getMeasuresHierarchy())) continue;
                    refsOnEdge.add(aRef);
                }
                for (MDXCalculatedMemberReference aRef : refsOnEdge) {
                    aggregationLevel = aRef.getValueContextLevelInfo();
                    currentEdge = aRef.getAncestorOfType(1006);
                    for (int i = 0; i < edges.length; ++i) {
                        IXQEQueryNode[] intersectingCalcs;
                        if (edges[i] == currentEdge) continue;
                        List<IHierarchy> edgeHierInfo = edges[i].getHierarchyInfo().getProjectedHierarchies();
                        for (IHierarchy aHier : edgeHierInfo) {
                            MDXLevelInfo projectedLevelsOnEdge = edges[i].getLevelInfo(aHier);
                            projectedLevelsOnEdge.removeCalculationLevels();
                            aggregationLevel.replaceProjectedHierarchies(projectedLevelsOnEdge);
                        }
                        if (!((AbstractMDXNode)currentEdge).isProjectedDescendant(aRef)) continue;
                        for (IXQEQueryNode aCalc : intersectingCalcs = edges[i].getDescendantsOfType(1013, false)) {
                            MDXCalculatedMemberReference calc = (MDXCalculatedMemberReference)aCalc;
                            if (!edges[i].isProjectedDescendant(calc)) continue;
                            MDXCalculatedMemberDefinition caclDef = calc.getDefinition();
                            MDXLevelInfo intersectingCalcLevelInfo = ((AbstractMDXNode)caclDef.getChild(0)).getLevelInfo();
                            intersectingCalcLevelInfo.removeCalculationLevels();
                            aggregationLevel.unionProjectedHierarchies(intersectingCalcLevelInfo);
                        }
                    }
                    if (dimLine == null) continue;
                    Iterator<IXQEQueryNode> iter = ((MDXTuple)dimLine.getChild(0)).getChildrenIterator();
                    while (iter.hasNext()) {
                        AbstractMDXMember aMember = (AbstractMDXMember)iter.next();
                        if (aggregationLevel.getHierarchyInfo().projectsHierarchy(aMember.getHierarchy())) continue;
                        aggregationLevel.unionProjectedHierarchies(aMember.getLevelInfo());
                    }
                }
                if (aggregationLevel == null) {
                    aggregationLevel = aggregationLevelWithInCM;
                } else {
                    aggregationLevel.replaceProjectedHierarchies(aggregationLevelWithInCM);
                }
            } else {
                aggregationLevel = ((AbstractMDXNode)aValueExpression).getValueContextLevelInfo();
            }
            aggregationLevel.removeCalculationLevels();
            this.updateAggregationLevelInfo(aValueExpression, aggregationLevel);
            mdxQuery.addReportSummaryAggregationLevelInfo(aValueExpression, aggregationLevel);
        }
        MDXLevelInfo projectedLevels = mdxQuery.getLevelInfo();
        projectedLevels.removeCalculationLevels();
        mdxQuery.addReportSummaryAggregationLevelInfo(mdxQuery, projectedLevels);
    }

    private void updateAggregationLevelInfo(IXQEQueryNode aTuple, MDXLevelInfo aggregationLevel) {
        IXQEQueryNode[] calcs = aTuple.getChildrenOfType(1013);
        Arrays.sort(calcs, new Comparator<IXQEQueryNode>(){

            @Override
            public int compare(IXQEQueryNode o1, IXQEQueryNode o2) {
                return ((MDXCalculatedMemberReference)o2).getSolveOrder() - ((MDXCalculatedMemberReference)o1).getSolveOrder();
            }
        });
        for (IXQEQueryNode aCalc : calcs) {
            IXQEQueryNode calcDefinition = ((MDXCalculatedMemberReference)aCalc).getDefinition().getChild(0);
            if (calcDefinition.getType() == 1060) {
                calcDefinition = calcDefinition.getChild(0);
            }
            MDXLevelInfo calcLevelInfo = ((AbstractMDXNode)calcDefinition).getLevelInfo();
            aggregationLevel.replaceProjectedHierarchies(calcLevelInfo);
        }
        Iterator<IXQEQueryNode> itChildren = aTuple.getChildrenIterator();
        while (itChildren.hasNext()) {
            IXQEQueryNode aChild = itChildren.next();
            if (aChild.isOfTypes(new int[]{1013, 1076})) continue;
            MDXLevelInfo childLevelInfo = ((AbstractMDXNode)aChild).getLevelInfo();
            aggregationLevel.replaceProjectedHierarchies(childLevelInfo);
        }
    }

    private void createOptimizationInfo(MDXQuery mdxQuery) {
        IXQEQueryNode[] currentMembers;
        IXQEQueryNode[] membersFunctions;
        MDXLevelInfo lowestReferencedLevels = mdxQuery.getLowestReferencedLevelInfo(null);
        HashMap<ILevel, List<BaseMember>> restrictions = new HashMap<ILevel, List<BaseMember>>();
        for (IHierarchy infoHierarchy : lowestReferencedLevels.getHierarchyInfo().getProjectedHierarchies()) {
            IXQEQueryNode[] lowestProjLevel = lowestReferencedLevels.getLowestProjectedLevelsSkipCalculation(infoHierarchy);
            if (lowestProjLevel == null) continue;
            restrictions.put((ILevel)lowestProjLevel, new ArrayList());
        }
        HashSet<IHierarchy> excludedHierarchies = new HashSet<IHierarchy>();
        for (IXQEQueryNode aMembersFunction : membersFunctions = mdxQuery.getDescendantsOfTypes(new int[]{1040, 1147}, false)) {
            AbstractMDXNode child = (AbstractMDXNode)aMembersFunction.getChild(0);
            excludedHierarchies.addAll(child.getHierarchyInfo().getProjectedHierarchies());
        }
        List<AbstractMDXNode> childrenOrDescendants = mdxQuery.getDescendantsOfCategories(new int[]{1048, 1052}, true, true, true, false, false);
        for (AbstractMDXNode aFunction : childrenOrDescendants) {
            MDXLevelInfo levelInfo;
            ILevel highestProjectedLevel;
            AbstractMDXMember child = (AbstractMDXMember)aFunction.getChild(0);
            if (child.getType() == 1067 && !((BaseMember)child).isRootMember() || (highestProjectedLevel = (levelInfo = child.getLevelInfo()).getHighestProjectedLevel(levelInfo.getHierarchyInfo().getProjectedHierarchy(0))) == null || !highestProjectedLevel.isRootLevel()) continue;
            excludedHierarchies.addAll(child.getHierarchyInfo().getProjectedHierarchies());
        }
        List<IXQEQueryNode> ancestorsFunctions = mdxQuery.getDescendantsOfCategory(1044, false);
        List<IXQEQueryNode> descendantsFunctions = mdxQuery.getDescendantsOfCategory(1052, false);
        for (IXQEQueryNode anAncestorsFunction : ancestorsFunctions) {
            IXQEQueryNode[] hier = ((AbstractMDXNode)anAncestorsFunction).getHierarchyInfo();
            for (IXQEQueryNode aDescendentsFunction : descendantsFunctions) {
                if (!((AbstractMDXNode)aDescendentsFunction).getHierarchyInfo().projectedHierarchiesOverlap((MDXHierInfo)hier)) continue;
                excludedHierarchies.addAll(hier.getProjectedHierarchies());
            }
        }
        int[] relativeTypes = new int[]{1034, 1156, 1047, 1051, 1074, 1049, 1050, 1075, 1035, 1147};
        for (IXQEQueryNode aCurrentMember : currentMembers = mdxQuery.getDescendantsOfType(1076, false)) {
            MDXCurrentMember currentMember = (MDXCurrentMember)aCurrentMember;
            if (!currentMember.getParent().isOfCategories(relativeTypes)) continue;
            excludedHierarchies.add(currentMember.getHierarchy());
        }
        List<IXQEQueryNode> explicitMembers = mdxQuery.getDescendantsOfCategory(1067, false);
        Iterator<IXQEQueryNode> it = explicitMembers.iterator();
        while (it.hasNext()) {
            BaseMember member = (BaseMember)it.next();
            int[] ancestorTypesToSkip = new int[]{1043, 1046};
            IXQEQueryNode ancestorNode = member;
            while ((ancestorNode = ancestorNode.getParent()).isOfTypes(ancestorTypesToSkip)) {
            }
            if (ancestorNode.isOfCategories(relativeTypes)) {
                excludedHierarchies.add(member.getHierarchy());
                continue;
            }
            if (member.getType() != 1129 || DMRSetFunctionToExplicitSetUtil.getDMRNullMemberHierarchyName(((MDXParameterMember)member).getName()) == null) continue;
            it.remove();
        }
        it = explicitMembers.iterator();
        while (it.hasNext()) {
            BaseMember member = (BaseMember)it.next();
            if (!excludedHierarchies.contains(member.getHierarchy())) continue;
            it.remove();
        }
        List<AbstractMDXNode> tupleMembers = mdxQuery.getDescendantsOfCategories(new int[]{1076, 1077}, false, false, false, false, false);
        Iterator<AbstractMDXNode> iterator = tupleMembers.iterator();
        while (iterator.hasNext()) {
            IXQEQueryNode aTupleMember = iterator.next();
            if (aTupleMember.getParent().getType() == 1069 || aTupleMember.getParent().getParent().getType() == 1069) continue;
            iterator.remove();
        }
        DMRQueryOptimizationInfo optimizationInfo = new DMRQueryOptimizationInfo();
        ArrayList<BaseMember> projectedMembers = new ArrayList<BaseMember>();
        MDXDimensionLine slicer = mdxQuery.getDimensionLine();
        for (IXQEQueryNode aMember : explicitMembers) {
            if (((BaseMember)aMember).isMeasure() || ((BaseMember)aMember).isRootMember()) continue;
            IXQEQueryNode targetNode = aMember;
            if (aMember.getParent().getType() == 1048 || aMember.getParent().getType() == 1052 || aMember.getParent().getType() == 1043 || aMember.getParent().getType() == 1044 || aMember.getParent().getType() == 1046) {
                targetNode = aMember.getParent();
            }
            if (!mdxQuery.isProjectedDescendant((AbstractMDXNode)targetNode) && (slicer == null || !((AbstractMDXNode)slicer).isProjectedDescendant((BaseMember)aMember))) continue;
            boolean ignore = false;
            for (IXQEQueryNode iXQEQueryNode : tupleMembers) {
                if (!((AbstractMDXMember)aMember).getHierarchy().equals(((AbstractMDXMember)iXQEQueryNode).getHierarchy()) || aMember.isSameExpression(iXQEQueryNode, false)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            projectedMembers.add((BaseMember)aMember);
        }
        ArrayList<IXQEQueryNode> calcRefs = new ArrayList<IXQEQueryNode>();
        IsProjectedDescendant isProjCalcRef = new IsProjectedDescendant(mdxQuery);
        int[] nodeTypes = new int[]{1013};
        isProjCalcRef.setNodeTypes(nodeTypes);
        mdxQuery.getDescendantsForCondition(calcRefs, isProjCalcRef, false);
        for (IXQEQueryNode calcRef : calcRefs) {
            IXQEQueryNode tuple;
            IXQEQueryNode iXQEQueryNode;
            MDXCalculatedMemberDefinition mDXCalculatedMemberDefinition = ((MDXCalculatedMemberReference)calcRef).getDefinition();
            if (mDXCalculatedMemberDefinition.getNumberChildren() != 1 || (iXQEQueryNode = mDXCalculatedMemberDefinition.getChild(0)).getType() != 1059 || (tuple = iXQEQueryNode.getChild(0)).getType() != 1069 || tuple.getNumberChildren() != 1 || tuple.getChild(0).getType() != 1067 || ((BaseMember)tuple.getChild(0)).isRootMember() || ((BaseMember)tuple.getChild(0)).isMeasure()) continue;
            BaseMember member = (BaseMember)tuple.getChild(0);
            projectedMembers.add(member);
        }
        if (!projectedMembers.isEmpty()) {
            Iterator itProj = projectedMembers.iterator();
            block13: while (itProj.hasNext()) {
                BaseMember member = (BaseMember)itProj.next();
                for (IXQEQueryNode iXQEQueryNode : projectedMembers) {
                    if (iXQEQueryNode == member || !member.isSameExpression(iXQEQueryNode, false)) continue;
                    itProj.remove();
                    continue block13;
                }
            }
            optimizationInfo.setProjectedMembers(projectedMembers);
        }
        it = explicitMembers.iterator();
        block15: while (it.hasNext()) {
            BaseMember member = (BaseMember)it.next();
            if (member.getParent().getType() == 1069) {
                tupleMembers.add(member);
            }
            for (IXQEQueryNode iXQEQueryNode : explicitMembers) {
                if (iXQEQueryNode == member || !member.isSameExpression(iXQEQueryNode, false)) continue;
                it.remove();
                continue block15;
            }
        }
        ArrayList<Set<ILevel>> tupleRestrictionsWithIntersections = new ArrayList<Set<ILevel>>();
        HashSet<BaseMember> visitedMembers = new HashSet<BaseMember>();
        for (IXQEQueryNode iXQEQueryNode : explicitMembers) {
            BaseMember member = (BaseMember)iXQEQueryNode;
            if (member.getLevel().getDimension().isMeasuresDimension() || member.isRootMember() || member.getExternalName() == null || member.getType() == 1129 && ((MDXParameterMember)member).isMasterDetailParameter()) continue;
            if (optimizationInfo.getPushMemberRestrictionsToRelationalSubquery() && !visitedMembers.contains(member)) {
                HashSet<ILevel> levelSet = new HashSet<ILevel>();
                if (member.getParent().getType() == 1069) {
                    for (IXQEQueryNode child : member.getParent().getChildren()) {
                        if (child.getType() != 1067) continue;
                        visitedMembers.add((BaseMember)child);
                        levelSet.add(((BaseMember)child).getLevel());
                    }
                } else {
                    levelSet.add(member.getLevel());
                }
                if (this.levelsIntersectInTuples(tupleRestrictionsWithIntersections, levelSet)) {
                    optimizationInfo.setPushMemberRestrictionsToRelationalSubquery(false);
                } else {
                    tupleRestrictionsWithIntersections.add(levelSet);
                }
            }
            ILevel lowestReferencedLevel = lowestReferencedLevels.getLowestProjectedLevelsSkipCalculation(member.getLevel().getHierarchy());
            ((List)restrictions.get(lowestReferencedLevel)).add(member);
        }
        optimizationInfo.setLevelRestrictions(restrictions);
        List<IXQEQueryNode> list = mdxQuery.getDescendantsOfCategory(1192, false);
        HashSet<ILevel> hashSet = new HashSet<ILevel>();
        for (IXQEQueryNode aCustomSet : list) {
            hashSet.add(((BaseLevel)aCustomSet.getChild(2)).getLevel());
        }
        optimizationInfo.setFilteredLevels(hashSet);
        mdxQuery.setOptimizationInfo(optimizationInfo);
    }

    private boolean levelsIntersectInTuples(List<Set<ILevel>> tupleRestrictions, Set<ILevel> currentTuple) {
        for (Set<ILevel> levelRestrictionsInTuple : tupleRestrictions) {
            for (ILevel level : currentTuple) {
                boolean differentTuples = !currentTuple.equals(levelRestrictionsInTuple);
                if (!differentTuples || currentTuple.size() <= 1 && levelRestrictionsInTuple.size() <= 1 || !levelRestrictionsInTuple.contains(level)) continue;
                return true;
            }
        }
        return false;
    }

    private void registerFormatIds(XMdxLocal mdxLocal, IXQEQueryNode mdx) {
        IXQEQueryNode[] cms;
        HashMap<String, String> mapNameToFormatId = new HashMap<String, String>();
        for (IXQEQueryNode cm : cms = mdx.getDescendantsOfType(1005, false)) {
            MDXCalculatedMemberDefinition cmdef = (MDXCalculatedMemberDefinition)cm;
            String uniqueName = cmdef.getUniqueName();
            String format = (String)cmdef.getPropertyValue("FORMAT_STRING");
            if (format == null) continue;
            FormatId formatId = FormatService.getInstance().registerV5Format(format, null);
            String fId = formatId.toString();
            mapNameToFormatId.put(uniqueName, fId);
        }
        if (!mapNameToFormatId.isEmpty()) {
            mdxLocal.registerFormatIds(mapNameToFormatId);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        if (requestEnv.isGetParametersRequest() && ((MDXQuery)node).isDMR()) {
            this.traceNodeCondition(false, "Do not execute when doing a GetParameter", trace);
            return false;
        }
        int status = node.isValidPlannedQuery();
        if (status != -1) {
            IXQEQueryNode invalidNode;
            this.traceNodeCondition(false, "The MDX query is not valid. Found issues in node " + status, trace);
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            String nodeName = nodeFactory.getNodeTypeName(status);
            if (nodeName == null && (invalidNode = (IXQEQueryNode)nodeFactory.getNodeIndex().getNodeByID(new Integer(status))) != null) {
                nodeName = invalidNode.getNodeTypeName();
            }
            if (nodeName == null) {
                nodeName = String.valueOf(status);
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_V5PlanFailed, nodeName);
        }
        String traceMsg = null;
        boolean ret = false;
        if (((MDXQuery)node).getUseLocalQueryProcessing()) {
            traceMsg = "GenerateXMdxLocalNode applied because local query processing is using local processing.";
            ret = true;
        } else {
            traceMsg = "GenerateXMdxLocalNode was not applied because the target data source is not using local processing.";
            ret = false;
        }
        this.traceQueryCondition(ret, traceMsg, trace);
        return ret;
    }
}

