/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.mdx;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.engine.TransformationLibrary;
import com.cognos.xqe.transformation.dmr.SuppressNullsWithPreAutoAggregationMeasureDetailFilter;
import com.cognos.xqe.transformation.mdx.AttachMdxASTNodesToParent;
import com.cognos.xqe.transformation.mdx.FixXMdxSetSpecifications;
import com.cognos.xqe.transformation.mdx.GenerateDimensionProperties;
import com.cognos.xqe.transformation.mdx.GenerateNamedSetAST;
import com.cognos.xqe.transformation.mdx.GenerateXMdxCalculatedMember;
import com.cognos.xqe.transformation.mdx.GenerateXMdxLocalNode;
import com.cognos.xqe.transformation.mdx.GenerateXMdxLocalRuntree;
import com.cognos.xqe.transformation.mdx.GenerateXMdxSelectNode;
import com.cognos.xqe.transformation.mdx.RemoveSingleFormulaSpecification;
import com.cognos.xqe.transformation.mdx.dmr.ReplaceSetFunctionWithExplicitMemberSet;
import com.cognos.xqe.transformation.mdx.orderofmagnitude.ComputeDMROOM;
import com.cognos.xqeqte.QTEAbstractTransformation;

public final class MDXTransformationLibrary
extends TransformationLibrary {
    public static final int GENERATE_DMR_TEMPORARY_CUBE_NUMBER = 0;
    public static final int GENERATE_RUNTREE_NODES_PASS_NUMBER = 1;
    public static final int ATTACH_RUNTREE_NODES_PASS_NUMBER = 2;
    public static final String GENERATE_DMR_TEMPORARY_CUBE_NAME = "Generating temporary cube to for ROLAP execution";
    public static final String GENERATE_RUNTREE_NODES_PASS_NAME = "Generating MDX runtree nodes for local execution";
    public static final String ATTACH_RUNTREE_NODES_PASS_NAME = "Attaching leftover AST nodes to parent runtree nodes";
    public static final int HIGHEST_PASS_NUMBER = 2;

    public MDXTransformationLibrary(int startingPassNumber) {
        super(startingPassNumber, 2);
        this.assignPassName(0, GENERATE_DMR_TEMPORARY_CUBE_NAME);
        this.assignPassName(1, GENERATE_RUNTREE_NODES_PASS_NAME);
        this.assignPassName(2, ATTACH_RUNTREE_NODES_PASS_NAME);
    }

    @Override
    public QTEAbstractTransformation.ApplicableIterations getApplicableIterations() {
        return QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    protected QTEAbstractTransformation.Mode getTransformationMode() {
        return QTEAbstractTransformation.Mode.TOP_DOWN;
    }

    private void addTransformation(Class clazz) {
        Transformation transformation = null;
        try {
            transformation = (Transformation)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new XQERuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new XQERuntimeException(e);
        }
        this.transformations.add(transformation);
    }

    @Override
    protected void buildTransformationLibrary() {
        this.addTransformation(SuppressNullsWithPreAutoAggregationMeasureDetailFilter.class);
        this.addTransformation(GenerateXMdxLocalNode.class);
        this.addTransformation(GenerateDimensionProperties.class);
        this.addTransformation(GenerateXMdxLocalRuntree.class);
        this.addTransformation(GenerateXMdxCalculatedMember.class);
        this.addTransformation(GenerateNamedSetAST.class);
        this.addTransformation(GenerateXMdxSelectNode.class);
        this.addTransformation(AttachMdxASTNodesToParent.class);
        this.addTransformation(RemoveSingleFormulaSpecification.class);
        this.addTransformation(FixXMdxSetSpecifications.class);
        this.addTransformation(ComputeDMROOM.class);
        this.addTransformation(ReplaceSetFunctionWithExplicitMemberSet.class);
    }
}

