/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.mdx.orderofmagnitude;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXOOMContext;
import com.cognos.xqe.ast.olap.util.MDXOOMInfo;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.Governors;

public class ComputeDMROOM
extends Transformation {
    public ComputeDMROOM() {
        this.mName = "Compute the OOM for DMR MDXQuery.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        MDXOOMContext context = new MDXOOMContext("dmr");
        MDXOOMInfo r = mdxQuery.computeOOM(context);
        mdxQuery.setPropertyValue("orderOfMagnitude", r.getOOM());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Governors g;
        CubeWrapper cube;
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        Object f = mdxQuery.getPropertyValue("orderOfMagnitude");
        if (f != null) {
            this.traceQueryCondition(false, "DMR result OOM is computed.", trace);
            return false;
        }
        if (!mdxQuery.isDMR() && !this.isRelationalCrossTab(mdxQuery)) {
            this.traceQueryCondition(false, "query is not DMR/Relational Crosstab.", trace);
            return false;
        }
        boolean bCheckOK = false;
        MDXFromCube fromCube = (MDXFromCube)node.getFirstChildByType(1007);
        if (fromCube != null && (cube = (CubeWrapper)fromCube.getCube()) != null && (g = cube.getGovernors()) != null) {
            double oomRestriction = g.getMaxOrderOfMagnitudeMDXResult();
            boolean bl = bCheckOK = Double.compare(oomRestriction, 0.0) > 0;
        }
        if (!bCheckOK) {
            this.traceQueryCondition(false, "DMR result has no restriction.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Need to compute DMR result OOM.", trace);
        return true;
    }

    protected boolean isRelationalCrossTab(IXQEQueryNode node) {
        MDXFromCube fromCube = (MDXFromCube)node.getFirstChildByType(1007);
        if (fromCube == null) {
            return false;
        }
        ICube c = fromCube.getCube();
        if (c == null || !(c instanceof CubeWrapper)) {
            return false;
        }
        CubeWrapper cube = (CubeWrapper)c;
        return cube.getTabularResultSetName() != null;
    }
}

