/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.model.AmbiguousConnectionException;
import com.cognos.xqe.data.model.AmbiguousSignonException;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.util.ConnectionUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CollectDatasourceExceptions {
    private static final String ERRORS = "errors";
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private static final String PARAMETERS = "parameters";
    private static final String DATASOURCE_NAME = "dataSourceName";
    private static final String CONNECTIONS = "connections";
    private static final String NAME = "name";
    private static final String DATASOURCE_CONNECTION_NAME = "dataSourceConnectionName";
    private static final String SIGNONS = "signons";
    private static final String SIGNON = "signon";
    private static final String SUBCODE = "subcode";
    public static final String RESPONSE = "getDataSourceExceptionsResponse";
    public static final String RESULT = "getDataSourceExceptionsResult";
    private static final String EXCLUDED_TABLES = "excludedTables";

    public static Element generateResponse(ExecutionEnvironment exeEnv, Element functionSpec) {
        MetadataConnection mdConnection = MoserCommandUtil.getMetadataConnection(exeEnv, functionSpec);
        Set<String> excl = CollectDatasourceExceptions.getExcludeTables(functionSpec);
        JSONObject dsErrors = CollectDatasourceExceptions.collectDataSourceExceptions(exeEnv, mdConnection, excl);
        Element elemResponse = DocumentHelper.createElement((String)RESPONSE);
        Element result = DocumentHelper.createElement((String)RESULT);
        elemResponse.add(result);
        Element itemEle = DocumentHelper.createElement((String)"item");
        result.add(itemEle);
        itemEle.setText(JSONUtil.prettyPrint(dsErrors.toString()));
        return elemResponse;
    }

    protected static Set<String> getExcludeTables(Element functionSpec) {
        String json = MoserCommandUtil.getNamedValue(functionSpec, EXCLUDED_TABLES);
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            JSONArray jsonArray = JSONArray.parse((String)json);
            if (jsonArray != null && !jsonArray.isEmpty()) {
                HashSet<String> rt = new HashSet<String>();
                for (Object o : jsonArray) {
                    rt.add((String)o);
                }
                return rt;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static JSONObject collectDataSourceExceptions(ExecutionEnvironment exeEnv, MetadataConnection mdConnection, Set<String> excl) {
        JSONObject jObj = new JSONObject();
        JSONArray errors = new JSONArray();
        jObj.put((Object)ERRORS, (Object)errors);
        PlanningEnvironment planningEnv = QueryPlanner.setupEnvironment(exeEnv.getRequestEnvironment());
        planningEnv.setMetdataConnection(mdConnection);
        CollectDatasourceExceptions.collectCMDatasourcesFromQuerySubjects(exeEnv, mdConnection, excl);
        for (IDataSource ds : exeEnv.getDataSources()) {
            SQLBinderUtil.expandDataSourceCMDataSourceNameWithMacro(planningEnv, ds);
            IDataSourceConnection dsConn = null;
            try {
                dsConn = ds.getDataSourceConnection();
            }
            catch (AmbiguousConnectionException ace) {
                CollectDatasourceExceptions.addError(errors, ace, ds.getCMDataSourceName(), CONNECTIONS, ace.getConnectionNames());
                continue;
            }
            if (dsConn == null) continue;
            IDataSourceConnectionSignon signon = null;
            try {
                signon = dsConn.getSignon();
            }
            catch (AmbiguousSignonException ase) {
                JSONObject parameter = CollectDatasourceExceptions.addError(errors, ase, ds.getCMDataSourceName(), SIGNONS, ase.getSignonNames());
                if (dsConn == null) continue;
                parameter.put((Object)DATASOURCE_CONNECTION_NAME, (Object)dsConn.getName());
                continue;
            }
            try {
                ConnectionUtil.connect(exeEnv, ds);
            }
            catch (LogonFailureException lfe) {
                JSONObject error = CollectDatasourceExceptions.addError(errors, lfe, ds.getCMDataSourceName(), null, null);
                error.put((Object)DATASOURCE_CONNECTION_NAME, (Object)dsConn.getName());
                if (signon == null) continue;
                error.put((Object)SIGNON, (Object)signon.getName());
            }
        }
        return jObj;
    }

    public static void collectCMDatasourcesFromQuerySubjects(ExecutionEnvironment exeEnv, MetadataConnection mdConnection, Set<String> excl) {
        for (IMetadata md : mdConnection.getEntities()) {
            List<IModelDataSource> modelDSs;
            if (!(md instanceof IQuerySubject)) continue;
            IQuerySubject qs = (IQuerySubject)md;
            if (excl != null && excl.contains(qs.getID()) || (modelDSs = qs.getDataSources()) == null || modelDSs.isEmpty()) continue;
            for (IModelDataSource modelDS : modelDSs) {
                exeEnv.getOrAddDataSource(modelDS);
            }
        }
    }

    public static JSONObject addError(JSONArray errors, DataSourceException dse, String dsName, String listName, List<String> names) {
        JSONObject error = new JSONObject();
        errors.add((Object)error);
        error.put((Object)CODE, (Object)dse.getFaultCode());
        if (dse instanceof LogonFailureException) {
            error.put((Object)SUBCODE, (Object)((LogonFailureException)dse).getSubCode().getFaultSubCode());
        }
        error.put((Object)MESSAGE, (Object)dse.getLocalizedMessage());
        JSONArray parameters = new JSONArray();
        error.put((Object)PARAMETERS, (Object)parameters);
        JSONObject parameter = new JSONObject();
        parameters.add((Object)parameter);
        parameter.put((Object)DATASOURCE_NAME, (Object)dsName);
        if (listName != null) {
            JSONArray list = new JSONArray();
            parameter.put((Object)listName, (Object)list);
            for (String name : names) {
                JSONObject listElem = new JSONObject();
                list.add((Object)listElem);
                listElem.put((Object)NAME, (Object)name);
            }
        }
        return parameter;
    }
}

