/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ExpandMacros {
    public static final String RESPONSE = "expandMacroResponse";
    public static final String RESULT = "expandMacroResult";

    public static Element generateResponse(ExecutionEnvironment execEnv, Element functionSpec) {
        List<String> exprsToExpand = MoserCommandUtil.getExpressionsToExpand(functionSpec);
        ExpandMacros expander = new ExpandMacros();
        List<String> expandedExprs = expander.expandExpressions(QueryPlanner.setupEnvironment(execEnv.getRequestEnvironment()), exprsToExpand);
        Element elemResponse = DocumentHelper.createElement((String)RESPONSE);
        Element result = DocumentHelper.createElement((String)RESULT);
        elemResponse.add(result);
        Element itemEle = DocumentHelper.createElement((String)"item");
        result.add(itemEle);
        JSONObject mdResponse = ExpandMacros.generateJSONResponse(exprsToExpand, expandedExprs);
        if (MoserCommandUtil.getPrettyPrint(functionSpec)) {
            itemEle.setText(JSONUtil.prettyPrint(mdResponse.toString()));
        } else {
            itemEle.setText(mdResponse.toString());
        }
        return elemResponse;
    }

    private static JSONObject generateJSONResponse(List<String> source, List<String> target) {
        JSONObject response = new JSONObject();
        JSONArray expandedMacros = new JSONArray();
        for (int i = 0; i < source.size(); ++i) {
            JSONObject jObj = new JSONObject();
            jObj.put((Object)"source", (Object)source.get(i));
            jObj.put((Object)"target", (Object)target.get(i));
            expandedMacros.add((Object)jObj);
        }
        response.put((Object)"expandedMacros", (Object)expandedMacros);
        return response;
    }

    private List<String> expandExpressions(PlanningEnvironment planEnv, List<String> exprsToExpand) {
        ArrayList<String> expandedExprs = new ArrayList<String>();
        if (exprsToExpand == null) {
            return expandedExprs;
        }
        for (String exprToExpand : exprsToExpand) {
            MacroExpander expander = new MacroExpander();
            expandedExprs.add(expander.expand(null, planEnv, exprToExpand));
        }
        return expandedExprs;
    }
}

