/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.macro.MacroException;
import com.cognos.xqe.ast.macro.uniqueName.ItemReference;
import com.cognos.xqe.ast.macro.uniqueName.ItemScanner;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.transformation.moser.ExtractIdentifiersVisitor;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ExtractIdentifiers {
    private static final String FEEDBACK = "feedback";
    private static final String IDENTIFIERS = "identifiers";
    private static final String NEW_ID = "newIdentifier";

    public static Element generateResponse(ExecutionEnvironment execEnv, Element functionSpec) {
        List<String> exprs = MoserCommandUtil.getExpressionsToExpand(functionSpec);
        String[] srcIds = new String[]{null, null, null};
        int n = 0;
        if (exprs != null) {
            n = exprs.size();
        }
        JSONArray targets = ExtractIdentifiers.getFeedBackSpec(functionSpec, srcIds, n);
        ItemScanner scanner = new ItemScanner();
        ArrayList<TreeSet<String>> result = new ArrayList<TreeSet<String>>();
        TreeMap<String, String> changed = null;
        if (exprs != null) {
            for (int i = 0; i < exprs.size(); ++i) {
                String exp = exprs.get(i);
                try {
                    ExtractIdentifiersVisitor visitor = new ExtractIdentifiersVisitor(scanner);
                    if (targets != null) {
                        visitor.oldIdforExpr = srcIds[0];
                        visitor.srcType = srcIds[1];
                        visitor.newId = srcIds[2];
                        visitor.target = (JSONObject)targets.get(i);
                        visitor.sb = new StringBuilder();
                    }
                    List<ItemReference> items = scanner.extract(exp, visitor);
                    TreeSet<String> ids = new TreeSet<String>();
                    for (ItemReference item : items) {
                        if (item.isSuspect()) continue;
                        String s = ExtractIdentifiersVisitor.trimSuffix(item);
                        ids.add(s);
                    }
                    result.add(ids);
                    if (!visitor.bChanged) continue;
                    if (changed == null) {
                        changed = new TreeMap<String, String>();
                    }
                    changed.put((String)visitor.target.get((Object)"idForExpression"), visitor.sb.toString());
                    continue;
                }
                catch (MacroException e) {
                    result.add(new TreeSet());
                }
            }
        }
        JSONArray jsFeedBack = ExtractIdentifiers.generateFeedback(changed);
        Element elemResponse = DocumentHelper.createElement((String)"moserCommandResponse");
        Element elemResult = DocumentHelper.createElement((String)"moserCommandResult");
        elemResponse.add(elemResult);
        Element itemEle = DocumentHelper.createElement((String)"item");
        elemResult.add(itemEle);
        JSONObject jsResponse = new JSONObject();
        JSONArray jsIdentifiers = ExtractIdentifiers.generateJSONIdentifiers(result);
        jsResponse.put((Object)IDENTIFIERS, (Object)jsIdentifiers);
        if (jsFeedBack != null) {
            jsResponse.put((Object)FEEDBACK, (Object)jsFeedBack);
        }
        if (MoserCommandUtil.getPrettyPrint(functionSpec)) {
            itemEle.setText(JSONUtil.prettyPrint(jsResponse.toString()));
        } else {
            itemEle.setText(jsResponse.toString());
        }
        return elemResponse;
    }

    protected static JSONArray generateJSONIdentifiers(List<TreeSet<String>> result) {
        JSONArray jsonResponse = new JSONArray();
        for (TreeSet<String> st : result) {
            JSONArray json = new JSONArray();
            for (String id : st) {
                json.add((Object)id);
            }
            jsonResponse.add((Object)json);
        }
        return jsonResponse;
    }

    protected static JSONArray getFeedBackSpec(Element functionSpec, String[] rt, int n) {
        if (n == 0) {
            return null;
        }
        String sFeedback = MoserCommandUtil.getNamedValue(functionSpec, FEEDBACK);
        if (sFeedback == null || sFeedback.isEmpty()) {
            return null;
        }
        sFeedback = sFeedback.replaceAll(Pattern.quote("\\\""), "\"");
        JSONObject jFeedback = null;
        try {
            jFeedback = JSONObject.parse((String)sFeedback);
        }
        catch (IOException e) {
            return null;
        }
        String oldIdforExpr = (String)jFeedback.get((Object)"idForExpression");
        String srcType = (String)jFeedback.get((Object)"type");
        String newId = (String)jFeedback.get((Object)NEW_ID);
        JSONArray targets = (JSONArray)jFeedback.get((Object)"expressions");
        if (oldIdforExpr == null || oldIdforExpr.isEmpty() || srcType == null || srcType.isEmpty() || newId == null || newId.isEmpty() || targets == null || targets.size() != n) {
            return null;
        }
        rt[0] = oldIdforExpr;
        rt[1] = srcType;
        rt[2] = newId;
        return targets;
    }

    protected static JSONArray generateFeedback(TreeMap<String, String> rt) {
        if (rt == null || rt.isEmpty()) {
            return null;
        }
        JSONArray jsonResponse = new JSONArray();
        for (String idForExp : rt.keySet()) {
            JSONObject json = new JSONObject();
            json.put((Object)"idForExpression", (Object)idForExp);
            json.put((Object)"expression", (Object)rt.get(idForExp));
            jsonResponse.add((Object)json);
        }
        return jsonResponse;
    }
}

