/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.macro.MXIdentifierVisitor;
import com.cognos.xqe.ast.macro.parser.MACBlock;
import com.cognos.xqe.ast.macro.parser.MACCopyAsIsChunk;
import com.cognos.xqe.ast.macro.parser.MACCopyAsIsPieces;
import com.cognos.xqe.ast.macro.parser.MACNameParts;
import com.cognos.xqe.ast.macro.parser.SimpleNode;
import com.cognos.xqe.ast.macro.uniqueName.ItemReference;
import com.cognos.xqe.ast.macro.uniqueName.ItemScanner;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.json.java.JSONObject;

public class ExtractIdentifiersVisitor
extends MXIdentifierVisitor {
    private static final String FLAG_ITEM = "(valid)";
    private static final String BAD = "(bad)";
    protected static final String ID_FOR_EXPR = "idForExpression";
    protected StringBuilder sb;
    protected boolean bChanged = false;
    protected String oldIdforExpr;
    protected String srcType;
    protected String newId;
    protected JSONObject target;
    protected boolean bSkipId;

    public ExtractIdentifiersVisitor(ItemScanner theScanner) {
        super(theScanner);
    }

    public static String trimSuffix(ItemReference item) {
        return ExtractIdentifiersVisitor.trimTail(item, FLAG_ITEM);
    }

    protected static String trimTail(ItemReference item, String tail) {
        String s = item.toString();
        if (s.endsWith(tail)) {
            s = s.substring(0, s.length() - tail.length());
        }
        return s;
    }

    @Override
    protected void concatResult(SimpleNode node) {
        if (this.sb != null) {
            this.sb.append(node.getTokenText());
        }
    }

    protected void concatString(String s) {
        if (this.sb != null) {
            this.sb.append(s);
        }
    }

    @Override
    public Object visit(MACNameParts node, Object data) {
        Object r = super.visit(node, data);
        ItemReference item = (ItemReference)this.items.get(this.items.size() - 1);
        if (!item.isSuspect()) {
            String tId = ExtractIdentifiersVisitor.trimSuffix(item);
            String newPart = this.matchOp(tId);
            if (newPart != null) {
                this.concatString(newPart);
                this.bChanged = true;
            } else {
                this.concatString(tId);
            }
        } else {
            this.concatString(ExtractIdentifiersVisitor.trimTail(item, BAD));
        }
        return r;
    }

    @Override
    public Object visit(MACCopyAsIsPieces node, Object data) {
        this.previousNode = node;
        if (!this.bSkipId) {
            node.childrenAccept(this, null);
        } else {
            this.concatString(node.getValue());
        }
        return null;
    }

    @Override
    public Object visit(MACCopyAsIsChunk node, Object data) {
        String v = node.getValue();
        if (v != null && !v.isEmpty()) {
            String[] parts = v.split("\\.");
            boolean b = true;
            for (String s : parts) {
                if (IdentifierUtil.isIdValid((String)s)) continue;
                b = false;
                break;
            }
            if (b) {
                ItemReference item = new ItemReference();
                item.addPart(v);
                this.items.add(item);
                String tId = ExtractIdentifiersVisitor.trimSuffix(item);
                String newPart = this.matchOp(tId);
                if (newPart != null) {
                    this.concatString(newPart);
                    this.bChanged = true;
                } else {
                    this.concatString(tId);
                }
            } else {
                this.concatResult(node);
            }
        } else {
            this.concatResult(node);
        }
        return null;
    }

    @Override
    public Object visit(MACBlock node, Object data) {
        Object r = super.visit(node, data);
        if (this.sb != null) {
            ItemScanner subScanner = new ItemScanner();
            ExtractIdentifiersVisitor subVisitor = new ExtractIdentifiersVisitor(subScanner);
            subVisitor.sb = new StringBuilder();
            subVisitor.bSkipId = true;
            node.childrenAccept(subVisitor, null);
            this.concatString(subVisitor.sb.toString());
        }
        return r;
    }

    protected String matchOp(String targetId) {
        if (this.sb == null || this.oldIdforExpr == null || this.srcType == null || this.newId == null || this.target == null) {
            return null;
        }
        boolean bV5Id = targetId.startsWith("[");
        String[] targetParts = null;
        targetParts = bV5Id ? UniqueNameParser.parseNoThrow(targetId) : targetId.split("\\.");
        if (targetParts == null) {
            return null;
        }
        String[] srcParts = this.oldIdforExpr.split("\\.");
        if ("calculation".equalsIgnoreCase(this.srcType) || "filter".equalsIgnoreCase(this.srcType)) {
            return this.matchGlobalCalcFilter(srcParts, targetParts, bV5Id);
        }
        if ("querySubject".equalsIgnoreCase(this.srcType)) {
            return this.matchQuerySubject(srcParts, targetParts, bV5Id);
        }
        if ("queryItem".equalsIgnoreCase(this.srcType)) {
            return this.matchQueryItem(srcParts, targetParts, bV5Id);
        }
        return null;
    }

    protected String matchGlobalCalcFilter(String[] srcParts, String[] targetParts, boolean bV5Id) {
        String targetType = (String)this.target.get((Object)"type");
        if (!"calculation".equalsIgnoreCase(targetType) && !"filter".equalsIgnoreCase(targetType)) {
            return null;
        }
        if (srcParts.length != 1 || targetParts.length != 1) {
            return null;
        }
        if (srcParts[0].equals(targetParts[0])) {
            if (bV5Id) {
                return UniqueNameGenerator.createSingleNamePart(this.newId);
            }
            return this.newId;
        }
        return null;
    }

    protected String matchQuerySubject(String[] srcParts, String[] targetParts, boolean bV5Id) {
        if (srcParts.length != 1) {
            return null;
        }
        String targetType = (String)this.target.get((Object)"type");
        if ("calculation".equalsIgnoreCase(targetType) || "filter".equalsIgnoreCase(targetType) || "queryItem".equalsIgnoreCase(targetType)) {
            if (targetParts.length == 1) {
                String s = srcParts[0] + ".";
                if (!targetParts[0].startsWith(s)) {
                    return null;
                }
                String r = this.newId + "." + targetParts[0].substring(s.length());
                if (bV5Id) {
                    return UniqueNameGenerator.createSingleNamePart(r);
                }
                return r;
            }
            if (!srcParts[0].equals(targetParts[0])) {
                return null;
            }
            targetParts[0] = this.newId;
            if (bV5Id) {
                return this.createUniqueNameFromParts(targetParts);
            }
            return ExtractIdentifiersVisitor.createIdForExpr(targetParts);
        }
        return null;
    }

    protected String matchQueryItem(String[] srcParts, String[] targetParts, boolean bV5Id) {
        if (srcParts.length < 2) {
            return null;
        }
        String targetType = (String)this.target.get((Object)"type");
        if ("calculation".equalsIgnoreCase(targetType) || "filter".equalsIgnoreCase(targetType)) {
            return this.matchQueryItemByIdForExpr(srcParts, targetParts, bV5Id);
        }
        if ("queryItem".equalsIgnoreCase(targetType)) {
            String[] p;
            String targetIdForExpr = (String)this.target.get((Object)ID_FOR_EXPR);
            String[] targetQIParts = targetIdForExpr.split("\\.");
            if (!srcParts[0].equals(targetQIParts[0])) {
                return this.matchQueryItemByIdForExpr(srcParts, targetParts, bV5Id);
            }
            if (srcParts.length == 2 && targetParts.length == 1 && (p = targetParts[0].split("\\.")).length == 1 && p[0].equals(srcParts[1])) {
                if (bV5Id) {
                    return UniqueNameGenerator.createSingleNamePart(this.newId);
                }
                return this.newId;
            }
            return this.matchQueryItemByIdForExpr(srcParts, targetParts, bV5Id);
        }
        return null;
    }

    protected String matchQueryItemByIdForExpr(String[] srcParts, String[] targetParts, boolean bV5Id) {
        if (targetParts.length == 1) {
            if (targetParts[0].equals(this.oldIdforExpr)) {
                srcParts[srcParts.length - 1] = this.newId;
                String r = ExtractIdentifiersVisitor.createIdForExpr(srcParts);
                if (bV5Id) {
                    return UniqueNameGenerator.createSingleNamePart(r);
                }
                return r;
            }
            String s = this.oldIdforExpr + ".";
            if (targetParts[0].startsWith(s)) {
                srcParts[srcParts.length - 1] = this.newId;
                String newIdForExpr = ExtractIdentifiersVisitor.createIdForExpr(srcParts);
                String r = newIdForExpr + "." + targetParts[0].substring(s.length());
                if (bV5Id) {
                    return UniqueNameGenerator.createSingleNamePart(r);
                }
                return r;
            }
            return null;
        }
        if (!this.partsEquals(srcParts, targetParts)) {
            return null;
        }
        targetParts[srcParts.length - 1] = this.newId;
        if (bV5Id) {
            return this.createUniqueNameFromParts(targetParts);
        }
        return ExtractIdentifiersVisitor.createIdForExpr(targetParts);
    }

    protected String createUniqueNameFromParts(String[] parts) {
        String rt = UniqueNameGenerator.createSingleNamePart(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            rt = UniqueNameGenerator.appendUniqueName(rt, parts[i]);
        }
        return rt;
    }

    protected boolean partsEquals(String[] srcParts, String[] parts) {
        if (srcParts.length > parts.length) {
            return false;
        }
        for (int i = 0; i < srcParts.length; ++i) {
            if (srcParts[i].equals(parts[i])) continue;
            return false;
        }
        return true;
    }

    protected static String createIdForExpr(String[] parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }
}

