/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.transformation.moser.GenerateModuleMetadataForPackage;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GenerateNormalizedIdentifiers {
    private static final String IDENTIFIERS = "identifiers";
    public static final String RESPONSE = "normalizedIDsResponse";
    private static final String RESULT = "normalizedIDsResult";
    private static final String OPEN_SQUARE_BRACKET = "[";

    public static Element generateResponse(ExecutionEnvironment environment, Element functionSpec) {
        MetadataConnection mdConnection = MoserCommandUtil.getMetadataConnection(environment, functionSpec);
        List<String> identifiers = GenerateNormalizedIdentifiers.getIdentifierList(functionSpec);
        GenerateNormalizedIdentifiers normalizer = new GenerateNormalizedIdentifiers();
        List<String> normalizedID = normalizer.getNormalizedIdentifiers(mdConnection, identifiers);
        Element elemResponse = DocumentHelper.createElement((String)RESPONSE);
        Element result = DocumentHelper.createElement((String)RESULT);
        elemResponse.add(result);
        Element itemEle = DocumentHelper.createElement((String)"item");
        result.add(itemEle);
        JSONArray mdResponse = GenerateNormalizedIdentifiers.generateJSONResponse(identifiers, normalizedID);
        if (MoserCommandUtil.getPrettyPrint(functionSpec)) {
            itemEle.setText(JSONUtil.prettyPrint(mdResponse.toString()));
        } else {
            itemEle.setText(mdResponse.toString());
        }
        return elemResponse;
    }

    private static JSONArray generateJSONResponse(List<String> identifiers, List<String> normalizedIdentifiers) {
        JSONArray jsonResponse = new JSONArray();
        for (int i = 0; i < identifiers.size(); ++i) {
            JSONObject jObj = new JSONObject();
            jObj.put((Object)"source", (Object)identifiers.get(i));
            jObj.put((Object)"target", (Object)normalizedIdentifiers.get(i));
            jsonResponse.add((Object)jObj);
        }
        return jsonResponse;
    }

    private List<String> getNormalizedIdentifiers(MetadataConnection mdConnection, List<String> identifiers) {
        ArrayList<String> normalizedIDs = new ArrayList<String>();
        if (identifiers == null) {
            return normalizedIDs;
        }
        for (String id : identifiers) {
            try {
                String normalizedID = null;
                IMetadata md = mdConnection.bindMetadataReference(id);
                if (md != null && this.isMetadataFromPackage(md)) {
                    normalizedID = this.getIdentifier(this.extractAlias(id), md);
                }
                if (normalizedID == null) {
                    normalizedID = id;
                }
                normalizedIDs.add(normalizedID);
            }
            catch (MetadataBindingException e) {
                normalizedIDs.add(id);
            }
        }
        return normalizedIDs;
    }

    private boolean isMetadataFromPackage(IMetadata md) {
        MetadataConnection mdConn = md.getConnection();
        return mdConn == null || !(mdConn instanceof MoserMetadataConnection);
    }

    private String extractAlias(String id) {
        int idxSQ = id.indexOf(OPEN_SQUARE_BRACKET);
        String alias = null;
        if (idxSQ > 0) {
            alias = id.substring(0, idxSQ - 1);
        }
        return alias;
    }

    String getIdentifier(String alias, IMetadata obj) {
        IAccessedViaShortcut qs;
        IQueryItem qi;
        IMetadata parentQS;
        String id = null;
        if (obj instanceof IQueryItem && (parentQS = (qi = (IQueryItem)obj).getParentObjectSkipFolders()) instanceof IAccessedViaShortcut && (qs = (IAccessedViaShortcut)parentQS).isAccessedViaShortcut()) {
            IShortcut sc = qs.getShortcut();
            id = sc.getID() + "." + GenerateModuleMetadataForPackage.getLastNamePart(obj);
        }
        if (id == null) {
            id = obj.getID();
        }
        if (alias != null) {
            id = alias + "." + id;
        }
        return id;
    }

    private static List<String> getIdentifierList(Element functionSpec) {
        String json = MoserCommandUtil.getNamedValue(functionSpec, IDENTIFIERS);
        try {
            JSONArray jsonArray = JSONArray.parse((String)json);
            if (jsonArray != null && !jsonArray.isEmpty()) {
                ArrayList<String> retArray = new ArrayList<String>();
                for (Object o : jsonArray) {
                    retArray.add((String)o);
                }
                return retArray;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

