/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItem;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.Pair;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.QsClassifierType;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class GenerateTypedInSQLQuerySubject {
    private static final String DEFAULT_SQL_QUERY_NAME = "SQL1";

    public static void convertMoserFunctionToDataSourceQuery(Document doc, RequestEnvironment reqEnv) {
        String module = null;
        String name = "Typed_In_SQL";
        String datasourceRef = "";
        String sqlType = null;
        String sqlText = null;
        Element root = doc.getRootElement();
        Element functionSpec = root.element("moserFunction");
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            Pair keyValue = MoserCommandUtil.getNameAndValueMap(child);
            if (keyValue == null) continue;
            if ("module".equals(keyValue.getFirst())) {
                module = (String)keyValue.getSecond();
                continue;
            }
            if ("datasourceRef".equals(keyValue.getFirst())) {
                datasourceRef = (String)keyValue.getSecond();
                continue;
            }
            if ("sqlType".equals(keyValue.getFirst())) {
                sqlType = (String)keyValue.getSecond();
                continue;
            }
            if ("sqlText".equals(keyValue.getFirst())) {
                sqlText = (String)keyValue.getSecond();
                continue;
            }
            if (!"name".equals(keyValue.getFirst())) continue;
            name = (String)keyValue.getSecond();
        }
        if (module == null || sqlType == null || sqlText == null) {
            int numParam = 0;
            if (module != null) {
                ++numParam;
            }
            if (sqlType != null) {
                ++numParam;
            }
            if (sqlText != null) {
                ++numParam;
            }
            throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidMoserCommandSpec, (Object)"describeDataSourceQuery", (Object)"3", (Object)numParam);
        }
        Element eModelPath = DocumentHelper.createElement((String)"modelPath");
        eModelPath.addAttribute("type", "module");
        eModelPath.setText(module);
        root.add(eModelPath);
        reqEnv.setModelPath(module);
        reqEnv.setModelType("module");
        Element eSQLQuery = DocumentHelper.createElement((String)"sqlQuery");
        eSQLQuery.addAttribute("dataSource", datasourceRef);
        eSQLQuery.addAttribute("name", name);
        eSQLQuery.addAttribute("type", sqlType);
        root.add(eSQLQuery);
        Element eSQLText = DocumentHelper.createElement((String)"sqlText");
        eSQLText.setText(sqlText);
        eSQLQuery.add(eSQLText);
    }

    public static Element generateResponse(IXQEQueryNode planTree, Element functionSpec) {
        Element elemResponse = DocumentHelper.createElement((String)"moserCommandResponse");
        Element elemResult = DocumentHelper.createElement((String)"moserCommandResult");
        elemResponse.add(elemResult);
        Element elemItemEle = DocumentHelper.createElement((String)"item");
        elemResult.add(elemItemEle);
        elemItemEle.setText(GenerateTypedInSQLQuerySubject.generateQuerySubjectFromTypedInSQL(planTree, functionSpec));
        return elemResponse;
    }

    private static String generateQuerySubjectFromTypedInSQL(IXQEQueryNode planTree, Element functionSpec) {
        SQLQueryItemList queryItems;
        JSONObject jQS = new JSONObject();
        JSONObject jSQLQuery = new JSONObject();
        jQS.put((Object)"sqlQuery", (Object)jSQLQuery);
        String datasourceRef = null;
        String sqlType = null;
        String sqlText = null;
        String qsname = null;
        String qsId = null;
        String sqlQueryID = DEFAULT_SQL_QUERY_NAME;
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            Pair keyValue = MoserCommandUtil.getNameAndValueMap(child);
            if (keyValue == null) continue;
            if ("datasourceRef".equals(keyValue.getFirst())) {
                datasourceRef = (String)keyValue.getSecond();
                continue;
            }
            if ("sqlType".equals(keyValue.getFirst())) {
                sqlType = (String)keyValue.getSecond();
                continue;
            }
            if ("sqlText".equals(keyValue.getFirst())) {
                sqlText = (String)keyValue.getSecond();
                continue;
            }
            if ("name".equals(keyValue.getFirst())) {
                qsname = (String)keyValue.getSecond();
                continue;
            }
            if (!"identifier".equals(keyValue.getFirst())) continue;
            qsId = (String)keyValue.getSecond();
        }
        if (qsId != null) {
            jQS.put((Object)"identifier", qsId);
        }
        if (qsname != null) {
            Object mc;
            IPlanningEnvironment env;
            if (qsId == null && planTree instanceof XQEBaseQueryNode && (env = ((XQEBaseQueryNode)planTree).getPlanningEnvironment()) != null && (mc = env.getMetadataConnection()) instanceof MoserMetadataConnection) {
                qsId = ((MoserMetadataConnection)mc).generateTopLevelObjectID(qsname);
                jQS.put((Object)"identifier", (Object)qsId);
            }
            jQS.put((Object)"label", qsname);
        }
        jQS.put((Object)"classifier", (Object)QsClassifierType.SQL_QUERY_SUBJECT.value());
        jSQLQuery.put((Object)"identifier", (Object)sqlQueryID);
        jSQLQuery.put((Object)"label", (Object)sqlQueryID);
        if (datasourceRef != null) {
            JSONArray jDS = new JSONArray();
            jDS.add((Object)datasourceRef);
            jSQLQuery.put((Object)"datasourceRef", (Object)jDS);
        }
        if (sqlText != null) {
            jSQLQuery.put((Object)"sqlText", sqlText);
        }
        if (sqlType != null) {
            jSQLQuery.put((Object)"sqlType", (Object)sqlType);
        }
        if ((queryItems = ((V5SqlQuery)planTree).getQueryItemList()) != null && !queryItems.isEmpty()) {
            JSONArray jItems = new JSONArray();
            jQS.put((Object)"item", (Object)jItems);
            JSONArray jProjItems = new JSONArray();
            jSQLQuery.put((Object)"projectedItem", (Object)jProjItems);
            CaseInsensitiveMap existing = new CaseInsensitiveMap();
            for (SQLQueryItem queryItem : queryItems) {
                JSONObject jItem = new JSONObject();
                jItems.add((Object)jItem);
                JSONObject jQueryItem = new JSONObject();
                jItem.put((Object)"queryItem", (Object)jQueryItem);
                JSONObject jProjItem = new JSONObject();
                jProjItems.add((Object)jProjItem);
                String name = queryItem.getName();
                if (name == null) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_AliasNotFound);
                }
                String id = IdentifierUtil.makeUniqueAndValidIdentifier((String)name, (CaseInsensitiveMap)existing);
                existing.put((Object)id, (Object)Boolean.TRUE);
                jQueryItem.put((Object)"identifier", (Object)id);
                jProjItem.put((Object)"identifier", (Object)id);
                jQueryItem.put((Object)"label", (Object)name);
                jProjItem.put((Object)"label", (Object)name);
                IDataType dt = queryItem.getDataType();
                String dtStr = MoserModuleUtil.convertToJMDDataType(dt);
                jQueryItem.put((Object)"datatype", (Object)dtStr);
                jProjItem.put((Object)"datatype", (Object)dtStr);
                boolean bNullable = queryItem.isNullable();
                jQueryItem.put((Object)"nullable", (Object)bNullable);
                jProjItem.put((Object)"nullable", (Object)bNullable);
                HighLevelDataType highDT = MoserCommonUtils.generateHighlevelDatatype((String)dtStr);
                UsageType usage = MoserCommonUtils.getUsageFromHighLevelDataType((HighLevelDataType)highDT);
                jQueryItem.put((Object)"usage", (Object)usage.value());
                jProjItem.put((Object)"usage", (Object)usage.value());
                RegularAggregateType aggrType = MoserCommonUtils.getRegularAggregateTypeFromUsageAndHighLevelDataType((UsageType)usage, (HighLevelDataType)highDT);
                jQueryItem.put((Object)"regularAggregate", (Object)aggrType.value());
                jProjItem.put((Object)"regularAggregate", (Object)aggrType.value());
                jQueryItem.put((Object)"highlevelDatatype", (Object)highDT.value());
                jProjItem.put((Object)"highlevelDatatype", (Object)highDT.value());
                if (qsId != null) {
                    jQueryItem.put((Object)"idForExpression", (Object)(qsId + "." + id));
                }
                jProjItem.put((Object)"idForExpression", (Object)(sqlQueryID + "." + id));
                jProjItem.put((Object)"externalName", (Object)name);
                jQueryItem.put((Object)"expression", (Object)id);
                JSONObject jFacet = new JSONObject();
                jFacet.put((Object)"enabled", (Object)"automatic");
                jQueryItem.put((Object)"facetDefinition", (Object)jFacet);
            }
        }
        return jQS.toString();
    }
}

