/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.ibm.json.java.JSONObject;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public final class GenerateV5QueryForTableStatistics {
    private static final String MODULE = "module";
    private static final String IDENTIFIER = "identifier";
    private static final String ROWS = "rows";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String QUERY_NAME = "QueryMoserTableStatistics";
    private static final String QRD_NAME = "QueryMoserTableStatisticsQRD";
    private static final String EDGE_NAME = "QueryMoserTableStatisticsEdge";
    private static final String VALUESET_NAME = "QueryMoserTableStatisticsSet";
    private static final String GROUPBODY_NAME = "QueryMoserTableStatisticsGroupBody";
    public static final String RESPONSE = "getTableValuesResponse";

    public static V5QuerySet generateV5QuerySet(PlanningEnvironment environment, Element functionSpec) {
        List<IModelDataSource> dataSources;
        XQENodeFactory factory = environment.getNodeFactory();
        V5QuerySet querySet = (V5QuerySet)factory.createNode(101002);
        environment.getNodeIndex().addNode(querySet);
        environment.setRoot(querySet);
        V5Query v5Query = (V5Query)factory.createNode(101006);
        querySet.addChild(v5Query);
        v5Query.setPropertyValue(NAME, QUERY_NAME);
        v5Query.setPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName(), "true");
        V5Source source = (V5Source)factory.createNode(101007);
        v5Query.addChild(source);
        String module = null;
        String table = null;
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            String v;
            Element child = (Element)children.get(i);
            List nameValue = child.elements();
            HashMap<String, String> mp = new HashMap<String, String>();
            for (int j = 0; j < nameValue.size(); ++j) {
                Element e = (Element)nameValue.get(j);
                String eName = e.getName();
                mp.put(eName, e.getText());
            }
            String key = (String)mp.get(NAME);
            if (key == null || (v = (String)mp.get(VALUE)) == null) continue;
            if (MODULE.equals(key)) {
                module = v;
                continue;
            }
            if (!IDENTIFIER.equals(key)) continue;
            table = v;
        }
        if (module == null || table == null) {
            int numParam = 0;
            if (module != null) {
                ++numParam;
            }
            if (table != null) {
                ++numParam;
            }
            throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidMoserCommandSpec, (Object)"getTableStatistics", (Object)"2", (Object)numParam);
        }
        querySet.setPropertyValue("modelPath", module);
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        if (metadataConnection == null) {
            source.setModel(module);
            source.setModelType(MODULE);
        } else {
            source.setModel(metadataConnection.getModelPath());
            source.setModelType(metadataConnection.getModelType());
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        if (metadataConnection == null) {
            MetricsService.startCollectingMetric(requestEnv, "mfwRequest");
            metadataConnection = MetadataService.getInstance().getConnection("MOSER", module, execEnv, true);
            MetricsService.endCollectingMetric(requestEnv, "mfwRequest");
        }
        if ((dataSources = metadataConnection.getModelDataSources()) != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                IModelDataSource modelDS = dataSources.get(i);
                execEnv.getOrAddDataSource(modelDS);
            }
        }
        environment.setMetdataConnection(metadataConnection);
        source.setIsBound();
        IXQEQueryNode selection = factory.createNode(101009);
        v5Query.addChild(selection);
        MoserMetadataConnection moserConn = (MoserMetadataConnection)metadataConnection;
        IMetadata metadata = moserConn.bindQuerySubjectReference(table);
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)factory.createNode(101055);
        querySet.addChild(qrd);
        qrd.setPropertyValue(NAME, QRD_NAME);
        qrd.setRefQueryProperty(QUERY_NAME);
        IXQEQueryNode edge = factory.createNode(101049);
        qrd.addChild(edge);
        edge.setPropertyValue(NAME, EDGE_NAME);
        V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)factory.createNode(101057);
        edgeGroup.addChild(valueSet);
        valueSet.setNameProperty(VALUESET_NAME);
        IXQEQueryNode groupBody = factory.createNode(101051);
        valueSet.addChild(groupBody);
        groupBody.setPropertyValue(NAME, GROUPBODY_NAME);
        IQuerySubject qs = (IQuerySubject)metadata;
        String diName = qs.getName();
        List<IMetadata> dataItems = qs.getQueryItemsAndMeasures();
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        selection.addChild(dataItem);
        dataItem.setPropertyValue(NAME, diName);
        V5Expression vExpression = (V5Expression)factory.createNode(101004);
        vExpression.setExpression("count(ROWS " + dataItems.get(0).getV5UniqueName() + ")");
        dataItem.addChild(vExpression);
        IXQEQueryNode dataItemRef = factory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", diName);
        groupBody.addChild(dataItemRef);
        return querySet;
    }

    public final class RowHandler
    implements RSAPIRowCallback {
        private JSONObject root;

        RowHandler(JSONObject r, RSAPIDataset dataset) {
            this.root = r;
            RSAPIColumn[] rsColumns = dataset.getEdge(0).getRowset(0).getColumns();
            RSAPIColumn c = rsColumns[0];
            this.root.put((Object)GenerateV5QueryForTableStatistics.IDENTIFIER, (Object)c.getName());
        }

        @Override
        public void consumeRow(RSAPIRow aRow, RSAPIColumn[] rsColumns, FormatId[] formatIDs) {
            Value v = (Value)aRow.getColumn(0);
            if (v == null) {
                JSONObject jObj = new JSONObject();
                jObj.put((Object)ValueState.NULL.toString(), (Object)"true");
                this.root.put((Object)GenerateV5QueryForTableStatistics.ROWS, (Object)jObj);
            } else if (!v.isOK()) {
                JSONObject jObj = new JSONObject();
                jObj.put((Object)v.getState().toString(), (Object)"true");
                this.root.put((Object)GenerateV5QueryForTableStatistics.ROWS, (Object)jObj);
            } else {
                try {
                    v.setFormatId(formatIDs[0]);
                    String value = v.getV5formattedString();
                    this.root.put((Object)GenerateV5QueryForTableStatistics.ROWS, (Object)value);
                }
                catch (Exception e) {
                    JSONObject jObj = new JSONObject();
                    jObj.put((Object)ValueState.ERROR.toString(), (Object)e.getMessage());
                    this.root.put((Object)GenerateV5QueryForTableStatistics.ROWS, (Object)jObj);
                }
            }
        }

        @Override
        public boolean reRun() {
            return false;
        }

        @Override
        public boolean needReIterateRows() {
            return false;
        }
    }
}

