/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.modquery.ModFilterStringCompare;
import com.cognos.xqe.ast.v5.modquery.ModQueryUtil;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralSpecial;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqe.transformation.moser.util.ConvertModQueryToV5QueryUtil;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserQueryItem;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class GenerateV5QueryFromMoserFacetQuery {
    private static final String MOSER_MODULE = "module";
    private static final String MOSER_ATTRIBUTE_ID = "attributeId";
    private static final String MOSER_RESULTCOUNT = "resultCount";
    private static final String MOSER_SEARCH = "search";
    private static final String MOSER_NAME = "name";
    private static final String MOSER_VALUE = "value";
    private static final String MOSER_FACETVALUE = "item";
    private static final String QUERY_NAME = "QueryMoserFacets";
    private static final String QRD_NAME = "QueryMoserFacetsQRD";
    private static final String EDGE_NAME = "QueryMoserFacetsEdge";
    private static final String VALUESET_NAME = "QueryMoserFacetsValueSet";
    private static final String GROUPBODY_NAME = "QueryMoserFacetsGroupBody";
    private static final String DATAITEM_NAME = "c1";
    private static final String TOTAL_COUNT_DATAITEM_NAME = "c2";
    public static final String RESPONSE = "getFacetValuesResponse";
    private static final String RESULT = "getFacetValuesResult";
    private static final String X_TOTAL_COUNT = "X-Total-Count";
    private static final String FACET_VALUES = "facetValues";
    private static final String LAST = "last";
    private static final String FIRST = "first";

    public static V5QuerySet generateV5QuerySet(PlanningEnvironment environment, Element functionSpec) {
        String sNullPlace;
        List<IModelDataSource> dataSources;
        XQENodeFactory factory = environment.getNodeFactory();
        V5QuerySet querySet = (V5QuerySet)factory.createNode(101002);
        environment.getNodeIndex().addNode(querySet);
        environment.setRoot(querySet);
        V5Query v5Query = (V5Query)factory.createNode(101006);
        querySet.addChild(v5Query);
        v5Query.setPropertyValue(MOSER_NAME, QUERY_NAME);
        v5Query.setPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName(), "true");
        V5Source source = (V5Source)factory.createNode(101007);
        v5Query.addChild(source);
        String attrId = null;
        String modelPath = null;
        String resultCount = null;
        String limit = null;
        String offset = null;
        String search = null;
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            String v;
            Element child = (Element)children.get(i);
            List nameValue = child.elements();
            HashMap<String, String> mp = new HashMap<String, String>();
            for (int j = 0; j < nameValue.size(); ++j) {
                Element e = (Element)nameValue.get(j);
                String eName = e.getName();
                mp.put(eName, e.getText());
            }
            String key = (String)mp.get(MOSER_NAME);
            if (key == null || (v = (String)mp.get(MOSER_VALUE)) == null) continue;
            if (MOSER_MODULE.equals(key)) {
                modelPath = v;
                continue;
            }
            if (MOSER_ATTRIBUTE_ID.equals(key)) {
                attrId = v;
                continue;
            }
            if (MOSER_RESULTCOUNT.equals(key)) {
                resultCount = v;
                continue;
            }
            if ("offset".equals(key)) {
                offset = v;
                continue;
            }
            if ("limit".equals(key)) {
                limit = v;
                continue;
            }
            if (!MOSER_SEARCH.equals(key)) continue;
            search = v;
        }
        if (limit == null && resultCount != null) {
            limit = resultCount;
        }
        if (modelPath == null || attrId == null || limit == null) {
            int numParam = 0;
            if (modelPath != null) {
                ++numParam;
            }
            if (attrId != null) {
                ++numParam;
            }
            if (limit != null) {
                ++numParam;
            }
            throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidMoserCommandSpec, (Object)"getFacetValues", (Object)"3", (Object)numParam);
        }
        querySet.setPropertyValue("modelPath", modelPath);
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        if (metadataConnection == null) {
            source.setModel(modelPath);
            source.setModelType(MOSER_MODULE);
        } else {
            source.setModel(metadataConnection.getModelPath());
            source.setModelType(metadataConnection.getModelType());
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        if (metadataConnection == null) {
            MetricsService.startCollectingMetric(requestEnv, "mfwRequest");
            metadataConnection = MetadataService.getInstance().getConnection("MOSER", modelPath, execEnv, true);
            MetricsService.endCollectingMetric(requestEnv, "mfwRequest");
        }
        if ((dataSources = metadataConnection.getModelDataSources()) != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                IModelDataSource modelDS = dataSources.get(i);
                execEnv.getOrAddDataSource(modelDS);
            }
        }
        environment.setMetdataConnection(metadataConnection);
        source.setIsBound();
        IXQEQueryNode selection = factory.createNode(101009);
        v5Query.addChild(selection);
        IMetadata md = null;
        md = search == null || search.isEmpty() ? GenerateV5QueryFromMoserFacetQuery.createDataItem(metadataConnection, attrId, factory, selection, DATAITEM_NAME) : GenerateV5QueryFromMoserFacetQuery.createDataItemForSearch(environment, metadataConnection, search, factory, v5Query, DATAITEM_NAME, attrId);
        ArrayList<ISortItem> sortItems = new ArrayList<ISortItem>();
        boolean bFacet = GenerateV5QueryFromMoserFacetQuery.isFacetEnabled(md, sortItems);
        if (!bFacet) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_FacetDisabled, attrId);
        }
        String totalCount = null;
        if (resultCount == null) {
            totalCount = TOTAL_COUNT_DATAITEM_NAME;
            V5DataItem totalcountDataItem = (V5DataItem)factory.createNode(101003);
            selection.addChild(totalcountDataItem);
            totalcountDataItem.setPropertyValue(MOSER_NAME, totalCount);
            V5ValueSummaryFunction countExp = (V5ValueSummaryFunction)factory.createNode(201031);
            countExp.setSubType(2);
            V5LiteralSpecial rowsExp = (V5LiteralSpecial)factory.createNode(201025);
            rowsExp.setSubType(5);
            countExp.addChild(rowsExp);
            V5AggregateBreakClause forClause = (V5AggregateBreakClause)factory.createNode(201037);
            forClause.setSubType(0);
            countExp.addChild(forClause);
            totalcountDataItem.addChild(countExp);
        }
        ArrayList<String> sorts = new ArrayList<String>();
        int i = 0;
        for (i = 0; i < sortItems.size(); ++i) {
            String ref = sortItems.get(i).getRefObject();
            if (attrId.equals(ref)) {
                sorts.add(DATAITEM_NAME);
                continue;
            }
            String sName = DATAITEM_NAME + i;
            GenerateV5QueryFromMoserFacetQuery.createDataItem(metadataConnection, ref, factory, selection, sName);
            sorts.add(sName);
        }
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)factory.createNode(101055);
        querySet.addChild(qrd);
        String nCount = limit;
        if (offset != null) {
            nCount = Long.toString(Long.valueOf(limit) + Long.valueOf(offset));
        }
        qrd.setPropertyValue("topNRows", nCount);
        qrd.setPropertyValue(MOSER_NAME, QRD_NAME);
        qrd.setRefQueryProperty(QUERY_NAME);
        IXQEQueryNode edge = factory.createNode(101049);
        qrd.addChild(edge);
        edge.setPropertyValue(MOSER_NAME, EDGE_NAME);
        V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)factory.createNode(101057);
        edgeGroup.addChild(valueSet);
        valueSet.setNameProperty(VALUESET_NAME);
        IXQEQueryNode groupBody = factory.createNode(101051);
        valueSet.addChild(groupBody);
        groupBody.setPropertyValue(MOSER_NAME, GROUPBODY_NAME);
        IXQEQueryNode dataItemRef = factory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", DATAITEM_NAME);
        groupBody.addChild(dataItemRef);
        if (totalCount != null) {
            IXQEQueryNode totalCountDataItemRef = factory.createNode(101015);
            totalCountDataItemRef.setPropertyValue("refDataItem", totalCount);
            groupBody.addChild(totalCountDataItemRef);
        }
        if (sortItems.isEmpty()) {
            sNullPlace = null;
            if (((IQueryItem)md).isNullable()) {
                sNullPlace = LAST;
            }
            GenerateV5QueryFromMoserFacetQuery.addGroupSort(factory, valueSet, DATAITEM_NAME, ISortItem.SortType.ASCENDING.toString(), sNullPlace);
        } else {
            for (i = 0; i < sortItems.size(); ++i) {
                sNullPlace = null;
                ISortItem.NullPlacementType nullPlace = sortItems.get(i).getNullPlacement();
                if (nullPlace != null) {
                    if (nullPlace == ISortItem.NullPlacementType.NULL_LAST) {
                        sNullPlace = LAST;
                    } else if (nullPlace == ISortItem.NullPlacementType.NULL_FIRST) {
                        sNullPlace = FIRST;
                    }
                }
                GenerateV5QueryFromMoserFacetQuery.addGroupSort(factory, valueSet, (String)sorts.get(i), sortItems.get(i).getSort().toString(), sNullPlace);
            }
        }
        return querySet;
    }

    private static void addGroupSort(XQENodeFactory factory, V5ValueSet valueSet, String dataItem, String direction, String nullPlace) {
        V5SortItem sortItemNode = (V5SortItem)factory.createNode(101056);
        sortItemNode.setPropertyValue("refDataItem", dataItem);
        sortItemNode.setPropertyValue("sortOrder", direction);
        if (nullPlace != null) {
            sortItemNode.setPropertyValue("nullPlace", nullPlace);
        }
        valueSet.addChild(sortItemNode);
    }

    private static boolean isFacetEnabled(IMetadata md, List<ISortItem> sortItems) {
        if (!(md instanceof IQueryItem)) {
            return false;
        }
        IQueryItem qi = (IQueryItem)md;
        if (qi instanceof MoserQueryItem) {
            IFacet facet = qi.getFacet();
            if (facet == null || !facet.isEnabled()) {
                return false;
            }
            if (facet.isExplicitlySetByModeler()) {
                sortItems.addAll(Arrays.asList(facet.getSortItems()));
            }
            return true;
        }
        return MoserModuleUtil.resolveEnabled(qi);
    }

    private static IMetadata createDataItem(MetadataConnection metadataConnection, String ref, XQENodeFactory factory, IXQEQueryNode selection, String name) {
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        selection.addChild(dataItem);
        dataItem.setPropertyValue(MOSER_NAME, name);
        IMetadata md = metadataConnection.bindMetadataReference(ref);
        V5BoundModelIdentifier boundNode = (V5BoundModelIdentifier)factory.createNode(201116);
        boundNode.setMetadata(md);
        dataItem.addChild(boundNode);
        return md;
    }

    private static IMetadata createDataItemForSearch(PlanningEnvironment environment, MetadataConnection metadataConnection, String search, XQENodeFactory factory, V5Query v5Query, String name, String attrId) {
        IMetadata md = GenerateV5QueryFromMoserFacetQuery.createDataItem(metadataConnection, attrId, factory, v5Query.getV5Selection(), name);
        IXQEQueryNode v5ExprSecond = GenerateV5QueryFromMoserFacetQuery.createV5StringCompareExpr(environment, v5Query, factory, metadataConnection, name, ModQueryUtil.OPERATOR_CONTAINS, search);
        V5DetailFilter detailFilter = (V5DetailFilter)factory.createNode(101008);
        v5Query.addChild(detailFilter);
        detailFilter.addChild(v5ExprSecond);
        return md;
    }

    private static IXQEQueryNode createV5StringCompareExpr(PlanningEnvironment environment, V5Query v5Query, XQENodeFactory factory, MetadataConnection mc, String name, Object op, String search) {
        HashSet<String> refs = new HashSet<String>();
        refs.add(name);
        ModFilterStringCompare cmp = new ModFilterStringCompare();
        cmp.setStringPropertyValue("refDataItem", name);
        cmp.setStringPropertyValue("operator", (String)op);
        cmp.setStringPropertyValue("caseInsensitive", "yes");
        cmp.setStringPropertyValue("filterValue", search);
        return ConvertModQueryToV5QueryUtil.convertFilterStringCompareToV5BinaryExpression(environment, v5Query, cmp, factory, mc, refs);
    }

    public static Element generateResponse(RSAPIDataset dataset, Element functionSpec) {
        GenerateV5QueryFromMoserFacetQuery q = new GenerateV5QueryFromMoserFacetQuery();
        return q.generateResponseLoadDataSet(dataset, functionSpec);
    }

    protected Element generateResponseLoadDataSet(RSAPIDataset dataset, Element functionSpec) {
        String offset = MoserCommandUtil.getNamedValue(functionSpec, "offset");
        long off = 0L;
        if (offset != null) {
            off = Long.valueOf(offset);
        }
        Element elemResponse = DocumentHelper.createElement((String)RESPONSE);
        Element elemResult = DocumentHelper.createElement((String)RESULT);
        elemResponse.add(elemResult);
        JSONObject jResult = null;
        if (MoserCommandUtil.getNamedValue(functionSpec, "limit") != null) {
            jResult = new JSONObject();
        }
        RowHandler callback = new RowHandler(elemResult, off, jResult);
        RelationalCrosstabCube.loadFromTabularQuery(dataset, callback);
        if (jResult != null) {
            Element e = DocumentHelper.createElement((String)MOSER_FACETVALUE);
            e.setText(jResult.toString());
            elemResult.add(e);
        }
        return elemResponse;
    }

    private final class RowHandler
    implements RSAPIRowCallback {
        private Element root;
        private long offset;
        private JSONObject jsonResult;
        private boolean bTotalCountAdded = false;
        private JSONArray jsonValues = null;

        RowHandler(Element d, long off, JSONObject r) {
            this.root = d;
            this.offset = off;
            this.jsonResult = r;
        }

        @Override
        public void consumeRow(RSAPIRow aRow, RSAPIColumn[] columns, FormatId[] formatIDs) {
            if (this.jsonResult != null) {
                this.addTotalCount(aRow);
            }
            if (this.offset > 0L) {
                --this.offset;
                return;
            }
            if (this.jsonResult == null) {
                this.addValueInResultLegacy(aRow, formatIDs);
            } else {
                this.addValueInJSONResult(aRow, formatIDs);
            }
        }

        private void addTotalCount(RSAPIRow aRow) {
            if (this.bTotalCountAdded) {
                return;
            }
            Value v1 = (Value)aRow.getColumn(1);
            if (v1 == null || !v1.isOK()) {
                return;
            }
            String n = v1.toString();
            this.jsonResult.put((Object)GenerateV5QueryFromMoserFacetQuery.X_TOTAL_COUNT, (Object)n);
            this.bTotalCountAdded = true;
        }

        private void addValueInJSONResult(RSAPIRow aRow, FormatId[] formatIDs) {
            Value v0 = (Value)aRow.getColumn(0);
            if (v0 == null) {
                return;
            }
            if (!v0.isOK()) {
                if (v0.isNull()) {
                    if (this.jsonValues == null) {
                        this.jsonValues = new JSONArray();
                        this.jsonResult.put((Object)GenerateV5QueryFromMoserFacetQuery.FACET_VALUES, (Object)this.jsonValues);
                    }
                    this.jsonValues.add(null);
                }
                return;
            }
            v0.setFormatId(formatIDs[0]);
            String factValue = v0.getV5formattedString();
            if (this.jsonValues == null) {
                this.jsonValues = new JSONArray();
                this.jsonResult.put((Object)GenerateV5QueryFromMoserFacetQuery.FACET_VALUES, (Object)this.jsonValues);
            }
            this.jsonValues.add((Object)factValue);
        }

        private void addValueInResultLegacy(RSAPIRow aRow, FormatId[] formatIDs) {
            Value v = (Value)aRow.getColumn(0);
            if (v == null) {
                return;
            }
            if (!v.isOK()) {
                if (v.isNull()) {
                    Element elemNull = DocumentHelper.createElement((String)GenerateV5QueryFromMoserFacetQuery.MOSER_FACETVALUE);
                    elemNull.addAttribute("nil", "true");
                    this.root.add(elemNull);
                }
                return;
            }
            v.setFormatId(formatIDs[0]);
            String factValue = v.getV5formattedString();
            Element e = DocumentHelper.createElement((String)GenerateV5QueryFromMoserFacetQuery.MOSER_FACETVALUE);
            e.setText(factValue);
            this.root.add(e);
        }

        @Override
        public boolean reRun() {
            return false;
        }

        @Override
        public boolean needReIterateRows() {
            return false;
        }
    }
}

