/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.V5Constants;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserRelationship;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class GenerateV5QueryFromMoserJoinQuery {
    private static final String MODULE = "module";
    public static final String JOINSPEC = "joinSpec";
    private static final String RESULTCOUNT = "resultCount";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String QUERY_NAME = "QueryMoserValues";
    private static final String QRD_NAME = "QueryMoserValuesQRD";
    private static final String EDGE_NAME = "QueryMoserValuesEdge";
    private static final String VALUESET_NAME = "QueryMoserValuesValueSet";
    private static final String GROUPBODY_NAME = "QueryMoserValuesGroupBody";
    public static final String RESPONSE = "getTableValuesResponse";
    public static final String TABULAR = "tabular";
    public static final String OFFSET = "offset";
    private static final String RELATIONSHIP = "relationship";
    private static final String DOT = ".";
    private static final String IDENTIFIER = "identifier";

    public static V5QuerySet generateV5QuerySet(PlanningEnvironment environment, Element functionSpec) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5QuerySet querySet = (V5QuerySet)factory.createNode(101002);
        environment.getNodeIndex().addNode(querySet);
        environment.setRoot(querySet);
        V5Query v5Query = (V5Query)factory.createNode(101006);
        querySet.addChild(v5Query);
        v5Query.setPropertyValue(NAME, QUERY_NAME);
        v5Query.setPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName(), "true");
        V5Source source = (V5Source)factory.createNode(101007);
        v5Query.addChild(source);
        String module = null;
        String joinSpecStr = null;
        String resultCount = null;
        String offset = "0";
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            String v;
            Element child = (Element)children.get(i);
            List nameValue = child.elements();
            HashMap<String, String> mp = new HashMap<String, String>();
            for (int j = 0; j < nameValue.size(); ++j) {
                Element e = (Element)nameValue.get(j);
                String eName = e.getName();
                mp.put(eName, e.getText());
            }
            String key = (String)mp.get(NAME);
            if (key == null || (v = (String)mp.get(VALUE)) == null) continue;
            if (MODULE.equals(key)) {
                module = v;
                continue;
            }
            if (JOINSPEC.equals(key)) {
                joinSpecStr = v;
                continue;
            }
            if (RESULTCOUNT.equals(key)) {
                resultCount = v;
                continue;
            }
            if (!OFFSET.equals(key)) continue;
            offset = v;
        }
        int numParam = 0;
        if (module == null || joinSpecStr == null || resultCount == null) {
            if (module != null) {
                ++numParam;
            }
            if (joinSpecStr != null) {
                ++numParam;
            }
            if (resultCount != null) {
                ++numParam;
            }
            throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidMoserCommandSpec, V5Constants.GETJOINVALUES, (Object)"3", (Object)numParam);
        }
        querySet.setPropertyValue("modelPath", module);
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        if (metadataConnection == null) {
            source.setModel(module);
            source.setModelType(MODULE);
        } else {
            source.setModel(metadataConnection.getModelPath());
            source.setModelType(metadataConnection.getModelType());
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        if (metadataConnection == null) {
            MetricsService.startCollectingMetric(requestEnv, "mfwRequest");
            metadataConnection = MetadataService.getInstance().getConnection("MOSER", module, execEnv, true);
            MetricsService.endCollectingMetric(requestEnv, "mfwRequest");
        }
        MoserModule moserModule = ((MoserMetadataConnection)metadataConnection).getModule();
        List<IModelDataSource> dataSources = metadataConnection.getModelDataSources();
        if (dataSources != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                IModelDataSource modelDS = dataSources.get(i);
                execEnv.getOrAddDataSource(modelDS);
            }
        }
        environment.setMetdataConnection(metadataConnection);
        source.setIsBound();
        V5Selection selection = (V5Selection)factory.createNode(101009);
        selection.setAutoSummary(false);
        v5Query.addChild(selection);
        JSONObject joinSpec = null;
        try {
            joinSpec = JSONObject.parse((String)joinSpecStr);
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidMoserCommandSpec, V5Constants.GETJOINVALUES, (Object)"3", (Object)numParam);
        }
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)factory.createNode(101055);
        querySet.addChild(qrd);
        String topNRows = Long.toString(Long.valueOf(resultCount) + Long.valueOf(offset));
        qrd.setPropertyValue("topNRows", topNRows);
        qrd.setPropertyValue(NAME, QRD_NAME);
        qrd.setRefQueryProperty(QUERY_NAME);
        IXQEQueryNode edge = factory.createNode(101049);
        qrd.addChild(edge);
        edge.setPropertyValue(NAME, EDGE_NAME);
        V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)factory.createNode(101057);
        edgeGroup.addChild(valueSet);
        valueSet.setNameProperty(VALUESET_NAME);
        IXQEQueryNode groupBody = factory.createNode(101051);
        valueSet.addChild(groupBody);
        groupBody.setPropertyValue(NAME, GROUPBODY_NAME);
        JSONArray projections = (JSONArray)joinSpec.get((Object)"projections");
        int ci = 0;
        for (Object p : projections.toArray()) {
            JSONObject projection = (JSONObject)p;
            String id = (String)projection.get((Object)IDENTIFIER);
            if (!MetadataUtil.isIdForPackage(id)) {
                id = moserModule.getUniqueName() + DOT + id;
            }
            IMetadata metadata = metadataConnection.bindMetadataReference(id);
            String diName = "c" + Integer.toString(ci++);
            GenerateV5QueryFromMoserJoinQuery.createDataItem(metadataConnection, metadata, factory, selection, diName);
            IXQEQueryNode dataItemRef = factory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", diName);
            groupBody.addChild(dataItemRef);
            String sort = (String)projection.get((Object)"sort");
            if (sort == null) continue;
            V5SortItem sortItem = (V5SortItem)factory.createNode(101056);
            sortItem.setPropertyValue("refDataItem", diName);
            sortItem.setPropertyValue("sortOrder", sort);
            valueSet.addChild(sortItem);
        }
        JSONObject relationship = (JSONObject)joinSpec.get((Object)RELATIONSHIP);
        MoserRelationship r = MoserModuleUtil.createRelationship(moserModule, relationship);
        ArrayList<IMetadata> joins = new ArrayList<IMetadata>();
        joins.add(r);
        v5Query.setPreferredJoins(joins);
        v5Query.setPropertyValue("queryForTestJoin", true);
        return querySet;
    }

    private static void createDataItem(MetadataConnection metadataConnection, IMetadata md, XQENodeFactory factory, IXQEQueryNode selection, String name) {
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        selection.addChild(dataItem);
        dataItem.setPropertyValue(NAME, name);
        V5BoundModelIdentifier boundNode = (V5BoundModelIdentifier)factory.createNode(201116);
        boundNode.setMetadata(md);
        dataItem.addChild(boundNode);
    }
}

