/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5FilterExpression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqe.transformation.moser.ReferenceResolver;
import com.cognos.xqe.util.Pair;
import com.cognos.xqebifw.bibushandler.MoserCommandAdapter;
import com.cognos.xqemoser.IMoserModule;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserEmbeddedFilter;
import com.cognos.xqemoser.MoserEmbeddedModuleWrapper;
import com.cognos.xqemoser.MoserFilter;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQueryItemFolder;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.QsClassifierType;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class GenerateV5QueryFromMoserValidate {
    public static final String MODULE = "module";
    private static final String CALCULATION_EXPRESSION = "calculationExpression";
    private static final String FILTER_EXPRESSION = "filterExpression";
    public static final String IDENTIFIER = "identifier";
    private static final String MOSER_FUNCTION_TYPE = "moserFunctionType";
    private static final String COLUMN_LIST = "columnList";
    public static final String ITEM = "item";
    private static final String DATATYPE = "datatype";
    public static final String LENGTH = "length";
    public static final String PRECISION = "precision";
    public static final String SCALE = "scale";
    public static final String USAGE = "usage";
    public static final String REGULARAGGREGATE = "regularAggregate";
    public static final String NULLABLE = "nullable";
    public static final String ATTRIBUTE = "attribute";
    public static final String MINIMUM = "minimum";
    public static final String BOOLEAN = "boolean";
    private static final String CALCULATED = "calculated";
    private static final String TOTAL = "total";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String QUERY_NAME = "validateQuery";
    private static final String QRD_NAME = "QRD1";
    private static final String EDGE_NAME = "Edge1";
    private static final String VALUESET_NAME = "valueSet1";
    private static final String GROUPBODY_NAME = "groupBody1";
    public static final String CHAR_NAME_UTF8 = "UTF-8";
    public static final String STR_NEW = "new";
    public static final String STR_CONTEXT_IDENTIFIER = "contextIdentifier";
    public static final String STR_MODULE_LOCATION = "moduleLocation";
    public static final String STR_FILTER_DASH = "filter-";
    public static final String STR_CALCULATION_DASH = "calculation-";
    public static final String STR_ESCAPE_DOT = "\\.";
    public static final String STR_SLASH_EXPRESSION = "]/expression";
    public static final String STR_QUERYSUBJECT_INDEX = "./querySubject[";
    public static final String STR_CALCULATION_INDEX = "./calculation[";
    public static final String STR_FILTER_INDEX = "/filter[";
    public static final String STR_ITEM_INDEX = "/item[";
    private static final String STR_FOLDER_INDEX = "]/folder";
    public static final String STR_CONTEXT_METADATA = "contextMetadata";
    public static final String STR_DOT = ".";
    private static final String FILTER_PLACEHOLDER_EXPR = "1";
    private static final String STR_CLOSE_BRACKET = "]";
    public static final String STR_SLASH_EXPR = "/expression";
    public static final String STR_FAULTS = "moserFaults";
    public static final Pattern VALIDATE_EXPRESSION_REPLACEMENT_PATTERN = Pattern.compile("(^[ \t]*//[ \t]*validate[ \t]*:[ \t]*)(.*$)", 10);

    public static void generateV5QuerySet(PlanningEnvironment environment, Element functionSpec) {
        List<IModelDataSource> dataSources;
        MoserCommandUtil.logMoserCommandSpec(functionSpec);
        XQENodeFactory factory = environment.getNodeFactory();
        V5QuerySet querySet = (V5QuerySet)factory.createNode(101002);
        environment.getNodeIndex().addNode(querySet);
        environment.setRoot(querySet);
        V5Query v5Query = (V5Query)factory.createNode(101006);
        querySet.addChild(v5Query);
        v5Query.setPropertyValue(NAME, QUERY_NAME);
        v5Query.setPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName(), "true");
        V5Source source = (V5Source)factory.createNode(101007);
        v5Query.addChild(source);
        String module = null;
        String calculationExpression = null;
        String filterExpression = null;
        String contextIdentifier = null;
        String moserFunctionType = null;
        String usage = null;
        String aggregateType = null;
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            String v;
            Element child = (Element)children.get(i);
            List nameValue = child.elements();
            HashMap<String, String> mp = new HashMap<String, String>();
            for (int j = 0; j < nameValue.size(); ++j) {
                Element e = (Element)nameValue.get(j);
                String eName = e.getName();
                mp.put(eName, e.getText());
            }
            String key = (String)mp.get(NAME);
            if (key == null || (v = (String)mp.get(VALUE)) == null) continue;
            if (MODULE.equals(key)) {
                module = v;
                continue;
            }
            if (CALCULATION_EXPRESSION.equals(key)) {
                calculationExpression = GenerateV5QueryFromMoserValidate.adjustExpressionForValidateMode(v);
                continue;
            }
            if (FILTER_EXPRESSION.equals(key)) {
                filterExpression = GenerateV5QueryFromMoserValidate.adjustExpressionForValidateMode(v);
                continue;
            }
            if (IDENTIFIER.equals(key)) {
                contextIdentifier = v;
                continue;
            }
            if (MOSER_FUNCTION_TYPE.equals(key)) {
                moserFunctionType = v;
                continue;
            }
            if (USAGE.equals(key)) {
                usage = v;
                continue;
            }
            if (!REGULARAGGREGATE.equals(key)) continue;
            aggregateType = v;
        }
        if (module == null || "validate".equals(moserFunctionType) && calculationExpression == null && filterExpression == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Missing parameter module or expression in API feedbackCalculation");
        }
        querySet.setPropertyValue("modelPath", module);
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        if (metadataConnection == null) {
            source.setModel(module);
            source.setModelType(MODULE);
        } else {
            source.setModel(metadataConnection.getModelPath());
            source.setModelType(metadataConnection.getModelType());
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        if (metadataConnection == null) {
            MetricsService.startCollectingMetric(requestEnv, "mfwRequest");
            metadataConnection = MetadataService.getInstance().getConnection("MOSER", module, execEnv, true);
            MetricsService.endCollectingMetric(requestEnv, "mfwRequest");
        }
        if ((dataSources = metadataConnection.getModelDataSources()) != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                IModelDataSource modelDS = dataSources.get(i);
                execEnv.getOrAddDataSource(modelDS);
            }
        }
        environment.setMetdataConnection(metadataConnection);
        boolean bBase = IMoserModule.ModuleType.BASE.equals((Object)((MoserMetadataConnection)metadataConnection).getModule().getModuleType());
        environment.getSymbolTableStack().setAllowBindToSelf(bBase);
        Locale moduleExpressionLocale = ((MoserMetadataConnection)metadataConnection).getModuleExpressionLocale();
        if (moduleExpressionLocale != null) {
            requestEnv.setExpressionLocale(moduleExpressionLocale);
        }
        source.setIsBound();
        IXQEQueryNode selection = factory.createNode(101009);
        boolean isAutoSummary = CALCULATED.equals(aggregateType);
        selection.setPropertyValue("autoSummary", isAutoSummary);
        v5Query.addChild(selection);
        String diName = null;
        List<Object> dataItemNames = new ArrayList();
        if ("validateAll".equals(moserFunctionType)) {
            dataItemNames = GenerateV5QueryFromMoserValidate.createItemsForValidateAll(metadataConnection, selection, factory, v5Query);
        } else if (calculationExpression != null) {
            Element faults;
            XQERuntimeException e;
            String expression;
            requestEnv.setResolveIsNullable(true);
            String[] parts = null;
            diName = contextIdentifier != null ? ((parts = contextIdentifier.split(STR_ESCAPE_DOT)).length == 1 ? "calculation-new" : (parts.length == 2 ? STR_CALCULATION_DASH + parts[1] : "calculation-dummy")) : "calculation-new";
            IMetadata calcOrQI = null;
            MoserMetadataConnection mmc = (MoserMetadataConnection)metadataConnection;
            if (mmc != null && contextIdentifier != null && !contextIdentifier.isEmpty() && (calcOrQI = mmc.bindQuerySubjectReference(contextIdentifier)) == null && !contextIdentifier.equals(mmc.getModule().getIdentifier())) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, contextIdentifier + " invalid context element - must be one of queryItem, querySubject, module or calculation");
            }
            if (calcOrQI instanceof MoserQueryItem || calcOrQI instanceof MoserCalculation) {
                expression = calculationExpression;
                if (calcOrQI instanceof MoserCalculation && (e = MoserModuleUtil.preCheckCalculatedQueryItem((MoserCalculation)calcOrQI, calculationExpression)) != null) {
                    expression = FILTER_PLACEHOLDER_EXPR;
                    faults = DocumentHelper.createElement((String)STR_FAULTS);
                    faults.addText(e.getLocalizedMessage());
                    functionSpec.add(faults);
                }
                String context = contextIdentifier;
                GenerateV5QueryFromMoserValidate.createDataItem(factory, selection, diName, expression, null, context);
                MoserModule mm = mmc.getModule();
                String string = mm.getUniqueName();
                mmc.setExpressionOverride(string + STR_DOT + contextIdentifier, calculationExpression);
            } else {
                expression = calculationExpression;
                if (calcOrQI instanceof MoserQuerySubject && CALCULATED.equalsIgnoreCase(aggregateType) && (e = MoserModuleUtil.preCheckCalculatedExpression((MoserQuerySubject)calcOrQI, calculationExpression, usage)) != null) {
                    expression = FILTER_PLACEHOLDER_EXPR;
                    faults = DocumentHelper.createElement((String)STR_FAULTS);
                    faults.addText(e.getLocalizedMessage());
                    functionSpec.add(faults);
                }
                GenerateV5QueryFromMoserValidate.createDataItem(factory, selection, diName, expression, null, contextIdentifier);
            }
            dataItemNames.add(diName);
        } else {
            MoserMetadataConnection mmc;
            IMetadata meta;
            diName = contextIdentifier != null ? STR_FILTER_DASH + contextIdentifier : "filter-new";
            GenerateV5QueryFromMoserValidate.createDataItem(factory, selection, diName, FILTER_PLACEHOLDER_EXPR, null, null);
            dataItemNames.add(diName);
            V5DetailFilter v5Filter = GenerateV5QueryFromMoserValidate.createDetailFilter(factory, v5Query, filterExpression, null, contextIdentifier, null);
            if (contextIdentifier != null && !contextIdentifier.isEmpty() && metadataConnection != null && (meta = (mmc = (MoserMetadataConnection)metadataConnection).bindMetadataReference(contextIdentifier)) instanceof MoserFilter) {
                v5Filter.setPropertyValue(STR_CONTEXT_METADATA, meta);
            }
        }
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)factory.createNode(101055);
        querySet.addChild(qrd);
        qrd.setPropertyValue(NAME, QRD_NAME);
        qrd.setRefQueryProperty(QUERY_NAME);
        IXQEQueryNode edge = factory.createNode(101049);
        qrd.addChild(edge);
        edge.setPropertyValue(NAME, EDGE_NAME);
        V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)factory.createNode(101057);
        edgeGroup.addChild(valueSet);
        valueSet.setNameProperty(VALUESET_NAME);
        IXQEQueryNode groupBody = factory.createNode(101051);
        valueSet.addChild(groupBody);
        groupBody.setPropertyValue(NAME, GROUPBODY_NAME);
        for (String string : dataItemNames) {
            V5DataItemRef dataItemRef = (V5DataItemRef)factory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", string);
            groupBody.addChild(dataItemRef);
        }
    }

    public static String adjustExpressionForValidateMode(String expr) {
        Matcher m = VALIDATE_EXPRESSION_REPLACEMENT_PATTERN.matcher(expr);
        if (m.find()) {
            expr = m.group(2);
        }
        return expr;
    }

    private static void setCtxMapforMacro(IXQEQueryNode exprNode, IMetadata md) {
        IMetadata parent = md.getParentObject();
        if (parent instanceof MoserQueryItem) {
            MoserQueryItem moserQI = (MoserQueryItem)parent;
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            ctxMap.put("parent.idForExpression", moserQI.getIdForExpression());
            String splitRef = moserQI.getSplitRef();
            if (splitRef != null) {
                ctxMap.put("parent.split.ref", splitRef);
            }
            ((XQEQueryNode)exprNode).setPropertyValue("contextMap", ctxMap);
        }
    }

    private static boolean isGeneratedCalculation(MoserCalculation calc) {
        return calc.isRelativeTime();
    }

    private static List<String> createItemsForValidateAll(MetadataConnection metadataConnection, IXQEQueryNode selection, XQENodeFactory factory, V5Query v5Query) {
        MoserQuerySubject qs;
        ArrayList<String> dataItemNames = new ArrayList<String>();
        MoserModule moserModule = ((MoserMetadataConnection)metadataConnection).getModule();
        List<MoserCalculation> calculations = moserModule.getCalculations();
        for (int i = 0; i < calculations.size(); ++i) {
            MoserCalculation calc = calculations.get(i);
            if (GenerateV5QueryFromMoserValidate.isGeneratedCalculation(calc)) continue;
            MoserQuerySubject qs2 = MoserModuleUtil.getParentQuerySubject(calc);
            String moduleLocation = null;
            if (qs2 == null) {
                moduleLocation = GenerateV5QueryFromMoserValidate.buildModuleLocation(STR_CALCULATION_INDEX, 0, i + 1);
            } else {
                int qsPos = qs2.getLocation() + 1;
                if (moserModule instanceof MoserEmbeddedModuleWrapper) {
                    qsPos = ((MoserEmbeddedModuleWrapper)moserModule).getQuerySubjectPosition(qs2, qsPos);
                }
                moduleLocation = GenerateV5QueryFromMoserValidate.buildModuleLocationForQueryItem(qsPos, calc.getLocations(qs2));
            }
            String name = calc.getName();
            V5DataItem v5DI = GenerateV5QueryFromMoserValidate.createDataItem(factory, selection, name, GenerateV5QueryFromMoserValidate.adjustExpressionForValidateMode(calc.getExpression()), moduleLocation, calc.getID());
            dataItemNames.add(name);
            GenerateV5QueryFromMoserValidate.setCtxMapforMacro(v5DI.getChild(0), calc);
            v5DI.setPropertyValue(STR_CONTEXT_METADATA, calc);
        }
        List<MoserFilter> filters = moserModule.getFilters();
        int l = 0;
        for (int i = 0; i < filters.size(); ++i) {
            MoserFilter filter = filters.get(i);
            String moduleLocation = null;
            IMetadata parentObj = filter.getParentObject();
            if (parentObj != null) {
                MoserQuerySubject parentQS = null;
                if (parentObj instanceof MoserQueryItem) {
                    parentQS = (MoserQuerySubject)((MoserQueryItem)parentObj).getQuerySubject();
                } else if (parentObj instanceof MoserQueryItemFolder) {
                    parentQS = (MoserQuerySubject)((MoserQueryItemFolder)parentObj).getQuerySubject();
                } else if (parentObj instanceof MoserQuerySubject) {
                    parentQS = (MoserQuerySubject)parentObj;
                }
                if (parentQS != null) {
                    int qsLocation = GenerateV5QueryFromMoserValidate.getQuerySubjectLocation(moserModule, parentQS);
                    if (moserModule instanceof MoserEmbeddedModuleWrapper) {
                        qsLocation = ((MoserEmbeddedModuleWrapper)moserModule).getQuerySubjectPosition(parentQS, qsLocation);
                    }
                    moduleLocation = GenerateV5QueryFromMoserValidate.buildModuleLocationForFilter(qsLocation, filter.getLocations(parentQS));
                }
            }
            if (moduleLocation == null) {
                moduleLocation = GenerateV5QueryFromMoserValidate.buildModuleLocation("./filter[", 0, ++l);
            }
            String name = STR_FILTER_DASH + filter.getName();
            GenerateV5QueryFromMoserValidate.createDataItem(factory, selection, name, FILTER_PLACEHOLDER_EXPR, moduleLocation, filter.getID());
            dataItemNames.add(name);
            V5DetailFilter detailFilter = GenerateV5QueryFromMoserValidate.createDetailFilter(factory, v5Query, GenerateV5QueryFromMoserValidate.adjustExpressionForValidateMode(filter.getExpression()), moduleLocation, filter.getID(), filter.getName());
            GenerateV5QueryFromMoserValidate.setCtxMapforMacro(detailFilter.getChild(0), filter);
        }
        List<MoserQuerySubject> querySubjects = moserModule.getQuerySubjects();
        if (GenerateV5QueryFromMoserValidate.hasSQLorSetQuerySubject(querySubjects)) {
            for (int i = 0; i < querySubjects.size(); ++i) {
                qs = querySubjects.get(i);
                String qsID = qs.getName();
                List<IMetadata> queryItems = qs.getQueryItemsAndMeasures();
                for (int k = 0; k < queryItems.size(); ++k) {
                    MoserQueryItem qi = (MoserQueryItem)queryItems.get(k);
                    String moduleLocation = GenerateV5QueryFromMoserValidate.buildModuleLocationForQueryItem(i + 1, qi.getLocations(qs));
                    String itemName = qsID + STR_DOT + qi.getName();
                    GenerateV5QueryFromMoserValidate.createDataItem(factory, selection, itemName, itemName, moduleLocation, null);
                    dataItemNames.add(itemName);
                }
            }
        } else {
            for (int i = 0; i < querySubjects.size(); ++i) {
                qs = querySubjects.get(i);
                if (qs.isTransient()) continue;
                int qsPos = i + 1;
                if (moserModule instanceof MoserEmbeddedModuleWrapper) {
                    qsPos = ((MoserEmbeddedModuleWrapper)moserModule).getQuerySubjectPosition(qs, qsPos);
                }
                String qsID = qs.getName();
                List<IEmbeddedFilter> qsFilters = qs.getFilters();
                for (int j = 0; j < qsFilters.size(); ++j) {
                    String moduleLocation = GenerateV5QueryFromMoserValidate.buildModuleLocation(STR_FILTER_INDEX, qsPos, j + 1);
                    MoserEmbeddedFilter filter = (MoserEmbeddedFilter)qsFilters.get(j);
                    if (moserModule instanceof MoserEmbeddedModuleWrapper && !filter.inEmbeddedModule()) continue;
                    String name = qsID + "/" + filter.getName();
                    GenerateV5QueryFromMoserValidate.createDataItem(factory, selection, name, "0", null, null);
                    GenerateV5QueryFromMoserValidate.createDetailFilter(factory, v5Query, GenerateV5QueryFromMoserValidate.adjustExpressionForValidateMode(filter.getExpression()), moduleLocation, qsID, filter.getName());
                    dataItemNames.add(name);
                }
                List<IMetadata> queryItems = qs.getQueryItemsAndMeasures();
                for (int k = 0; k < queryItems.size(); ++k) {
                    MoserQueryItem qi = (MoserQueryItem)queryItems.get(k);
                    if (moserModule instanceof MoserEmbeddedModuleWrapper && !qi.inEmbeddedModule()) continue;
                    String moduleLocation = GenerateV5QueryFromMoserValidate.buildModuleLocationForQueryItem(qsPos, qi.getLocations(qs));
                    String itemName = qsID + STR_DOT + qi.getName();
                    String expression = GenerateV5QueryFromMoserValidate.adjustExpressionForValidateMode(qi.getOriginalExpression());
                    if (IMoserModule.ModuleType.BASE.equals((Object)moserModule.getModuleType())) {
                        expression = itemName;
                    }
                    V5DataItem dataItem = GenerateV5QueryFromMoserValidate.createDataItem(factory, selection, itemName, expression, moduleLocation, qi.getID());
                    dataItem.setPropertyValue(STR_CONTEXT_METADATA, qi);
                    dataItemNames.add(itemName);
                }
            }
        }
        return dataItemNames;
    }

    private static int getQuerySubjectLocation(MoserModule moserModule, MoserQuerySubject querySubject) {
        List<MoserQuerySubject> querySubjects = moserModule.getQuerySubjects();
        for (int i = 0; i < querySubjects.size(); ++i) {
            MoserQuerySubject qs = querySubjects.get(i);
            if (!qs.getUniqueID().equals(querySubject.getUniqueID())) continue;
            return i + 1;
        }
        return 0;
    }

    private static boolean hasSQLorSetQuerySubject(List<MoserQuerySubject> querySubjects) {
        for (MoserQuerySubject qs : querySubjects) {
            QsClassifierType cls = qs.getClassifier();
            if (cls != QsClassifierType.OPERATION_QUERY_SUBJECT) continue;
            return true;
        }
        return false;
    }

    private static String buildModuleLocation(String type, int parentIndex, int index) {
        StringBuffer moduleLocation = new StringBuffer();
        if (parentIndex > 0) {
            moduleLocation.append(STR_QUERYSUBJECT_INDEX);
            moduleLocation.append(parentIndex);
            moduleLocation.append(STR_CLOSE_BRACKET);
        }
        moduleLocation.append(type);
        moduleLocation.append(index);
        moduleLocation.append(STR_SLASH_EXPRESSION);
        return moduleLocation.toString();
    }

    private static StringBuilder buildModuleLocationFolder(int parentIndex, List<Pair> indices) {
        StringBuilder builder = new StringBuilder();
        builder.append(STR_QUERYSUBJECT_INDEX);
        builder.append(parentIndex);
        builder.append(STR_CLOSE_BRACKET);
        for (Pair p : indices) {
            MetadataType tp = (MetadataType)((Object)p.getSecond());
            if (!MetadataType.FOLDER.equals((Object)tp) && !MetadataType.QUERY_ITEM.equals((Object)tp) && !MetadataType.CALCULATION.equals((Object)tp) && !MetadataType.FILTER.equals((Object)tp)) continue;
            builder.append(STR_ITEM_INDEX);
            Integer pos = (Integer)p.getFirst();
            builder.append(pos + 1);
            if (MetadataType.FOLDER.equals((Object)tp)) {
                builder.append(STR_FOLDER_INDEX);
                continue;
            }
            if (MetadataType.QUERY_ITEM.equals((Object)tp) || MetadataType.CALCULATION.equals((Object)tp)) {
                builder.append("]/queryItem");
                continue;
            }
            if (!MetadataType.FILTER.equals((Object)tp)) continue;
            builder.append("]/filter");
        }
        return builder;
    }

    private static String buildModuleLocationForQueryItem(int parentIndex, List<Pair> indices) {
        StringBuilder builder = GenerateV5QueryFromMoserValidate.buildModuleLocationFolder(parentIndex, indices);
        builder.append(STR_SLASH_EXPR);
        return builder.toString();
    }

    private static String buildModuleLocationForFilter(int parentIndex, List<Pair> indices) {
        StringBuilder builder = GenerateV5QueryFromMoserValidate.buildModuleLocationFolder(parentIndex, indices);
        builder.append(STR_SLASH_EXPR);
        return builder.toString();
    }

    private static V5DetailFilter createDetailFilter(XQENodeFactory factory, V5Query v5Query, String urlDecodedExpression, String location, String contextID, String name) {
        V5DetailFilter filter = (V5DetailFilter)factory.createNode(101008);
        filter.setPropertyValue(STR_CONTEXT_IDENTIFIER, contextID);
        filter.setPropertyValue(STR_MODULE_LOCATION, location);
        filter.setPropertyValue(NAME, name);
        v5Query.addChild(filter);
        V5FilterExpression filterExpression = (V5FilterExpression)factory.createNode(101013);
        filterExpression.setPropertyValue("expression", urlDecodedExpression);
        filter.addChild(filterExpression);
        return filter;
    }

    private static V5DataItem createDataItem(XQENodeFactory factory, IXQEQueryNode selection, String dataItemName, String calculationExpression, String location, String contextID) {
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        selection.addChild(dataItem);
        dataItem.setPropertyValue(NAME, dataItemName);
        dataItem.setPropertyValue(STR_CONTEXT_IDENTIFIER, contextID);
        dataItem.setPropertyValue(STR_MODULE_LOCATION, location);
        V5Expression vExpression = (V5Expression)factory.createNode(101004);
        vExpression.setExpression(calculationExpression);
        dataItem.addChild(vExpression);
        return dataItem;
    }

    public static Element generateResponse(ExecutionEnvironment executionEnvironment, RSAPIDataset dataset, Element functionSpec) {
        GenerateV5QueryFromMoserValidate q = new GenerateV5QueryFromMoserValidate();
        return q.generateResponseValidate(executionEnvironment, dataset, functionSpec);
    }

    protected Element generateResponseValidate(ExecutionEnvironment executionEnvironment, RSAPIDataset dataset, Element functionSpec) {
        String msg;
        Element faults = functionSpec.element(STR_FAULTS);
        if (faults != null && (msg = faults.getText()) != null) {
            return MoserCommandAdapter.generateValidateResponse((RequestEnvironment)executionEnvironment.getRequestEnvironment(), msg, false);
        }
        Element elemResponse = DocumentHelper.createElement((String)"validateResponse");
        Element result = DocumentHelper.createElement((String)"validateResult");
        elemResponse.add(result);
        Element itemEle = DocumentHelper.createElement((String)ITEM);
        result.add(itemEle);
        JSONObject jObj = new JSONObject();
        JSONArray itemArray = new JSONArray();
        jObj.put((Object)COLUMN_LIST, (Object)itemArray);
        JSONObject item = new JSONObject();
        itemArray.add((Object)item);
        RSAPIColumn column = dataset.getEdge(0).getRowset(0).getColumns()[0];
        String columnName = column.getName();
        String[] parts = columnName.split("-");
        boolean forCalculation = false;
        String name = null;
        if (parts.length == 2) {
            if ("calculation".equals(parts[0])) {
                forCalculation = true;
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Data item name of validate Moser command is not well formed");
        }
        name = parts[1];
        if (!forCalculation) {
            item.put((Object)NAME, (Object)name);
            item.put((Object)DATATYPE, (Object)BOOLEAN);
        } else {
            item.put((Object)NAME, (Object)name);
            IDataType columnDt = column.getDatatype();
            if (BOOLEAN.equals(columnDt.toString())) {
                return MoserCommandAdapter.generateValidateResponse((RequestEnvironment)executionEnvironment.getRequestEnvironment(), XQEMessages.getMessage(XQEMessageKeys.MSR_ValidationCalculationExpression, XQEMessages.getCurrProductLocale()), false);
            }
            String dtStr = MoserModuleUtil.convertToJMDDataType(columnDt);
            item.put((Object)DATATYPE, (Object)dtStr);
            String usage = column.getUsage().toString();
            if ("unknown".equals(usage)) {
                usage = this.resolveUsageBasedOnDataType(columnDt);
            }
            item.put((Object)USAGE, (Object)usage);
            String aggregateName = null;
            if (IDENTIFIER.equals(usage)) {
                aggregateName = "none";
            } else if (ATTRIBUTE.equals(usage)) {
                aggregateName = MINIMUM;
            } else if (columnDt.isNumeric()) {
                String contextIdentifier = MoserCommandUtil.getNamedValue(functionSpec, IDENTIFIER);
                String module = MoserCommandUtil.getNamedValue(functionSpec, MODULE);
                MoserMetadataConnection mdc = (MoserMetadataConnection)MetadataService.getInstance().getConnection("MOSER", module, executionEnvironment, true);
                aggregateName = TOTAL;
                if (mdc.getModule() != null && (contextIdentifier == null || contextIdentifier.equals(mdc.getModule().getIdentifier()))) {
                    aggregateName = CALCULATED;
                } else {
                    IMetadata object = mdc.bindMetadataReference(contextIdentifier);
                    if (object != null && MetadataType.isCalculation(object)) {
                        aggregateName = CALCULATED;
                    }
                }
            } else {
                aggregateName = columnDt.isTextType() ? "count" : (columnDt.isDate() || columnDt.isDatetime() || columnDt.isTime() || columnDt.isTimestamp() ? "maximum" : MINIMUM);
            }
            item.put((Object)REGULARAGGREGATE, (Object)aggregateName);
            item.put((Object)"datatypeCategory", (Object)ReferenceResolver.generateDatatypeCategory(dtStr));
            item.put((Object)"highlevelDatatype", (Object)ReferenceResolver.generateHighLevelDatatype(dtStr));
            String moserFunctionType = MoserCommandUtil.getNamedValue(functionSpec, MOSER_FUNCTION_TYPE);
            if (moserFunctionType != null && !moserFunctionType.equals("validateAll")) {
                item.put((Object)NULLABLE, (Object)column.getNullsOK());
            }
        }
        MoserCommandAdapter.generateValidateResponse((RequestEnvironment)executionEnvironment.getRequestEnvironment(), null, false);
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.INFO, "Response for valid expression:" + jObj.toString());
        }
        itemEle.setText(jObj.toString());
        return elemResponse;
    }

    private String resolveUsageBasedOnDataType(IDataType columnDt) {
        if (columnDt.isNumeric()) {
            return "fact";
        }
        return ATTRIBUTE;
    }
}

