/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.model.ICubePasswordSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IOIDCSignon;
import com.cognos.xqe.data.model.ITicketSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IFolder;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.mdquery.MDQueryAdapter;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.moser.GenerateModuleMetadataForPackage;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.Pair;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.Multiset;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.Struct;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.axis.encoding.Base64;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public class MFW4JImporter
extends GenerateModuleMetadataForPackage {
    private static final String CM_DATA_SOURCE = "cmDataSource";
    private static final String DATA_SOURCE_TYPE = "dataSourceType";
    private static final String PROVIDER_CODE = "providerCode";
    private static final String JSON = "JSON";
    private static final String OLAP = "OLAP";
    private static final String CATALOG = "catalog";
    private static final String SCHEMA = "schema";
    private static final String QUOTE = "'";
    private static final String CLOSE_ELEM = "\"/>";
    private static final String ENCRYPTED_VALUE_ELEM = "<encryptedValue value=\"";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final ObjectFactory FACTORY = new ObjectFactory();
    private static final String CATALOG_COMMAND = "<command><connection><dataSource value=\"%1$s\"/><dataSourceType value=\"%2$s\"/><runLocale value=\"%3$s\"/><productLocale value=\"%4$s\"/>%5$s</connection><metadata class=\"Catalog\" depth=\"0\" resultCount=\"0\" resultStart=\"0\" returnSchema=\"false\"><properties><property name=\"./@Catalog_Name\"/></properties></metadata></command>";
    private static final String CATALOG_CUBES_COMMAND = "<command><connection><dataSource value=\"%1$s\"/><dataSourceType value=\"%2$s\"/><runLocale value=\"%3$s\"/><productLocale value=\"%4$s\"/>%5$s<catalog value=\"%6$s\"/></connection><metadata class=\"Cube\" depth=\"0\" resultCount=\"0\" resultStart=\"0\" returnSchema=\"false\"><properties><property name=\"./@Cube_Name\"/><property name=\"./@Is_Optimized\"/></properties><constraints><constraint condition=\".[@Catalog_Name='%6$s']\"/></constraints></metadata></command>";
    protected String dataSourceCatalog = null;
    protected String dataSourceSchema = null;
    protected String dataSourceType = null;
    protected JSONObject mdExceptions = null;
    private ExecutionEnvironment execEnv;
    private String providerCode;

    protected MFW4JImporter(ExecutionEnvironment env) {
        this.execEnv = env;
    }

    protected String getCmDataSource() {
        return this.cmDataSource;
    }

    protected MetadataConnection getConnection() {
        if (this.connection == null) {
            this.connection = MetadataService.getInstance().getConnection(this.dataSourceType, this.cmDataSource, this.execEnv, Boolean.TRUE);
        }
        return this.connection;
    }

    @Override
    protected void setCommandParameters(ExecutionEnvironment env, Element functionSpec) {
        for (Object o : functionSpec.elements()) {
            Pair keyValue = MoserCommandUtil.getNameAndValueMap((Element)o);
            if (keyValue == null) continue;
            if (CM_DATA_SOURCE.equals(keyValue.getFirst())) {
                this.cmDataSource = (String)keyValue.getSecond();
                continue;
            }
            if (DATA_SOURCE_TYPE.equals(keyValue.getFirst())) {
                this.dataSourceType = (String)keyValue.getSecond();
                continue;
            }
            if (CATALOG.equals(keyValue.getFirst())) {
                this.dataSourceCatalog = (String)keyValue.getSecond();
                continue;
            }
            if (SCHEMA.equals(keyValue.getFirst())) {
                this.dataSourceSchema = (String)keyValue.getSecond();
                continue;
            }
            if (PROVIDER_CODE.equals(keyValue.getFirst())) {
                this.providerCode = (String)keyValue.getSecond();
                continue;
            }
            if (!"jsonPrettyPrint".equals(keyValue.getFirst())) continue;
            String booleanValue = (String)keyValue.getSecond();
            this.setPrettyPrint(Boolean.parseBoolean(booleanValue));
        }
        if (this.cmDataSource == null && !JSON.equals(this.dataSourceType)) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidMoserCommandSpec, (Object)"getPackageMetadata", (Object)"1", (Object)0);
        }
        this.mdResponse = new JSONObject();
        this.mdExceptions = new JSONObject();
    }

    private Element generateMetadataResponse() {
        return this.generateMetadataResponse(this.mdResponse.toString());
    }

    public static Element getCatalogsAndSchemas(ExecutionEnvironment environment, Element functionSpec) {
        MFW4JImporter generator = new MFW4JImporter(environment);
        generator.setCommandParameters(environment, functionSpec);
        if (JSON.equals(generator.getDataSourceType())) {
            return generator.getCatalogsAndSchemasJSON();
        }
        if (OLAP.equals(generator.getDataSourceType())) {
            return generator.getCatalogsAndSchemasOLAP();
        }
        return null;
    }

    private Element getCatalogsAndSchemasOLAP() {
        List<String> catalogs = this.getCatalogsOLAP();
        JSONObject jResponse = new JSONObject();
        JSONArray jCatalogs = new JSONArray();
        jResponse.put((Object)"catalogs", (Object)jCatalogs);
        for (String catalog : catalogs) {
            JSONObject jCatalog = new JSONObject();
            List<String> cubes = this.getCatalogCubes(catalog);
            jCatalog.put((Object)"name", (Object)catalog);
            JSONArray jCubes = new JSONArray();
            for (String cube : cubes) {
                jCubes.add((Object)cube);
            }
            jCatalog.put((Object)"cubes", (Object)jCubes);
            jCatalogs.add((Object)jCatalog);
        }
        return this.generateMetadataResponse(jResponse.toString());
    }

    private List<String> getCatalogsOLAP() {
        MDQueryAdapter adapter = new MDQueryAdapter();
        try {
            String response = adapter.execute((RequestEnvironment)this.execEnv.getRequestEnvironment(), this.getCatalogsCommand());
            return this.extractFromResponse(response, "Catalog_Name");
        }
        catch (SAXException e) {
            throw new XQERuntimeException(e);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    private List<String> getCatalogCubes(String catalog) {
        MDQueryAdapter adapter = new MDQueryAdapter();
        try {
            String response = adapter.execute((RequestEnvironment)this.execEnv.getRequestEnvironment(), this.getCatalogCubesCommand(catalog));
            return this.extractFromResponse(response, "Cube_Name");
        }
        catch (SAXException e) {
            throw new XQERuntimeException(e);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    private List<String> extractFromResponse(String response, String property) throws SAXException, IOException {
        ArrayList<String> catalogs = new ArrayList<String>();
        String jsonResponse = JSONUtil.convertXMLToJSON(response, "UTF-8");
        JSONObject jResponse = JSONObject.parse((String)jsonResponse);
        Object jEntityObj = (jResponse = (JSONObject)jResponse.get((Object)"response")).get((Object)"entity");
        if (jEntityObj != null) {
            if (jEntityObj instanceof JSONArray) {
                JSONArray jEntities = (JSONArray)jEntityObj;
                for (Object c : jEntities) {
                    JSONObject jEntity = (JSONObject)c;
                    catalogs.add((String)jEntity.get((Object)property));
                }
            } else {
                JSONObject jCatalog = (JSONObject)jEntityObj;
                catalogs.add((String)jCatalog.get((Object)property));
            }
        }
        return catalogs;
    }

    private String getCatalogsCommand() {
        String escapedCMDataSourceName = StringEscapeUtils.escapeXml((String)this.cmDataSource);
        return String.format(CATALOG_COMMAND, escapedCMDataSourceName, DataSourceTypeEnum.getProviderName(this.getProviderCode()), ((RequestEnvironment)this.execEnv.getRequestEnvironment()).getRunLocale().toString(), ((RequestEnvironment)this.execEnv.getRequestEnvironment()).getProductLocale().toString(), this.getConnectionParameters());
    }

    private String createConnectionParametersFromConnectionString(String connString) {
        Map<String, Object> connParms = ConnectionUtil.extractKeyValuePairs(connString);
        StringBuffer parms = new StringBuffer();
        for (Map.Entry<String, Object> entry : connParms.entrySet()) {
            parms.append("<").append(entry.getKey()).append(" value=\"").append((String)entry.getValue()).append(CLOSE_ELEM);
        }
        return parms.toString();
    }

    private String getCatalogCubesCommand(String catalog) {
        String escapedCMDataSourceName = StringEscapeUtils.escapeXml((String)this.cmDataSource);
        return String.format(CATALOG_CUBES_COMMAND, escapedCMDataSourceName, DataSourceTypeEnum.getProviderName(this.getProviderCode()), ((RequestEnvironment)this.execEnv.getRequestEnvironment()).getRunLocale().toString(), ((RequestEnvironment)this.execEnv.getRequestEnvironment()).getProductLocale().toString(), this.getConnectionParameters(), catalog);
    }

    private String getConnectionParameters() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        IDataSource ds = this.execEnv.getOrAddDataSource(this.cmDataSource, this.cmDataSource, null, props);
        IDataSourceConnection conn = ds.getDataSourceConnection();
        StringBuffer connParmBuf = new StringBuffer();
        String connString = conn.getConnectionString();
        connParmBuf.append(this.createConnectionParametersFromConnectionString(connString));
        connParmBuf.append(this.getCredentialsFromSignon(conn));
        return connParmBuf.toString();
    }

    public String getCredentialsFromSignon(IDataSourceConnection conn) {
        StringBuffer credBuf = new StringBuffer();
        IDataSourceConnectionSignon signon = conn.getSignon();
        if (signon != null) {
            switch (signon.getType()) {
                case TICKET: {
                    ITicketSignon sapTicketSignon = (ITicketSignon)signon;
                    sapTicketSignon.getTicket();
                    credBuf.append("<SAPLogonTicket value=\"").append(sapTicketSignon.getTicket()).append(CLOSE_ELEM);
                    break;
                }
                case USERNAME_PASSWORD: {
                    IUsernamePasswordSignon up = (IUsernamePasswordSignon)signon;
                    credBuf.append("<username value=\"").append(up.getUserName()).append(CLOSE_ELEM).append("<password value=\"\">").append(ENCRYPTED_VALUE_ELEM).append(Base64.encode((byte[])up.getPassword().getSecureData())).append(CLOSE_ELEM).append("</password>");
                    break;
                }
                case CUBE_PASSWORD: {
                    ICubePasswordSignon cp = (ICubePasswordSignon)signon;
                    credBuf.append("<cubePassword value=\"").append(Base64.encode((byte[])cp.getPassword().getSecureData())).append(CLOSE_ELEM);
                    break;
                }
                case OIDC: {
                    IOIDCSignon oidc = (IOIDCSignon)signon;
                    credBuf.append("<oidcAccessToken value=\"\">").append(ENCRYPTED_VALUE_ELEM).append(Base64.encode((byte[])oidc.getAccessToken().getSecureData())).append(CLOSE_ELEM).append("</oidcAccessToken>");
                    credBuf.append("<oidcIdToken value=\"\">").append(ENCRYPTED_VALUE_ELEM).append(Base64.encode((byte[])oidc.getIdToken().getSecureData())).append(CLOSE_ELEM).append("</oidcIdToken>");
                    break;
                }
            }
        }
        return credBuf.toString();
    }

    private String getProviderCode() {
        return this.providerCode;
    }

    private String getDataSourceType() {
        return this.dataSourceType;
    }

    public Element getCatalogsAndSchemasJSON() {
        MetadataConnection connection = this.getConnection();
        INamespace rootNS = connection.getRootNamespace();
        this.extractSchema(rootNS);
        return this.generateMetadataResponse();
    }

    public static Element getTables(ExecutionEnvironment environment, Element functionSpec) {
        MFW4JImporter generator = new MFW4JImporter(environment);
        generator.setCommandParameters(environment, functionSpec);
        MetadataConnection connection = generator.getConnection();
        INamespace rootNS = connection.getRootNamespace();
        LinkedList<IMetadata> stack = new LinkedList<IMetadata>();
        generator.visitMetadataObject(rootNS, false, stack);
        generator.extractQuerySubjects();
        return generator.generateMetadataResponse();
    }

    public static Element doImport(ExecutionEnvironment environment, Element functionSpec) {
        MFW4JImporter generator = new MFW4JImporter(environment);
        generator.setCommandParameters(environment, functionSpec);
        MetadataConnection connection = generator.getConnection();
        INamespace rootNS = connection.getRootNamespace();
        Module module = FACTORY.createModule();
        module.setIdentifier(rootNS.getName());
        module.setDescription("Generated module for JSON dataSource '" + generator.getCmDataSource() + QUOTE);
        module.setContainer("com.cognos.phys");
        DataSource dataSource = FACTORY.createDataSource();
        module.getDataSource().add(dataSource);
        dataSource.setName(generator.getCmDataSource());
        dataSource.setSchema(rootNS.getName());
        dataSource.setDescription("Generated datasource for JSON module named '" + generator.getCmDataSource() + QUOTE);
        dataSource.setCmDataSource(generator.getCmDataSource());
        LinkedList<IMetadata> stack = new LinkedList<IMetadata>();
        generator.visitMetadataObject(rootNS, false, stack);
        generator.createTables(dataSource);
        String encodedModule = generator.encode(module);
        return generator.generateMetadataResponse(encodedModule);
    }

    protected void extractSchema(IMetadata nameSpace) {
        this.mdResponse.put((Object)"Schema", (Object)nameSpace.getName());
    }

    protected void extractQuerySubjects() {
        JSONArray tables = new JSONArray();
        for (IMetadata qs : this.getQuerySubjects()) {
            tables.add((Object)qs.getName());
        }
        this.mdResponse.put((Object)"Tables:", (Object)tables);
    }

    List<IMetadata> getQuerySubjects() {
        ArrayList<IMetadata> qsList = new ArrayList<IMetadata>();
        for (int objPos = 0; objPos < this.allObjects.size(); ++objPos) {
            ArrayList objChain = (ArrayList)this.allObjects.get(objPos);
            IMetadata obj = (IMetadata)objChain.get(objChain.size() - 1);
            if (obj.getObjectType() != MetadataType.QUERY_SUBJECT) continue;
            qsList.add(obj);
        }
        return qsList;
    }

    protected void createTables(DataSource dataSource) {
        for (IMetadata obj : this.getQuerySubjects()) {
            Table table = FACTORY.createTable();
            dataSource.getTable().add(table);
            table.setName(obj.getName());
            List<IMetadata> children = obj.getChildMetadataObjects();
            for (IMetadata child : children) {
                TableItemType tableItem = this.createTableItem(child);
                table.getTableItem().add(tableItem);
            }
        }
    }

    protected TableItemType createTableItem(IMetadata object) {
        MetadataType tp = object.getObjectType();
        if (tp == MetadataType.QUERY_ITEM) {
            IQueryItem qi = (IQueryItem)object;
            Column column = FACTORY.createColumn();
            TableItemType tableItem = FACTORY.createTableItemType();
            tableItem.setColumn(column);
            column.setName(qi.getName());
            column.setNullable(Boolean.valueOf(qi.isNullable()));
            IDataType dt = qi.getDataType();
            if (dt != null) {
                column.setDatatype(dt.toString());
            }
            return tableItem;
        }
        if (tp == MetadataType.FOLDER) {
            IFolder folder = (IFolder)object;
            IDataType folderType = folder.getDataType();
            TableItemType tableItem = FACTORY.createTableItemType();
            if (folderType instanceof MultisetType) {
                Multiset multiset = FACTORY.createMultiset();
                tableItem.setMultiset(multiset);
                multiset.setName(folder.getName());
                List<IMetadata> children = object.getChildMetadataObjects();
                for (IMetadata child : children) {
                    TableItemType innerTableItem = this.createTableItem(child);
                    multiset.getTableItem().add(innerTableItem);
                }
            } else if (folderType instanceof StructType) {
                Struct struct = FACTORY.createStruct();
                tableItem.setStruct(struct);
                struct.setName(folder.getName());
                List<IMetadata> children = object.getChildMetadataObjects();
                for (IMetadata child : children) {
                    TableItemType innerTableItem = this.createTableItem(child);
                    struct.getTableItem().add(innerTableItem);
                }
            }
            return tableItem;
        }
        return null;
    }

    public String encode(Module module) {
        String encodedString = null;
        try {
            encodedString = module.toJSON().serialize(true);
        }
        catch (IOException e) {
            mErrorLogger.log(e);
        }
        return encodedString;
    }
}

