/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public final class MoserCommandUtil {
    public static final XQELogger INFO_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MoserCommand", LogLevel.INFO);
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String ITEM = "item";
    public static final String DATATYPECATEGORY = "datatypeCategory";
    public static final String HIGHLEVELDATATYPE = "highlevelDatatype";
    public static final String OFFSET = "offset";
    public static final String DEFAULT_OFFSET = "0";
    public static final String LIMIT = "limit";
    public static final String UNRESOLVEDPARAM_RESPONSE = "unresolvedParameterResponse";
    public static final String UNRESOLVEDPARAM_RESULT = "unresolvedParameterResult";
    private static final String JSONPRETTY = "jsonPrettyPrint";
    private static final String CONNECTIONS = "connections";
    private static final String CONNECTION = "connection";
    private static final String DATASOURCE = "datasource";
    private static final String SIGNON = "signon";
    public static final String MODULE = "module";
    public static final String MOSER_COMMAND_RESPONSE = "moserCommandResponse";
    public static final String MOSER_COMMAND_RESULT = "moserCommandResult";
    public static final String VALIDATE_RESPONSE = "validateResponse";
    public static final String VALIDATE_RESULT = "validateResult";
    private static final String MODULETYPE = "moduleType";
    public static final String EXPRESSIONS = "expressions";

    private MoserCommandUtil() {
    }

    public static Pair getNameAndValueMap(Element ele) {
        HashMap<String, String> mp = new HashMap<String, String>();
        for (Object o : ele.elements()) {
            Element e = (Element)o;
            mp.put(e.getName(), e.getText());
        }
        String key = (String)mp.get(NAME);
        String value = (String)mp.get(VALUE);
        if (key == null || value == null) {
            return null;
        }
        return new Pair(key, value);
    }

    public static String getNamedValue(Element elem, String valueName) {
        for (Object item : elem.elements()) {
            Element name = ((Element)item).element(NAME);
            if (!name.getStringValue().equals(valueName)) continue;
            return ((Element)item).element(VALUE).getStringValue();
        }
        return null;
    }

    public static String generateColumnNameForRespones(IMetadata md) {
        if (md instanceof MoserBaseMetadata) {
            return md.getName();
        }
        return UniqueNameGenerator.createSingleNamePart(md.getName());
    }

    public static boolean getPrettyPrint(Element functionSpec) {
        boolean prettyPrint = false;
        String prettyPrintStr = MoserCommandUtil.getNamedValue(functionSpec, JSONPRETTY);
        if (prettyPrintStr != null) {
            prettyPrint = Boolean.valueOf(prettyPrintStr);
        }
        return prettyPrint;
    }

    public static void logMoserCommandSpec(Element spec) {
        if (INFO_LOGGER.isOn()) {
            String msg;
            try {
                msg = XMLUtils.toString((Node)spec);
            }
            catch (IOException e) {
                msg = "Invalid Moser Command Spec.";
            }
            INFO_LOGGER.log(msg);
        }
    }

    public static void setConnections(RequestEnvironment reqEnv, String connectionSpec) {
        Element connectionTopElem = MoserCommandUtil.convertToDOM(connectionSpec);
        if (connectionTopElem == null) {
            return;
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        execEnv.setConnectionElement(connectionTopElem);
    }

    public static Element convertToDOM(String jsonConnection) {
        if (jsonConnection == null) {
            return null;
        }
        JSONObject jConnSpec = null;
        try {
            jConnSpec = JSONObject.parse((String)jsonConnection);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        if (jConnSpec == null) {
            return null;
        }
        Object jArray = jConnSpec.get((Object)CONNECTIONS);
        if (!(jArray instanceof JSONArray)) {
            return null;
        }
        JSONArray connections = (JSONArray)jConnSpec.get((Object)CONNECTIONS);
        if (connections == null || connections.isEmpty()) {
            return null;
        }
        Element connectionTopElem = DocumentHelper.createElement((String)CONNECTION);
        for (Object c : connections) {
            JSONObject connection = (JSONObject)c;
            Element connectionElem = connectionTopElem.addElement(CONNECTION);
            Element dsTypeElem = connectionElem.addElement("dataSourceType");
            dsTypeElem.addAttribute(VALUE, "Database");
            Element nameElem = connectionElem.addElement(NAME);
            nameElem.addAttribute(VALUE, (String)connection.get((Object)CONNECTION));
            Element dataSourceElem = connectionElem.addElement("dataSource");
            dataSourceElem.addAttribute(VALUE, (String)connection.get((Object)DATASOURCE));
            String signon = (String)connection.get((Object)SIGNON);
            if (signon == null) continue;
            Element signonElem = connectionElem.addElement(SIGNON);
            Element nameElement = signonElem.addElement(NAME);
            nameElement.addAttribute(VALUE, signon);
        }
        return connectionTopElem;
    }

    public static String extractResponse(Element rst, String moserFunctionType, String[] error) {
        String response = null;
        String result = null;
        if ("validate".equals(moserFunctionType) || "validateAll".equals(moserFunctionType)) {
            response = VALIDATE_RESPONSE;
            result = VALIDATE_RESULT;
        } else if ("describeDataSourceQuery".equals(moserFunctionType) || "extractIdentifiers".equals(moserFunctionType) || "joingraph".equals(moserFunctionType)) {
            response = MOSER_COMMAND_RESPONSE;
            result = MOSER_COMMAND_RESULT;
        } else if ("expandMacros".equals(moserFunctionType)) {
            response = "expandMacroResponse";
            result = "expandMacroResult";
        } else if ("getTableStatistics".equals(moserFunctionType)) {
            response = "getTableValuesResponse";
            result = "getTableValuesResult";
        } else {
            if (error != null) {
                error[0] = "todo";
            }
            return null;
        }
        List items = rst.selectNodes(response);
        if (items == null || items.isEmpty()) {
            if (error != null) {
                error[0] = "Missing Response element";
            }
            return null;
        }
        Element responseElem = (Element)items.get(0);
        if ((items = responseElem.selectNodes(result)) == null || items.isEmpty()) {
            if (error != null) {
                error[0] = "Missing Result element";
            }
            return null;
        }
        if ((items = ((Node)items.get(0)).selectNodes(ITEM)) == null || items.isEmpty()) {
            if (error != null) {
                error[0] = "Missing Results";
            }
            return null;
        }
        return ((Node)items.get(0)).getText();
    }

    public static MetadataConnection getMetadataConnection(ExecutionEnvironment execEnv, Element functionSpec) {
        String providerType = "MFW4J";
        if (MODULE.equals(MoserCommandUtil.getNamedValue(functionSpec, MODULETYPE))) {
            providerType = "MOSER";
        }
        return MetadataService.getInstance().getConnection(providerType, MoserCommandUtil.getNamedValue(functionSpec, "modelPath"), execEnv, true);
    }

    public static List<String> parseJsonArrayString(String json) {
        if (json == null) {
            return null;
        }
        try {
            JSONArray jsonArray = JSONArray.parse((String)json);
            if (jsonArray != null && !jsonArray.isEmpty()) {
                ArrayList<String> retArray = new ArrayList<String>();
                for (Object o : jsonArray) {
                    retArray.add((String)o);
                }
                return retArray;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static List<String> getExpressionsToExpand(Element functionSpec) {
        String json = MoserCommandUtil.getNamedValue(functionSpec, EXPRESSIONS);
        return MoserCommandUtil.parseJsonArrayString(json);
    }

    public static String getStringValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List lst = (List)o;
            if (lst.isEmpty()) {
                return null;
            }
            JSONArray r = new JSONArray();
            for (Object v : lst) {
                String s = (String)v;
                r.add((Object)s);
            }
            String sr = null;
            try {
                sr = r.serialize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return sr;
        }
        return String.valueOf(o);
    }

    public static String getConnectionValue(List<String[]> sConns) {
        JSONObject jConns = new JSONObject();
        JSONArray jConnArray = new JSONArray();
        for (String[] s : sConns) {
            JSONObject jC = new JSONObject();
            if (s.length >= 1 && s[0] != null) {
                jC.put((Object)DATASOURCE, (Object)s[0]);
            }
            if (s.length >= 2 && s[1] != null) {
                jC.put((Object)CONNECTION, (Object)s[1]);
            }
            if (s.length >= 3 && s[2] != null) {
                jC.put((Object)SIGNON, (Object)s[2]);
            }
            jConnArray.add((Object)jC);
        }
        jConns.put((Object)CONNECTIONS, (Object)jConnArray);
        return jConns.toString();
    }
}

