/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser.util;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContextManager;
import com.cognos.xqe.transformation.moser.GenerateJoinGraph;
import com.cognos.xqe.util.ArrayWrapper;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.concurrent.ThreadPool;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class JoinGraphCache {
    private static final long DEFAULT_MAX_SIZE_CACHE = 100L;
    private static final long DEFAULT_MAX_MINUTES_IN_CACHE = 60L;
    private static final long MAX_SIZE_PP = 500L;
    private LoadingCache<String, ReentrantReadWriteLock> ppCache;
    private Cache<ArrayWrapper<Object>, CacheJoinGraph> cache;
    private long preloadThredhold = -1L;
    private long maxCacheSize;
    private long expireAfterAccess;
    private static SingletonHelper<JoinGraphCache> singletonHelper = new SingletonHelper<JoinGraphCache>(){

        @Override
        protected JoinGraphCache newInstance() {
            return new JoinGraphCache();
        }

        @Override
        protected void releaseImpl(JoinGraphCache theInstance) {
        }

        @Override
        protected void initializeImpl(JoinGraphCache theInstance) {
            XQEConfiguration cfg = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            theInstance.preloadThredhold = cfg.getLongProperty("metadataService.joinGraph[@preloadThredhold]", 500L);
            theInstance.maxCacheSize = cfg.getLongProperty("metadataService.joinGraph[@maxCacheSize]", 100L);
            theInstance.expireAfterAccess = cfg.getLongProperty("metadataService.joinGraph[@expireAfterAccess]", 60L);
            if (theInstance.maxCacheSize > 0L && theInstance.expireAfterAccess > 0L) {
                CacheLoader<String, ReentrantReadWriteLock> loader = new CacheLoader<String, ReentrantReadWriteLock>(){

                    public ReentrantReadWriteLock load(String key) {
                        return new ReentrantReadWriteLock();
                    }
                };
                theInstance.ppCache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterAccess(theInstance.expireAfterAccess, TimeUnit.MINUTES).build((CacheLoader)loader);
                theInstance.cache = CacheBuilder.newBuilder().maximumSize(theInstance.maxCacheSize).expireAfterAccess(theInstance.expireAfterAccess, TimeUnit.MINUTES).build();
            }
        }
    };

    private JoinGraphCache() {
    }

    public static JoinGraphCache getInstance() {
        return singletonHelper.getInstance();
    }

    /*
     * Exception decompiling
     */
    public static String zip(String str) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String unzip(String compressed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setPreloadThreshold(long l) {
        this.preloadThredhold = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCacheJoinGraphIfExists(RequestEnvironment reqEnv, MetadataConnection connection) {
        if (this.ppCache == null) {
            return null;
        }
        String passport = reqEnv.getCAMPassport();
        ArrayWrapper<Object> key = new ArrayWrapper<Object>(passport, connection.getModelName());
        String rt = null;
        boolean bEvict = false;
        ReentrantReadWriteLock lck = (ReentrantReadWriteLock)this.ppCache.getUnchecked((Object)passport);
        lck.readLock().lock();
        try {
            CacheJoinGraph p = (CacheJoinGraph)this.cache.getIfPresent(key);
            if (p != null) {
                BIBusEnvelope envelope = reqEnv.getRequestEnvelope();
                long lastmod = CubeContextManager.getCubeContextManager().getModelModificationTime(connection, passport, envelope);
                if (lastmod == p.lastModelModificationTime) {
                    rt = p.sJoinGraph;
                } else {
                    bEvict = true;
                }
            }
        }
        finally {
            lck.readLock().unlock();
        }
        if (bEvict) {
            lck.writeLock().lock();
            try {
                this.cache.invalidate(key);
            }
            finally {
                lck.writeLock().unlock();
            }
        }
        return rt;
    }

    public void cacheJoinGraph(ExecutionEnvironment env, GenerateJoinGraph.InfoClass joinGraphCollector) {
        if (this.ppCache == null) {
            return;
        }
        if (this.preloadThredhold < 0L) {
            return;
        }
        if (joinGraphCollector == null) {
            return;
        }
        int nObjs = joinGraphCollector.computeNumberOfObjects();
        if ((long)nObjs <= this.preloadThredhold) {
            return;
        }
        JoinGraphPreloader loader = new JoinGraphPreloader(env, joinGraphCollector);
        ThreadPool.getInstance().submit(loader);
    }

    private class JoinGraphPreloader
    implements Callable<Boolean> {
        private ExecutionEnvironment execEnv;
        private GenerateJoinGraph.InfoClass info;

        private JoinGraphPreloader(ExecutionEnvironment env, GenerateJoinGraph.InfoClass joinGraphCollector) {
            this.execEnv = env;
            this.info = joinGraphCollector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            RequestEnvironment newReqEnv = ((RequestEnvironment)this.execEnv.getRequestEnvironment()).duplicatePartial();
            MultiRequestContext multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(newReqEnv, null);
            ExecutionEnvironment newExecEnv = (ExecutionEnvironment)newReqEnv.getExecutionEnvironment();
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(newExecEnv);
            multiRequestContext.incrementRefCount();
            JoinGraphCache jgCache = JoinGraphCache.getInstance();
            MetadataConnection mc = this.info.getMetadataConnection();
            String jg = jgCache.getCacheJoinGraphIfExists(newReqEnv, mc);
            if (jg != null) {
                multiRequestContext.decrementRefCount();
                executionEnvironmentContext.exit();
                return Boolean.TRUE;
            }
            String passport = newReqEnv.getCAMPassport();
            ReentrantReadWriteLock lck = (ReentrantReadWriteLock)jgCache.ppCache.getUnchecked((Object)passport);
            lck.writeLock().lock();
            try {
                jg = GenerateJoinGraph.preloadJoinGraph(newExecEnv, this.info);
                if (jg != null) {
                    ArrayWrapper<Object> key = new ArrayWrapper<Object>(passport, mc.getModelName());
                    BIBusEnvelope envelope = newReqEnv.getRequestEnvelope();
                    CacheJoinGraph newCacheJoinGraph = new CacheJoinGraph();
                    newCacheJoinGraph.lastModelModificationTime = CubeContextManager.getCubeContextManager().getModelModificationTime(mc, passport, envelope);
                    newCacheJoinGraph.sJoinGraph = jg;
                    jgCache.cache.put(key, (Object)newCacheJoinGraph);
                }
            }
            finally {
                lck.writeLock().unlock();
                multiRequestContext.decrementRefCount();
                executionEnvironmentContext.exit();
            }
            return Boolean.TRUE;
        }
    }

    protected static final class CacheJoinGraph {
        protected String sJoinGraph;
        protected long lastModelModificationTime;

        protected CacheJoinGraph() {
        }
    }
}

