/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeIndex;
import com.cognos.xqe.ast.localprocessing.v5.V5MasterDetailWindow;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public final class DisableMDOptimizationWhenDetailContextDependentOnMaster
extends Transformation {
    public DisableMDOptimizationWhenDetailContextDependentOnMaster() {
        this.mName = "Disable m-d optimization when sets projects in detail query context depend on hierarchy projected in master query.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{601026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5MasterDetailWindow mdwCombined = (V5MasterDetailWindow)node;
        XQENodeIndex nodeIndex = environment.getNodeIndex();
        V5MasterDetailWindow mdwDetail = (V5MasterDetailWindow)nodeIndex.getNodeByID(mdwCombined.getMasterDetailWindowNodeIDDetail());
        mdwDetail.extract();
        V5MasterDetailWindow mdwMaster = (V5MasterDetailWindow)nodeIndex.getNodeByID(mdwCombined.getMasterDetailWindowNodeIDMaster());
        if (mdwMaster != null) {
            mdwMaster.extract();
        }
        node.getAncestorOfType(401005).detach();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        boolean bl = status = ((V5MasterDetailWindow)node).getMasterDetailWindowNodeIDCombined() == node.getId().intValue();
        if (status) {
            this.traceQueryCondition(status, "The node is in the combined query.", trace);
        } else {
            this.traceQueryCondition(status, "The node is not in the combined query.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        List<IXQEQueryNode> mdxQueries = node.getDescendantsOfCategory(1002, false);
        if (mdxQueries.size() != 1) {
            node.throwInternalError("m-d optimization resulted in more than 1 query, this is not expected.");
        }
        MDXQuery mdxQuery = (MDXQuery)mdxQueries.get(0);
        MDXEdge masterEdge = mdxQuery.getEdges()[mdxQuery.getNumberOfEdges() - 1];
        MDXEdge[] edges = mdxQuery.getEdges();
        MDXLevelInfo levelInfoMaster = masterEdge.getLevelInfo();
        MDXHierInfo hierarchyInfoMaster = levelInfoMaster.getHierarchyInfo();
        List<IHierarchy> projectedMasterHierarchies = hierarchyInfoMaster.getProjectedHierarchies();
        boolean bContextDependent = false;
        for (IHierarchy hierarchy : projectedMasterHierarchies) {
            block1: for (int i = 0; i < edges.length - 1; ++i) {
                IXQEQueryNode[] groups;
                MDXEdge detailEdge = edges[i];
                for (IXQEQueryNode group : groups = detailEdge.getDescendantsOfTypes(new int[]{1027, 1026}, false)) {
                    ((AbstractMDXNode)group).throwOnInvalidChildCategories();
                    AbstractMDXSet groupSet = (AbstractMDXSet)group.getChild(0);
                    if (!groupSet.isContextDependent(hierarchy)) continue;
                    bContextDependent = true;
                    continue block1;
                }
            }
        }
        status = bContextDependent;
        if (status) {
            this.traceNodeCondition(status, "Detail query projects set context dependent on data item projected in master.", trace);
        } else {
            this.traceNodeCondition(status, "Detail query projects set context independent of master.", trace);
        }
        return status;
    }
}

