/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.aggregation_distribution;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.aggregation_distribution.IntersectCogMDXAggreagateWithMeasures;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.ArrayList;

public class DistributeMDXSummaryFunction
extends Transformation {
    public DistributeMDXSummaryFunction() {
        this.mName = "Distribute MDXSummaryFunction through numeric value expression when needed.";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{1012};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ArrayList<AbstractMDXMember> contextMembers;
        AbstractMDXValueExpression newNumValExpr;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXAggregate cogMDXAggregate = (CogMDXAggregate)node;
        AbstractMDXNumericValueExpression numValExpr = (AbstractMDXNumericValueExpression)cogMDXAggregate.getChild(1);
        MDXCalculatedMemberDefinition definition = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        int solveOrder = SolveOrderUtil.getMaxV5SolveOrder();
        if (definition != null) {
            solveOrder = definition.getSolveOrder();
        }
        if ((newNumValExpr = numValExpr.distributeCogMDXAggregate(cogMDXAggregate, solveOrder, contextMembers = new ArrayList<AbstractMDXMember>(), nodeFactory)) == null) {
            node.throwInternalError("");
        }
        cogMDXAggregate.getParent().exchangeChildNode(cogMDXAggregate, newNumValExpr);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        StringBuilder traceMsg = new StringBuilder();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            traceMsg.append("The node is");
            traceMsg.append(" ");
            traceMsg.append("not");
            traceMsg.append(" ");
            traceMsg.append("within a MDXQuery node.");
            this.traceNodeCondition(false, traceMsg.toString(), trace);
            return false;
        }
        boolean status = DistributeMDXSummaryFunction.nodeCondition(mdxQuery, node, traceMsg);
        this.traceNodeCondition(status, traceMsg.toString(), trace);
        return status;
    }

    static boolean nodeCondition(MDXQuery mdxQuery, IXQEQueryNode node, StringBuilder traceMsg) {
        String aggrDistributionNotRequired = "Aggregate distribution is not required.";
        if (node.getNumberChildren() == 1) {
            if (traceMsg != null) {
                traceMsg.append(aggrDistributionNotRequired);
            }
            return false;
        }
        boolean status = true;
        CogMDXAggregate cogMDXAggregate = (CogMDXAggregate)node;
        AbstractMDXValueExpression valueExpr = (AbstractMDXValueExpression)cogMDXAggregate.getChild(1);
        MDXHierInfo secondChildHierInfo = valueExpr.getResolvedHierarchyInfo(valueExpr);
        boolean hasMeasureValueExpr = secondChildHierInfo.projectsMeasures();
        if (!hasMeasureValueExpr && mdxQuery.getHierarchyInfo().projectsMeasures() && cogMDXAggregate.getIntersectingMeasures().isEmpty()) {
            if (traceMsg != null) {
                traceMsg.append("Node's second child has no measures. ");
                traceMsg.append("The MDXQuery projectes measures and the ");
                traceMsg.append("'intersectingMeasures' property have not been set yet.");
            }
            status = false;
        } else {
            boolean bl = status = !IntersectCogMDXAggreagateWithMeasures.nodeCondition(mdxQuery, node, null);
            if (status) {
                V5RollupAggregateEnum rollupAggregate = ((AbstractMDXNode)node.getChild(1)).getRollupAggregate();
                boolean bl2 = status = rollupAggregate == V5RollupAggregateEnum.CALCULATED || rollupAggregate == V5RollupAggregateEnum.UNDEFINED;
                if (traceMsg != null) {
                    if (status) {
                        traceMsg.append("Aggregate distribution is required");
                    } else {
                        traceMsg.append("The AbstractMDXNumericValueExpression child does not require aggregate distribution.");
                    }
                }
            } else if (traceMsg != null) {
                traceMsg.append("Intersection with measures is required first.");
            }
        }
        return status;
    }
}

