/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.alternatemeasure;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5AlternateMeasureCellUpdate;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeAlternateMeasure;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.v5.cellupdate.XV5AlternateMeasureCellUpdate;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.transformation.olap.intersecting_wds.CheckLowerSOWDS;
import com.cognos.xqe.transformation.olap.intersecting_wds.IntersectingWDSUtil;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.List;

public final class BuildAlternateMeasureCalculations
extends Transformation {
    public BuildAlternateMeasureCalculations() {
        this.mName = "Builds Alternate Measure Calculations.";
        this.mPassNumbers = new int[]{25};
        this.mTypes = new int[]{1170};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeAlternateMeasure tNodeAltMeasure = (TNodeAlternateMeasure)node;
        AbstractMDXMember measure = tNodeAltMeasure.getMeasure();
        MDXCalculatedMemberReference nlCalcReference = tNodeAltMeasure.getNLCalcReference();
        ArrayList<MDXCalculatedMemberReference> calcsSortedBySolveOrder = new ArrayList<MDXCalculatedMemberReference>();
        List<MDXCalculatedMemberReference> intersectingCalcs = tNodeAltMeasure.getIntersectingCalcs();
        calcsSortedBySolveOrder.add(nlCalcReference);
        if (intersectingCalcs != null) {
            for (MDXCalculatedMemberReference intersectingCalc : tNodeAltMeasure.getIntersectingCalcs()) {
                boolean calcAdded = false;
                for (MDXCalculatedMemberReference sortedCalc : calcsSortedBySolveOrder) {
                    if (intersectingCalc.getSolveOrder() >= sortedCalc.getSolveOrder()) continue;
                    calcsSortedBySolveOrder.add(calcsSortedBySolveOrder.indexOf(sortedCalc), intersectingCalc);
                    calcAdded = true;
                    break;
                }
                if (calcAdded) continue;
                calcsSortedBySolveOrder.add(intersectingCalc);
            }
        }
        ArrayList<MDXCalculatedMemberReference> alternateMeasures = new ArrayList<MDXCalculatedMemberReference>();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        ArrayList<MDXCalculatedMemberReference> postIntWDSCalcs = new ArrayList<MDXCalculatedMemberReference>();
        postIntWDSCalcs.addAll(calcsSortedBySolveOrder);
        if (IntersectingWDSUtil.isWithinDetailCalc(nlCalcReference)) {
            for (int i = 0; i < calcsSortedBySolveOrder.size(); ++i) {
                MDXCalculatedMemberReference sortedCalc = (MDXCalculatedMemberReference)calcsSortedBySolveOrder.get(i);
                if (sortedCalc == nlCalcReference) continue;
                if (sortedCalc.getSolveOrder() < nlCalcReference.getSolveOrder() && CheckLowerSOWDS.isSimpleWithinDetailCalc(sortedCalc)) {
                    if (postIntWDSCalcs.size() > 2) {
                        nlCalcReference.throwInternalError("The intersection of two within detail calculations intersects with another calculation. Cannot create alternate measure.");
                    }
                    this.buildTNodeMergeIntersectingWDS(sortedCalc, nlCalcReference, nodeFactory, measure, mdxQuery, alternateMeasures);
                    postIntWDSCalcs.remove(sortedCalc);
                    postIntWDSCalcs.remove(nlCalcReference);
                    continue;
                }
                if (!IntersectingWDSUtil.isWithinDetailCalc(sortedCalc) || !CheckLowerSOWDS.isSimpleWithinDetailCalc(nlCalcReference)) continue;
                if (postIntWDSCalcs.size() > 2) {
                    nlCalcReference.throwInternalError("The intersection of two within detail calculations intersects with another calculation. Cannot create alternate measure.");
                }
                this.buildTNodeMergeIntersectingWDS(nlCalcReference, sortedCalc, nodeFactory, measure, mdxQuery, alternateMeasures);
                postIntWDSCalcs.remove(sortedCalc);
                postIntWDSCalcs.remove(nlCalcReference);
            }
        }
        for (MDXCalculatedMemberReference postIntWDSCalc : postIntWDSCalcs) {
            int solveOrder = postIntWDSCalc.getSolveOrder();
            MDXCalculatedMemberReference alternateMeasure = null;
            AbstractMDXNode calcDef = (AbstractMDXNode)postIntWDSCalc.getDefinition().getChild(0);
            AbstractMDXNode calcDefCopy = (AbstractMDXNode)nodeFactory.deepCopyNode(calcDef);
            AbstractMDXMember measureForContext = null;
            measureForContext = alternateMeasures.size() == 0 ? measure : (AbstractMDXMember)alternateMeasures.get(alternateMeasures.size() - 1);
            IHierarchy calculatedMemberHierarchy = measure.getHierarchy();
            calcDefCopy.addMemberToContext(nodeFactory, measureForContext, true);
            alternateMeasure = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, calculatedMemberHierarchy, "_AM", calcDefCopy, solveOrder + 2);
            alternateMeasure.setIsAlternateMeasureRef(true);
            alternateMeasures.add(alternateMeasure);
        }
        MDXCalculatedMemberReference projectedAltMeasureRef = (MDXCalculatedMemberReference)alternateMeasures.get(alternateMeasures.size() - 1);
        CogMDXGroup measureGroup = (CogMDXGroup)tNodeAltMeasure.getAncestorOfType(1027);
        MDXCalculatedMemberDefinition projectedAltMeasureDef = projectedAltMeasureRef.getDefinition();
        projectedAltMeasureDef.setPropertyValue("v5Name", projectedAltMeasureDef.getUniqueName());
        node.getParent().addChild(projectedAltMeasureRef);
        this.buildV5AlternateMeasureCellUpdateDeco(nodeFactory, tNodeAltMeasure, measureGroup, projectedAltMeasureDef);
        node.extract();
    }

    private void buildTNodeMergeIntersectingWDS(MDXCalculatedMemberReference lowerSOCalc, MDXCalculatedMemberReference higherSOCalc, IXQENodeFactory nodeFactory, AbstractMDXMember measure, MDXQuery mdxQuery, List<MDXCalculatedMemberReference> alternateMeasures) {
        AbstractMDXValueExpression sortedCalcDefCopy = (AbstractMDXValueExpression)nodeFactory.deepCopyNode(higherSOCalc.getDefinition().getChild(0));
        AbstractMDXNumericValueFunction interCalcDefCopy = (AbstractMDXNumericValueFunction)nodeFactory.deepCopyNode(lowerSOCalc.getDefinition().getChild(0));
        AbstractMDXNode tNodeMerge = null;
        tNodeMerge = (AbstractMDXNode)nodeFactory.createNode(1121);
        tNodeMerge.addChild(sortedCalcDefCopy);
        tNodeMerge.addChild(interCalcDefCopy);
        IHierarchy calculatedMemberHierarchy = measure.getHierarchy();
        sortedCalcDefCopy.addMemberToContext(nodeFactory, measure, true);
        MDXCalculatedMemberReference alternateMeasure = MDXBuilder.buildMDXCalculatedMemberReference(nodeFactory, mdxQuery, calculatedMemberHierarchy, "_AM", tNodeMerge, higherSOCalc.getSolveOrder() + 2);
        alternateMeasures.add(alternateMeasure);
        alternateMeasure.setIsAlternateMeasureRef(true);
    }

    private void buildV5AlternateMeasureCellUpdateDeco(IXQENodeFactory nodeFactory, TNodeAlternateMeasure tNodeAltMeasure, CogMDXGroup measureGroup, MDXCalculatedMemberDefinition projectedAltMeasureDef) {
        RSAPIDataset rsapiDataset = (RSAPIDataset)tNodeAltMeasure.getAncestorOfType(401005);
        V5AlternateMeasureCellUpdate cellUpdateNode = null;
        int descendantType = 601025;
        IXQEQueryNode[] nodeCellUpdate = rsapiDataset.getDescendantsOfType(descendantType, false);
        if (nodeCellUpdate.length == 0) {
            cellUpdateNode = (V5AlternateMeasureCellUpdate)nodeFactory.createNode(601025);
            rsapiDataset.getChild(0).insertParent(cellUpdateNode);
        } else {
            cellUpdateNode = (V5AlternateMeasureCellUpdate)nodeCellUpdate[0];
        }
        RSAPIEdgeRowset measureRowset = measureGroup.getRSAPIEdgeRowset();
        int rowsetId = measureRowset.getRowsetId();
        int edgeNumber = measureRowset.getEdge().getPositionalOrdinal();
        int dataItemOrdinal = measureRowset.getDataItemOrdinal(measureGroup.getFirstRSAPIDataItem());
        String v5Name = null;
        AbstractMDXMember measure = tNodeAltMeasure.getMeasure();
        if (measure.getType() == 1067) {
            BaseMember baseMeasure = (BaseMember)measure;
            v5Name = baseMeasure.getMember().getV5UniqueName();
        } else if (measure.getType() == 1013 && ((MDXCalculatedMemberReference)measure).isV5CalculatedMember()) {
            MDXCalculatedMemberReference calcMeasureRef = (MDXCalculatedMemberReference)measure;
            v5Name = (String)calcMeasureRef.getDefinition().getPropertyValue("v5Name");
        } else {
            v5Name = null;
        }
        XV5CellSpec primaryCellSpec = new XV5CellSpec(edgeNumber, rowsetId, dataItemOrdinal, v5Name);
        XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule updateRule = new XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule(primaryCellSpec);
        v5Name = (String)projectedAltMeasureDef.getPropertyValue("v5Name");
        XV5CellSpec altMeasureCellSpec = new XV5CellSpec(edgeNumber, rowsetId, dataItemOrdinal, v5Name);
        updateRule.setAlternateMeasureCellSpec(altMeasureCellSpec);
        MDXCalculatedMemberReference nlcCalcRef = tNodeAltMeasure.getNLCalcReference();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)nlcCalcRef.getAncestorOfCategory(1027);
        RSAPIEdgeRowset rowset = cogMDXGroup.getRSAPIEdgeRowset();
        edgeNumber = rowset.getEdge().getPositionalOrdinal();
        rowsetId = rowset.getRowsetId();
        dataItemOrdinal = rowset.getDataItemOrdinal(cogMDXGroup.getFirstRSAPIDataItem());
        v5Name = nlcCalcRef.isV5CalculatedMember() ? (String)nlcCalcRef.getDefinition().getPropertyValue("v5Name") : null;
        XV5CellSpec nlcCellSpec = new XV5CellSpec(edgeNumber, rowsetId, dataItemOrdinal, v5Name);
        updateRule.addIntersectingCellSpec(nlcCellSpec);
        List<MDXCalculatedMemberReference> intersectingCalcs = tNodeAltMeasure.getIntersectingCalcs();
        if (intersectingCalcs != null) {
            for (MDXCalculatedMemberReference intersectingCalcRef : intersectingCalcs) {
                CogMDXGroup parentGroup = (CogMDXGroup)intersectingCalcRef.getAncestorOfType(1027);
                rowset = parentGroup.getRSAPIEdgeRowset();
                edgeNumber = rowset.getEdge().getPositionalOrdinal();
                rowsetId = rowset.getRowsetId();
                dataItemOrdinal = measureRowset.getDataItemOrdinal(parentGroup.getFirstRSAPIDataItem());
                v5Name = intersectingCalcRef.isV5CalculatedMember() ? (String)intersectingCalcRef.getDefinition().getPropertyValue("v5Name") : null;
                XV5CellSpec calcCellSpec = new XV5CellSpec(edgeNumber, rowsetId, dataItemOrdinal, v5Name);
                updateRule.addIntersectingCellSpec(calcCellSpec);
            }
        }
        cellUpdateNode.addCellUpdateRule(updateRule);
    }
}

