/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.alternatemeasure;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.TNodeAlternateMeasure;
import com.cognos.xqe.ast.olap.TNodeNestedLevelCalcReplacement;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.intersecting_wds.IntersectingWDSUtil;
import com.cognos.xqe.transformation.olap.util.CollectMeasuresIntersectingWithProjCalcUtil;
import com.cognos.xqe.transformation.olap.util.CollectTreeNodesForCondition;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class CreateAlternateMeasureCandidates
extends Transformation {
    public CreateAlternateMeasureCandidates() {
        this.mName = "Creates the Alternate Measure Candidate Nodes.";
        this.mPassNumbers = new int[]{25};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXCalculatedMemberReference nlCalc = (MDXCalculatedMemberReference)node;
        IHierarchy calcHierarchy = nlCalc.getHierarchy();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        HashSet<AbstractMDXMember> intersectingMeasures = new HashSet<AbstractMDXMember>();
        CollectMeasuresIntersectingWithProjCalcUtil.addProjMeasuresIntersectingWithRefToCalcDef(nlCalc.getDefinition(), mdxQuery, intersectingMeasures);
        HashSet<IXQEQueryNode> intersectingCalcRefs = new HashSet<IXQEQueryNode>();
        CollectTreeNodesForCondition.getProjectedReferenceForDiffHierarchy(intersectingCalcRefs, mdxQuery, calcHierarchy);
        HashMap<IHierarchy, ArrayList<MDXCalculatedMemberReference>> mapCalcByHier = new HashMap<IHierarchy, ArrayList<MDXCalculatedMemberReference>>();
        for (MDXCalculatedMemberReference mDXCalculatedMemberReference : intersectingCalcRefs) {
            if (mDXCalculatedMemberReference.getSolveOrder() > nlCalc.getSolveOrder() && (!IntersectingWDSUtil.isWithinDetailCalc(mDXCalculatedMemberReference) || !IntersectingWDSUtil.isWithinDetailCalc(nlCalc))) continue;
            ArrayList<MDXCalculatedMemberReference> currCalcList = (ArrayList<MDXCalculatedMemberReference>)mapCalcByHier.get(mDXCalculatedMemberReference.getHierarchy());
            if (currCalcList == null) {
                currCalcList = new ArrayList<MDXCalculatedMemberReference>();
            }
            currCalcList.add(mDXCalculatedMemberReference);
            mapCalcByHier.put(mDXCalculatedMemberReference.getHierarchy(), currCalcList);
        }
        TNodeNestedLevelCalcReplacement tNodeNestedLevelCalcReplacement = (TNodeNestedLevelCalcReplacement)nodeFactory.createNode(1171);
        ArrayList<TNodeAlternateMeasure> tNodeAlternateMeasures = new ArrayList<TNodeAlternateMeasure>();
        for (AbstractMDXMember intersectingMeasure : intersectingMeasures) {
            TNodeAlternateMeasure tNodeAltMeasure = (TNodeAlternateMeasure)nodeFactory.createNode(1170);
            tNodeAltMeasure.setNLCalcReference(nlCalc);
            tNodeAltMeasure.setMeasure(intersectingMeasure);
            tNodeAltMeasure.setNLCalcReplacement(tNodeNestedLevelCalcReplacement);
            tNodeAlternateMeasures.add(tNodeAltMeasure);
        }
        Set hierSet = mapCalcByHier.keySet();
        Iterator itHier = hierSet.iterator();
        while (itHier.hasNext()) {
            ArrayList<TNodeAlternateMeasure> listcopy = new ArrayList<TNodeAlternateMeasure>();
            listcopy.addAll(tNodeAlternateMeasures);
            IHierarchy currHier = (IHierarchy)itHier.next();
            List currCalcList = (List)mapCalcByHier.get(currHier);
            for (MDXCalculatedMemberReference intersectingCalcRef : currCalcList) {
                if (!this.areIntersectingCalcRef(nlCalc, intersectingCalcRef)) continue;
                for (TNodeAlternateMeasure currTNode : listcopy) {
                    List<MDXCalculatedMemberReference> currIntersecCalcRefs = currTNode.getIntersectingCalcs();
                    if (currIntersecCalcRefs != null && !currIntersecCalcRefs.isEmpty()) {
                        Iterator<MDXCalculatedMemberReference> itcurrIntersecCalcRef = currIntersecCalcRefs.iterator();
                        boolean doNotAdd = false;
                        while (itcurrIntersecCalcRef.hasNext()) {
                            MDXCalculatedMemberReference currIntersecCalcRef = itcurrIntersecCalcRef.next();
                            doNotAdd = doNotAdd || !this.areIntersectingCalcRef(intersectingCalcRef, currIntersecCalcRef);
                        }
                        if (doNotAdd) continue;
                    }
                    TNodeAlternateMeasure tNodeAltMeasure = (TNodeAlternateMeasure)nodeFactory.copyNode(currTNode);
                    tNodeAltMeasure.setIntersectingCalc(intersectingCalcRef);
                    tNodeAlternateMeasures.add(tNodeAltMeasure);
                }
            }
        }
        for (TNodeAlternateMeasure currTNodeAMC : tNodeAlternateMeasures) {
            AbstractMDXMember currMeasure = currTNodeAMC.getMeasure();
            MDXSet currMeasureSet = this.getParentMDXSet(currMeasure, nodeFactory);
            currMeasureSet.addChildAfterNode(currTNodeAMC, currMeasure);
        }
        MDXCurrentMember currentMember = MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, calcHierarchy);
        currentMember.setNLCReplacement(true);
        currentMember.setIsV5CalculatedMember(nlCalc.isV5CalculatedMember());
        currentMember.setV5Name(nlCalc.getDefinition().getV5Name());
        currentMember.setV5Caption(nlCalc.getDefinition().getV5Caption());
        currentMember.setOriginalMUN(nlCalc.getUniqueName());
        tNodeNestedLevelCalcReplacement.addChild(currentMember);
        tNodeNestedLevelCalcReplacement.setNLCalcReference(nlCalc);
        node.exchange(tNodeNestedLevelCalcReplacement);
        tNodeNestedLevelCalcReplacement.addChild(node);
    }

    private boolean areIntersectingCalcRef(MDXCalculatedMemberReference calcRef, MDXCalculatedMemberReference aNode) {
        MDXEdge intersecCalcEdge;
        MDXEdge mdxEdge = (MDXEdge)calcRef.getAncestorOfType(1006);
        if (mdxEdge != (intersecCalcEdge = (MDXEdge)aNode.getAncestorOfType(1006))) {
            return true;
        }
        return mdxEdge.areIntersectingProjDescendants(aNode, calcRef);
    }

    private MDXSet getParentMDXSet(AbstractMDXMember node, IXQENodeFactory nodeFactory) {
        AbstractMDXNode parentSet = (AbstractMDXNode)node.getParent();
        AbstractMDXNode tuple = null;
        if (parentSet.getType() != 1039) {
            if (parentSet.getType() == 1069) {
                tuple = parentSet;
                parentSet = (AbstractMDXNode)tuple.getParent();
            } else {
                parentSet.throwInternalError("!= OLAPNodeTypeEnum.MDX_SET && != OLAPNodeTypeEnum.MDX_TUPLE");
            }
            if (parentSet.getType() != 1039) {
                parentSet = (MDXSet)nodeFactory.createNode(1039);
                if (tuple != null) {
                    tuple.insertParent(parentSet);
                } else {
                    node.insertParent(parentSet);
                }
            }
        }
        return (MDXSet)parentSet;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        StringBuilder msgStr = new StringBuilder("The node is");
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append("within a MDXQuery node.");
            status = false;
        } else {
            MDXEdge mdxEdge = (MDXEdge)node.getAncestorOfType(1006);
            if (mdxEdge == null) {
                msgStr.append(" ");
                msgStr.append("not");
                msgStr.append(" ");
                msgStr.append("within a MDXEdge node.");
                status = false;
            } else {
                msgStr.append(" ");
                msgStr.append("within both a MDXQuery and a MDXEdge node.");
                status = true;
            }
        }
        this.traceQueryCondition(status, msgStr.toString(), trace);
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getParent().getType() == 1171) {
            this.traceNodeCondition(false, "The node has been processed already.", trace);
            return false;
        }
        String traceMsg = "The target node is not flagged as a nested level calculation.";
        boolean result = false;
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        if (calcRef.getDefinition().isNestedLevelCalc()) {
            MDXEdge mdxEdge = (MDXEdge)node.getAncestorOfType(1006);
            if (mdxEdge.isProjectedDescendant(calcRef)) {
                traceMsg = "The target node is projected and flagged as a nested level calculation.";
                result = true;
            } else {
                traceMsg = "The target node is not projected.";
                result = false;
            }
            this.traceNodeCondition(result, traceMsg, trace);
            return result;
        }
        this.traceNodeCondition(result, traceMsg, trace);
        return result;
    }
}

