/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.axisgeneration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ConvertCogMDXNestOnMeasuresToCogMDXGroup
extends Transformation {
    public ConvertCogMDXNestOnMeasuresToCogMDXGroup() {
        this.mName = "Convert CogMDXNest On Measures To CogMDXGroup";
        this.mPassNumbers = new int[]{34};
        this.mTypes = new int[]{1026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)nodeFactory.createNode(1027);
        CogMDXNest cogMDXNest = (CogMDXNest)node;
        cogMDXGroup.setRSAPIDataItemList(cogMDXNest.getRSAPIDataItemList());
        cogMDXGroup.setDataItemIndexesProjectingSameSet(cogMDXNest.getDataItemIndexesProjectingSameSet());
        cogMDXGroup.setRSAPIEdgeRowset(cogMDXNest.getRSAPIEdgeRowset());
        CogMDXReportSummary.updateRefSummary(cogMDXNest, cogMDXGroup);
        cogMDXNest.exchange(cogMDXGroup, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The target CogMDXNest node does not have a single operand.", trace);
            return false;
        }
        if (node.getFirstDescendantOfTypeOrdered(1026, false) != null || node.getAncestorOfType(1026) != null) {
            this.traceNodeCondition(false, "The target CogMDXNest node has a descendant or ancestor nest node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target CogMDXNest node are invalid", trace);
            return false;
        }
        AbstractMDXSet set = (AbstractMDXSet)node.getChild(0);
        if (set.isValidPlannedQuery() != -1) {
            this.traceNodeCondition(false, "The child node is not a valid MDX expression.", trace);
            return false;
        }
        MDXHierInfo hierInfo = set.getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() != 1 || !hierInfo.getProjectedHierarchy(0).getDimension().isMeasuresDimension()) {
            this.traceNodeCondition(false, "The set operand of the target CogMDXNest node does project the Measures hierarchy.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target CogMDXNest node can be converted to a CogMDXGroup node.", trace);
        return true;
    }
}

