/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.axisgeneration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeBuildTagTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class PrepareOuterNestedGroupDiffHierarchy
extends Transformation {
    public static final String PROP_TRANSFORMATION_APPLIED = "PrepareOuterNestedGroupDiffHierarchyApplied";

    public PrepareOuterNestedGroupDiffHierarchy() {
        this.mName = "Prepare Outer Nested Group Different Hierarchy.";
        this.mPassNumbers = new int[]{38};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXGroup targetGroup = (CogMDXGroup)node;
        MDXHierInfo firstSetHierInfo = ((AbstractMDXSet)targetGroup.getChild(0)).getHierarchyInfo();
        AbstractMDXSet detailSet = (AbstractMDXSet)targetGroup.getChild(1);
        if (detailSet.isContextDependent(firstSetHierInfo.getProjectedHierarchy(0))) {
            boolean injectTags;
            IXQEQueryNode mdxSet = factory.createNode(1039);
            mdxSet.addChild(MDXBuilder.buildCurrentMemberTuple(factory, (MDXQuery)targetGroup.getAncestorOfType(1002), firstSetHierInfo.getProjectedHierarchies()));
            MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
            detailSet.insertParent(mdxCrossjoin);
            mdxCrossjoin.addChild(mdxSet, 0);
            boolean bl = injectTags = !targetGroup.projectDetailsOnly() && !targetGroup.projectNonDetailsOnly() && targetGroup.getTagType() == "eachTuple" && !targetGroup.isEmpty();
            if (injectTags) {
                TNodeBuildTagTuple tNodeBuildTagTuple = (TNodeBuildTagTuple)factory.createNode(1124);
                tNodeBuildTagTuple.setTagType(targetGroup.getTagType());
                tNodeBuildTagTuple.addHierarchy(firstSetHierInfo.getProjectedHierarchy(0));
                tNodeBuildTagTuple.setCogMDXGroup(targetGroup);
                mdxSet.addChild(tNodeBuildTagTuple, 0);
            }
        }
        targetGroup.setPropertyValue(PROP_TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(PROP_TRANSFORMATION_APPLIED) == Boolean.TRUE || node.getPropertyValue("PrepareOuterNestedGroupSameHierarchyApplied") == Boolean.TRUE) {
            this.traceNodeCondition(false, "Either PrepareNestedGroupDiffHierarchy or PrepareOuterNestedGroupSameHierarchy has already been applied to the target CogMDXGroup node.", trace);
            return false;
        }
        if (node.getDescendantsOfType(1026, false).length > 0) {
            this.traceNodeCondition(false, "There descendants CogMDXNest nodes of the target CogMDXGroup node.", trace);
            return false;
        }
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target CogMDXGroup node are invalid.", trace);
            return false;
        }
        if (node.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "The target CogMDXGroup node does not project two set operands.", trace);
            return false;
        }
        MDXHierInfo firstSetHierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        if (firstSetHierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The first AbstractMDXSet operand of target CogMDXGroup node does not project a single hierarchy.", trace);
            return false;
        }
        MDXHierInfo secondSetHierInfo = ((AbstractMDXSet)node.getChild(1)).getHierarchyInfo();
        if (firstSetHierInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The second AbstractMDXSet operand of target CogMDXGroup node does not project a single hierarchy.", trace);
            return false;
        }
        if (firstSetHierInfo.projectedHierarchiesOverlap(secondSetHierInfo)) {
            this.traceNodeCondition(false, "The hierarchies projected by the AbstractMDXSet operands of target CogMDXGroup node overlap.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The hierarchies projected by the AbstractMDXSet operands of target CogMDXGroup node do not overlap.", trace);
        return true;
    }
}

