/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.axisgeneration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;

public final class RejectGroupedCalculationNestingOtherSameHierCalculation
extends Transformation {
    public RejectGroupedCalculationNestingOtherSameHierCalculation() {
        this.mName = "Rejects grouped calculations nesting other calculation of the same hiearchy.";
        this.mPassNumbers = new int[]{33};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target CogMDXGroup node are invalid", trace);
            return false;
        }
        IXQEQueryNode[] ancestorGroups = node.getAncestorsOfType(1027);
        this.lookForSameHierNestedCalculations((CogMDXGroup)node, ancestorGroups);
        return false;
    }

    private void lookForSameHierNestedCalculations(CogMDXGroup targetGroup, IXQEQueryNode[] nestedGroups) {
        AbstractMDXSet projset = (AbstractMDXSet)targetGroup.getChild(0);
        MDXLevelInfo levelInfo = projset.getLevelInfo();
        IHierarchy hierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        levelInfo.removeCalculationLevels();
        if (!levelInfo.projectsLevels() && projset.projectsCalculatedMember() && !projset.projectsNonCalculatedMember()) {
            for (IXQEQueryNode nestedGroup : nestedGroups) {
                AbstractMDXSet nestedProjset = (AbstractMDXSet)nestedGroup.getChild(0);
                if (!nestedProjset.projectsCalculatedMember() || nestedProjset.projectsNonCalculatedMember() || !((AbstractMDXSet)nestedGroup).isProjectedDescendant(targetGroup) || !nestedProjset.getHierarchyInfo().projectsHierarchy(hierarchy)) continue;
                String dataItem1 = targetGroup.getRefDataItemProperty();
                String dataItem2 = ((CogMDXGroup)nestedGroup).getRefDataItemProperty();
                MDXQuery mdxQuery = (MDXQuery)targetGroup.getAncestorOfType(1002);
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_UnsupportedNestedSameHierCalc, mdxQuery.getV5NameProperty(), (Object)hierarchy.getCaption(), (Object)dataItem1, (Object)dataItem2);
            }
        }
    }
}

